/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.backup.ejb.session.interfaces;

import java.util.Collection;


public interface BackupManagerInterface {

    	public static final String BACKUP_DB_EXTENSION = "pgdump";
    	public static final String BACKUP_FILE_EXTENSION = "fileszip";
    	public static final String BACKUP_DICOM_EXTENSION = "dicomzip";
    	public static final String BACKUP_COMPLETE_EXTENSION = "completezip";
    	public static final String BACKUP_LETTERTEMPLATE_EXTENSION = "lettertemplatezip";

    	
	public boolean checkPassword(String user, String password);
	
	public void doBackup(long timestamp) throws Exception ;
	
	public void doFileBackup(long timestamp) throws Exception ;
	
	public void doDicomBackup(long timestamp) throws Exception ;
	
	public void doLetterTemplateBackup(long timestamp) throws Exception ;
	
	public Collection<FileInfo> listBackups() throws Exception ;
	
	public byte[] getBackupFile(String fileName) throws Exception ;
	
	public void deleteFile(String fileName) throws Exception ;
	
	public void startAutoBackup (boolean doDbBackup, boolean doFileBackup, boolean doDicomBackup, boolean doTemplateBackup, int keepBackups, String usersToNotify);

	public String getOutput();
	
}
