/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.backup.ejb.session.interfaces;

import java.io.File;
import java.io.Serializable;

public class FileInfo implements Serializable, Comparable<FileInfo>{

	private static final long serialVersionUID = 1L;
	private File file;
	private long lastModified;
	private long length;

	public FileInfo(File f) {
		this.file = f;
		this.lastModified = f.lastModified();
		this.length = f.length();
	}

	/**
	 * @return the lastModified
	 */
	public long lastModified() {
		return lastModified;
	}


	/**
	 * @return the length
	 */
	public long length() {
		return length;
	}


	/**
	 * @return the file
	 */
	public File getFile() {
		return file;
	}


	public int compareTo(FileInfo o) {
		if (this.lastModified > o.lastModified)
			return -1;
		else 
			return 1; 
	}

	public String getName() {
		return file.getName();
	}
	
}
