///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
//package lu.tudor.santec.gecamed.backup.servlet;
//import java.io.BufferedOutputStream;
//import java.io.File;
//import java.io.IOException;
//import java.io.PrintWriter;
//import java.util.ArrayList;
//import java.util.Collection;
//import java.util.Iterator;
//
//import javax.naming.InitialContext;
//import javax.servlet.ServletException;
//import javax.servlet.http.HttpServlet;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import javax.servlet.http.HttpSession;
//
//import lu.tudor.santec.gecamed.backup.ejb.session.interfaces.BackupManagerInterface;
//import lu.tudor.santec.gecamed.backup.ejb.session.interfaces.FileInfo;
//
//
///**
// * 
// * 
// *
// * @author Johannes Hermen johannes.hermen(at)tudor.lu
// *
// * @version
// * <br>$Log: DBBackupServlet.java,v $
// * <br>Revision 1.6  2008-09-25 09:42:42  heinemann
// * <br>fixed copyrights
// * <br>
// * <br>Revision 1.5  2008-04-14 12:39:17  hermen
// * <br>extended backup to external files
// * <br>
// * <br>Revision 1.4  2008-03-27 14:15:24  hermen
// * <br>added fileinfo obj.
// * <br>
// * <br>Revision 1.3  2008-03-27 13:41:53  hermen
// * <br>added database backup dialog
// * <br>
// * <br>Revision 1.2  2008-03-26 13:58:06  hermen
// * <br>moved backup servlet
// * <br>
// * <br>Revision 1.1  2008-03-26 13:45:46  hermen
// * <br>moved backup servlet
// * <br>
// * <br>Revision 1.2  2008-03-25 14:36:06  hermen
// * <br>checkin of backup funktionality
// * <br>
// * <br>Revision 1.1  2008-03-11 15:23:44  hermen
// * <br>initial checkin of backup servlet
// * <br>
// *
// */
//public class DBBackupServlet extends HttpServlet {
//
//	private static final long serialVersionUID = 1L;
//	
//	public static String SERVLET_NAME =  "/management/dbbackup";
//
//	private HttpSession session;
//
//	private BackupManagerInterface backupManager;
//	
//	/* (non-Javadoc)
//	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
//	 */
//	public void doPost(HttpServletRequest request, HttpServletResponse response)
//	throws ServletException, IOException {
//		doGet(request, response);
//	}
//	
//	/* (non-Javadoc)
//	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
//	 */
//	public void doGet(HttpServletRequest request, HttpServletResponse response)
//			throws ServletException, IOException {
//		
//		// get Session or create it
//		session = request.getSession(true);
//		String auth = (String) session.getAttribute("auth");
//		if (! "ok".equals(auth)) {
//			if (request.getParameter("dologin") != null) {
//				doLogin(request, response);
//			} else {
//				showLogin(request, response);
//			}
//			return;
//		}
//		
//		if (request.getParameter("logout") != null) {
//			session.setAttribute("auth", "false");
//			session.invalidate();
//			showLogin(request, response);
//		} else 	if (request.getParameter("download") != null) {
//			String download = (String) request.getParameter("download");
//			doDownload(response, download);
//		} else if (request.getParameter("dobackup") != null) {
//			doBackup(response);
//		} 
//	}
//
//	/**
//	 * show the login page
//	 * @param request
//	 * @param response
//	 * @throws IOException
//	 */
//	private void showLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
//		response.setContentType("text/html");
//		final PrintWriter out = response.getWriter();
//		writeHeader(out);
//		writeLoginScreen(request, out);
//		writeFooter(out);
//		out.flush();
//		out.close();
//	}
//
//	/**
//	 * do login and show faild or ok page
//	 * @param request
//	 * @param response
//	 * @throws IOException
//	 */
//	private void doLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
//		response.setContentType("text/html");
//		final PrintWriter out = response.getWriter();
//		writeHeader(out);
//
//		String user = request.getParameter("user");
//		String password = request.getParameter("password");
//
//		
//		if (! getManager().checkPassword(user, password)) {
//			out.println("<center><p><span style=\"color:red\">Wrong user/password, try again!</span></p></center>");
//			writeLoginScreen(request, out);
//			return;
//		}
//
//		session.setAttribute("auth", "ok");
//		
//		writeStartBackupButton(out);
//		writeFileList(out);
//		
//		writeLogoutButton(out);
//		
//		writeFooter(out);
//		out.flush();
//		out.close();
//	}
//
//	/**
//	 * just download the provided file to the browser
//	 * @param response
//	 * @param download
//	 * @throws IOException
//	 */
//	private void doDownload(HttpServletResponse response, String download) throws IOException {
//		response.setContentType("application/x-tar");
//		response.addHeader("Content-Disposition", "attachment; filename="
//				+ download);
//		BufferedOutputStream out = new BufferedOutputStream(response.getOutputStream());
//		try {
//			out.write(getManager().getBackupFile(download));
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		out.flush();
//		out.close();
//	}
//
//	/**
//	 * trigger the backup and show a list of the available backup files
//	 * @param response
//	 * @throws IOException
//	 */
//	private void doBackup(HttpServletResponse response) throws IOException {
//		
//		response.setContentType("text/html");
//		final PrintWriter out = response.getWriter();
//		
//		writeHeader(out);
//
//		try {
//			out.print("running Database Backup...<br>");
//			out.flush();	
//
//			File backupFile = getManager().doBackup(System.currentTimeMillis());
//	 		
//			out.println("<br>");
//			out.println("<span style=\"color:green\">Backup finished! <br></span><br>");
//			out.println("<p>click <a href=\""+ SERVLET_NAME + "?download="+ backupFile.getName() +"\">Download Backup</a> to download the file to your computer.  Filesize is: "  + (backupFile.length()/1024) + "kb</p>");
//			writeFileList(out);
//		} catch (Exception e) {
//			out.println("<span style=\"color:red\">Error doing Backup, please check if the backup script exists on the server!</span><br>");
//			out.println(e.getLocalizedMessage());
//		}
//
//		writeLogoutButton(out);
//		
//		writeFooter(out);
//		
//		out.flush();
//		out.close();
//	}
//
//	/**
//	 * write the page header
//	 * @param out
//	 */
//	private void writeHeader(PrintWriter out) {
//		out.println("<html>" +
//					"<head>" +
//						"<title>GECAMed Database Backup</title>" +
//					"</head>" +
//				"<body>" +
//				"<center><h3>GECAMed Database Backup</h3></center>");
//	}
//	
//	/**
//	 * write the page footer
//	 * @param out
//	 */
//	private void writeFooter(PrintWriter out) {
//		out.println("</body>" +
//				"</html>");
//	}
//	
//	/**
//	 * list the available backup files
//	 * @param out
//	 */
//	private void writeFileList(PrintWriter out) {
//		
//		Collection<FileInfo> files = new ArrayList<FileInfo>();
//		try {
//			files = getManager().listBackups();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		
//		out.println("<br><hr>" + 
//				"Recent Backup files: " + 
//				"<br>");
//		
//		for (Iterator iter = files.iterator(); iter.hasNext();) {
//			FileInfo file = (FileInfo) iter.next();
//			out.println("<a href=\""+ SERVLET_NAME + "?download="+ file.getName() +"\">" + file.getName() + "</a> ");
//			out.println("<br>");
//		} 
//		out.println("<hr>");
//	}
//	
//	
//	/**
//	 * write the login form
//	 * @param request
//	 * @param out
//	 */
//	private void writeLoginScreen(HttpServletRequest request, PrintWriter out) {
//		String user = request.getParameter("user");
//		if (user == null)
//			user = "";
//		out.println("<center><table>");
//		out.println("<form action=\"" + SERVLET_NAME + "\" method=\"post\">" +
//				"<input name=\"dologin\" type=\"hidden\">" + 
//				"<tr><td>User:</td><td><input name=\"user\" type=\"text\" size=\"30\" maxlength=\"30\" value=\""+ user + "\"></td></tr>" +
//				"<tr><td>Password:</td><td><input name=\"password\" type=\"password\" size=\"30\" maxlength=\"30\"></td></tr>" +
//				"<tr><td></td><td align=\"right\"><input type=\"submit\" value=\" Login \"></td></tr>" +
//				"</form>");
//		out.println("</table></center>");
//	}
//	
//	/**
//	 * create the startbackup form
//	 * @param out
//	 */
//	private void writeStartBackupButton(PrintWriter out) {
//		out.println("<center><table>");
//		out.println("<form action=\"" + SERVLET_NAME + "\" method=\"post\">" +
//				"<input name=\"dobackup\" type=\"hidden\">" + 
//				"<tr><td></td><td align=\"right\"><input type=\"submit\" value=\" Start Database Backup \"></td></tr>" +
//				"</form>");
//		out.println("</table></center>");
//	}
//	
//	/**
//	 * create the logout button
//	 * @param out
//	 */
//	private void writeLogoutButton(PrintWriter out) {
//		out.println("<center><table>");
//		out.println("<form action=\"" + SERVLET_NAME + "\" method=\"post\">" +
//				"<input name=\"logout\" type=\"hidden\">" + 
//				"<tr><td></td><td align=\"right\"><input type=\"submit\" value=\" Logout \"></td></tr>" +
//				"</form>");
//		out.println("</table></center>");
//	}
//	
//	
//	private BackupManagerInterface getManager() {
//		if (backupManager == null) {
//			try {
//				InitialContext ctx = new InitialContext();
//	 			backupManager  = (BackupManagerInterface) ctx.lookup("management/BackupManagerBean/remote");
//			}	catch (Exception e) 
//	 		{
//				e.printStackTrace();
//	 		}
//		}
//		return backupManager;
//	}
//
//}
