/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * InvoiceTemplates give users the possiblity to define commonly used set of
 * rates for creating invoices. Invoice templates are identified by a shortcut
 * and a descriptive label. Furthermore its possible to define them per user
 * or to make them publicaly available throughout the system
 * 
 * @author johannes.hermen@tudor.lu
 * @author nico.mack@tudor.lu
 * @since 06/12/19
*/

@NamedQueries
	({
	@NamedQuery(name= InvoiceTemplate.c_AllInvoiceTemplates, 	query="SELECT OBJECT(o) FROM InvoiceTemplate o ORDER BY o.sequenceNumber"),
	@NamedQuery(name= InvoiceTemplate.c_InvoiceTemplatesByUser, query="SELECT OBJECT(o) FROM InvoiceTemplate o WHERE o.userId = :userID OR o.userId IS NULL ORDER BY o.sequenceNumber")
	})

@Entity
@Table(name = "template", schema = "billing")

public class InvoiceTemplate extends GECAMedEntityBean implements Serializable 
	{	
	private static final long serialVersionUID = 1L;
	
	private Integer m_UserId;
	private String  m_Label;
	private String  m_Shortcut;
	private Integer m_SequenceNumber;
	
	private Set<TemplateRate> m_TemplateRates = new HashSet<TemplateRate> (0);

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	public static final String	c_AllInvoiceTemplates    = "getAllInvoiceTemplate";
	public static final String	c_InvoiceTemplatesByUser = "getInvoiceTemplatesByUser";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the ID of the user who owns this template.
 * @return The ID of the user owning this template, <code>null</code> if
 * template is considered to be public.
 */
//---------------------------------------------------------------------------
	
@Column(name = "user_id")
public Integer getUserId() 
	{
	return m_UserId;
	}

//---------------------------------------------------------------------------
/**
 * Sets the ID of the user owning this template. Setting ID to <code>null</code>
 * will make this template public, i.e. it can be used by other users as well.
 * @param p_UserId specifies the ID of the user owning this template
 */
//---------------------------------------------------------------------------

public void setUserId(Integer p_UserId) 
	{
	m_UserId = p_UserId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the descriptive label of this template
 * @return the label which describes this template, if available.
 */
//---------------------------------------------------------------------------

@Column(name = "label")
public String getLabel() 
	{
	return m_Label;
	}

//---------------------------------------------------------------------------
/**
 * Sets the label describing this template
 * @param p_Label specifies the descriptive label for this template
 */
//---------------------------------------------------------------------------

public void setLabel(String p_Label) 
	{
	m_Label = p_Label;
	}
	
//---------------------------------------------------------------------------
/**
 * Returns the shortcut defined for this template. Shortcuts are kind of like
 * a mnemonic.
 * @return the shortcut defined for this template.
 */
//---------------------------------------------------------------------------

@Column(name = "shortcut")
public String getShortcut() 
	{
	return m_Shortcut;
	}

//---------------------------------------------------------------------------
/**
 * Sets the shortcut or mnemonic for this template
 * @param p_Shortcut specifies the new shortcut for this template
 */
//---------------------------------------------------------------------------

public void setShortcut(String p_Shortcut) 
	{
	m_Shortcut = p_Shortcut;
	}
	
//---------------------------------------------------------------------------
/**
 * Returns the sequence number of this template. Sequence number define the
 * order in which template will be shown.
 * @return the sequence number of this template
 */
//---------------------------------------------------------------------------

@Column(name = "sequence_number")
public Integer getSequenceNumber() 
	{
	return m_SequenceNumber;
	}

//---------------------------------------------------------------------------
/**
 * Specifies the sequence number for this template
 * @param p_SequenceNumber specifies the new sequence number for this template
 */
//---------------------------------------------------------------------------

public void setSequenceNumber(Integer p_SequenceNumber) 
	{
	m_SequenceNumber = p_SequenceNumber;
	}

//---------------------------------------------------------------------------
/**
 * Returns the rates defined for this template. Returned rates are intended
 * to create new invoices from scratch.
 * @return Rates required to create new invoice from this template 
 */
//---------------------------------------------------------------------------

@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
@JoinColumn(name = "template_id")
public Set<TemplateRate> getTemplateRates() 
	{
	return m_TemplateRates;
	}

//---------------------------------------------------------------------------
/**
 * Sets the rates for this template.
 * @param p_Rates specifies the rates for this invoice template
 */
//---------------------------------------------------------------------------

public void setTemplateRates(Set<TemplateRate> p_Rates) 
	{
	m_TemplateRates = p_Rates;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
