package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


@Entity
@Table(name = "template_rates", schema = "billing")
public class TemplateRate extends GECAMedEntityBean implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private Integer 	templateId;
	
	private Rate 		rate;
	
	private String 		suffixes;
	
	private Integer		quantity;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public TemplateRate ()
	{
		suffixes = "";
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	@Column(name = "template_id", updatable=false, insertable=false)
	public Integer getTemplateId()
	{
		return templateId;
	}
	
	
	public void setTemplateId(Integer templateId)
	{
		this.templateId = templateId;
	}
	
	
	@ManyToOne (fetch = FetchType.EAGER)
	@JoinColumn(name = "rate_id")
	public Rate getRate()
	{
		return rate;
	}
	
	
	public void setRate(Rate rate)
	{
		this.rate = rate;
	}
	

	@Column(name = "suffixes")
	public String getSuffixes()
	{
		return suffixes;
	}
	
	
	public void setSuffixes(String suffixes)
	{
		this.suffixes = suffixes;
	}
	
	
	@Column(name = "quantity")
	public Integer getQuantity()
	{
		return quantity;
	}
	
	
	public void setQuantity(Integer quantity)
	{
		this.quantity = quantity;
	}
}
