/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.beans;

import java.util.Collection;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.NoResultException;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.InvoiceTemplateInterface;
import lu.tudor.santec.gecamed.core.ejb.session.beans.GECAMedSessionBean;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
 * The InvoiceTemplate bean manages access to invoice templates. Invoice templates
 * are collections of rates to generate commonly used invoices.
 * @see InvoiceTemplate class.
 * @author nico.mack@tudor.lu
 */

@Stateless
@Remote({InvoiceTemplateInterface.class})
public class InvoiceTemplateBean extends GECAMedSessionBean implements InvoiceTemplateInterface
	{
//	@PersistenceContext (unitName="gecam")
//	EntityManager m_EntityManager;

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns all invoice templates defined in the database.
 * @return a collection holding all invoice templates defined in the database.
 * Method returns <code>null</code> if none are available.
 */
//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection<InvoiceTemplate> getAllTemplates() throws Exception 
	{
	Collection<InvoiceTemplate>	l_Templates = null;
	
	try	{
		l_Templates = m_EntityManager.createNamedQuery(InvoiceTemplate.c_AllInvoiceTemplates)
						  			 .getResultList();
		}
	catch (NoResultException p_Exception)
		{
		l_Templates = null;
		}
	
	return l_Templates;
	}

//---------------------------------------------------------------------------
/**
 * Returns all invoice templates defined in the database for the specified user.
 * @param p_UserID specifies the Id of the user to get invoice templates for.
 * @return a collection holding all invoice templates defined in the database
 * for the specified user. Method returns <code>null</code> if none are available.
 */
//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection<InvoiceTemplate> getTemplatesByUser (Integer p_UserID) throws Exception 
	{
	Collection<InvoiceTemplate>	l_Templates = null;

	try	{
		l_Templates = m_EntityManager.createNamedQuery(InvoiceTemplate.c_InvoiceTemplatesByUser)
									 .setParameter("userID", p_UserID)
									 .getResultList();
		}
	catch (NoResultException p_Exception)
		{
		l_Templates = null;
		}
	
	return l_Templates;
	}

//---------------------------------------------------------------------------
/**
 * saves the specified invoice template into the database.
 * @param p_Template specifies the invoice template to save.
 * @return method returns the persisted, i.e. saved invoice template.
 */
//---------------------------------------------------------------------------

public InvoiceTemplate saveTemplate (InvoiceTemplate p_Template) throws Exception
	{
	if (p_Template == null) return null;
	
	p_Template = m_EntityManager.merge (p_Template);

	return p_Template;
	}

//---------------------------------------------------------------------------
/**
 * deletes the specified invoice template from the database.
 * @param p_Template specifies the invoice template to delete.
 */	
//---------------------------------------------------------------------------

public void deleteTemplate (InvoiceTemplate p_Template) throws Exception
	{
	if (p_Template.isPersistent())
		{
		p_Template = m_EntityManager.find (InvoiceTemplate.class, p_Template.getId());
		m_EntityManager.remove(p_Template);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
