/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Passage;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The HospitalizedInterface 
* @author nmac
* @since 06/05/02
*
*/

@Remote
public interface HospitalizedInterface 
	{	
	public Passage getPassageById (Integer p_PassageId) throws Exception;
	
	public Act	getActToWithdraw (Passage p_Passage) throws Exception;
	
	public Invoice getInvoiceToWithdrawActFrom (Passage p_Passage) throws Exception;
		
	public Invoice withdrawAct (Act p_Act, Invoice p_Invoice) throws Exception;
	
	public Act	getActToRestore (Passage p_Passage) throws Exception;
	
	public Invoice getInvoiceToRestoreActTo (Passage p_Passage) throws Exception;
	
	public Invoice restoreAct (Act p_Act, Invoice p_Invoice) throws Exception;
	
	public Invoice newInvoiceForPassage (Passage p_Passage) throws Exception;
	
//***************************************************************************
//* End of Interface														*
//***************************************************************************
	}
