/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Rate;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.RateIndex;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Suffix;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The NomenclatureInterface 
* @author nmac
* @since 06/10/13
*
*/

@Remote
public interface NomenclatureInterface 
	{
	
	public Act 						initializeAct (String p_Code, Act p_Act) throws Exception;
	
	public Collection <Suffix> 		getAllSuffixes 				() throws Exception;

	public Collection <KeyValue> 	getAllKeyValues 			() throws Exception;
	
	public Collection<KeyValue> 	getNewestKeyValues			() throws Exception;
	
	public KeyValue 				getKeyValueByTypeAndPerformedDate	(Integer p_Type, Date p_Date) throws Exception;
	
	public HashMap<Integer, Vector<KeyValue>> getAllKeyValuesSorted() throws Exception;
	
	public KeyValue 		   		getKeyValueByID 			(Integer p_ID) throws Exception;
		
	public KeyValue					saveKeyValue 				(KeyValue p_KeyValue) throws Exception;
	
	public void						deleteKeyValue				(KeyValue p_KeyValue) throws Exception;

	public Long						getRateCountByKeyValue		(KeyValue p_KeyValue) throws Exception;
	
//	public Rate 					getRateByCodeAndPerformedDate (String p_Code, Date p_Date) throws Exception;
	
	public Rate 			   		getRateByCode 				(String p_Code, Date p_Date, boolean p_ExtractSuffixes) throws Exception;
	
	public Rate						getRateByCode				(String p_Code, Date p_Date) throws Exception;
	
	public Rate						saveRate					(Rate p_Rate) throws Exception;
	
	public void						deleteRate					(Rate p_Rate) throws Exception;
	
	public Collection <Rate> 		getRatesStartingWith 		(String p_Pattern) throws Exception;
	
	public Collection <Rate> 		getRatesWithExactPhrase  	(String p_Phrase) throws Exception;
	
	public Collection <Rate> 		getRatesWithAllKeywords  	(String[] p_Pattern) throws Exception;
	
	public Collection <Rate> 		getRatesWithAnyKeywords  	(String[] p_Pattern) throws Exception;
	
	public Collection <Rate> 		getRatesWithNoneKeywords 	(String[] p_Pattern) throws Exception;
	
	public Collection <Rate> 		getRatesByWhereClause	 	(WhereClause p_Clause) throws Exception;
 
	public Collection <RateIndex>	getRateIndexRoots	 		() throws Exception;	

	public RateIndex 				getRateIndexByLabel 		(String p_Label) throws Exception;	
	
	public RateIndex 				getRateIndexByID 			(Integer p_RateIndexID) throws Exception;
		
	public RateIndex				fetchLazyDependencies 		(RateIndex p_RateIndex) throws Exception;

	public List<Object[]> 			getRatesWithoutKeyValue 	();
	
	public void 					removeRatesWithoutKeyValue 	(Integer[] p_RateIds);
	
	public HashSet<String>			getAllPrivateCodes			();
	
	public List<String>				getCodesOfRateIndex			(RateIndex index);
	
	/**
	 * Reads the global settings and returns the billing setting with the specified 
	 * key or the given default value, if the setting wasn't found or was not yet set.
	 * 
	 * @param key The settings key (without plug-in name)
	 * @param defaultValue The default value to return, if the setting wasn't found
	 * @return The setting value or the defaultValue if the setting wasn't found
	 */
	public Object					readBillingSetting			(String key, Object defaultValue);
	
	/**
	 * @param codes The codes to query for
	 * @return A list of Object arrays where position 0 is the code as String and position 1 is the corresponding RateIndex label as String.
	 */
	public List<Object[]>			getRateIndexLabelsForCodes	(Collection<String> codes);
	
	/**
	 * @param code The code to query for
	 * @return The label of the 
	 */
	public String					getRateIndexLabelForCode	(String code);

	public Collection<Rate> getRatesWithoutChapters() throws Exception;

	

	
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
