/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The SettlementInterface 
* @author nmac
* @since 06/04/27
*
*/

@Remote
public interface SettlementInterface 
	{
	public Collection <Settlement> getAllSettlements () throws Exception;
	
	public Collection <Settlement> getTransferSettlements () throws Exception;
	
	public Collection <Settlement> getPaymentSettlements () throws Exception;
	
	public Account		getAccountByID	  (Integer p_AccountID) throws Exception;
	
	public Settlement   getSettlementByID (Integer p_ID) throws Exception;
	
	public Settlement   saveSettlement (Settlement p_Settlement) throws Exception;
	
	public Collection <Settlement> getTransferSettlementsByHolder (Physician holder) throws Exception;
	
	public Collection <Settlement> getTransferSettlementsWithoutHolder () throws Exception;
	
	public Boolean checkTransferSettlementHasReferences (Settlement p_Settlement) throws Exception;
	
	public void  deleteSettlement (Settlement p_Settlement) throws Exception;
	
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
