/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;



public class HTMLWrappingCellRenderer extends JEditorPane implements TableCellRenderer 
	{

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final long serialVersionUID = 1L;
	    
	private static final Color c_OddColor  = new Color (237,243,254);
	private static final Color c_EvenColor = new Color (255,255,255);
    private static final int   c_Gap   = 2;
	
	
public HTMLWrappingCellRenderer() 
	{
	setContentType("text/html");
	this.setFont (new Font ("Sans-serif", Font.PLAIN, 10));	
	this.setBorder(BorderFactory.createEmptyBorder (c_Gap,c_Gap,c_Gap,c_Gap));
	}

public Component getTableCellRendererComponent(JTable p_Table, Object
          value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) 	
	{
	Color	l_Background;
	
	l_Background = ( p_Row % 2 == 0) ? c_OddColor : c_EvenColor;
	if (p_IsSelected) 
		 this.setBackground(p_Table.getSelectionBackground());
	else this.setBackground(l_Background);
	
    setText((String)value);//or something in value, like value.getNote()...
    setSize(p_Table.getColumnModel().getColumn(p_Column).getWidth(),
              getPreferredSize().height);
    
    if (p_Table.getRowHeight(p_Row) < getPreferredSize().height) {
    	p_Table.setRowHeight(p_Row, getPreferredSize().height);
      }
      return this;
  }
} 
