/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.SSNField;
import lu.tudor.santec.gecamed.core.utils.SSNChecker;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.utils.SettingConstants;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class PatientSummaryPanel extends JPanel implements ActionListener,
														   Relocalizable 
	{
	private static final long serialVersionUID = 1L;

	private TitledBorder		m_Border;
	
	private JLabel				m_SSNLabel;
	private JLabel				m_NameLabel;
	private JLabel				m_MaidenNameLabel;
	private JLabel				m_RecordLabel;

	private SSNField			m_SSN;
	private JButton				m_SSNSearchButton;
	private JTextField			m_Name;
	private JTextField			m_MaidenName;
	private JFormattedTextField	m_RecordNumber;
	
	private Patient				m_Patient;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	public final static String c_SSNChanged 		 = "PatientSummaryPanel.SSNChanged";
	
	public final static String c_RecordNumberChanged = "PatientSummaryPanel.RecordNumberChanged";
	
	private final static String c_Columns= "fill:max(65dlu;pref),3dlu," +
										 "fill:pref:grow,3dlu," +
										 "fill:pref:grow,3dlu," +
										 "fill:max(50dlu;pref),fill:pref:grow";



	private final static String c_Rows=    "fill:pref,3dlu,fill:pref";
		
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
	
public PatientSummaryPanel ()
	{
	CellConstraints		l_Constraints;
    FormLayout			l_Layout;
    Color				l_DefaultColor;
    JPanel				l_SSNPanel;
    
    
    this.setOpaque(false);
    l_Constraints  = new CellConstraints();
     
    l_Layout = new FormLayout(c_Columns, c_Rows);
    this.setLayout(l_Layout);
    	
	m_Border = new TitledBorder (Translatrix.getTranslationString("PatientSummaryPanel.Title"));
    this.setBorder(m_Border);
	
    m_SSNLabel 			= new JLabel ();
    m_SSNLabel.setForeground (GECAMedColors.c_LabelColor);
	m_NameLabel			= new JLabel ();
	m_NameLabel.setForeground (GECAMedColors.c_LabelColor);
	m_MaidenNameLabel	= new JLabel ();
	m_MaidenNameLabel.setForeground (GECAMedColors.c_LabelColor);
	m_RecordLabel		= new JLabel ();
	m_RecordLabel.setForeground (GECAMedColors.c_LabelColor);
	
    l_DefaultColor = (Color) UIManager.getDefaults().get("TextField.inactiveBackground");   
    UIManager.getDefaults().put("TextField.inactiveBackground", Color.WHITE );

//	m_SSN	= new SSNField (new SSNFormatter());
    m_SSN	= new SSNField();
	m_SSN.setHorizontalAlignment (JTextField.LEFT);
	m_SSN.setEditable(true);
	m_SSN.addActionListener(this);
	
	m_SSNSearchButton = new JButton();
	m_SSNSearchButton.addActionListener(this);
	m_SSNSearchButton.setIcon(GECAMedModule.getScaledIcon(GECAMedIconNames.SEARCH, 18));
	m_SSNSearchButton.setPreferredSize(new Dimension(18, 18));
	
	l_SSNPanel	= new JPanel(new BorderLayout());
	l_SSNPanel.add(m_SSN, BorderLayout.CENTER);
	l_SSNPanel.add(m_SSNSearchButton, BorderLayout.EAST);
	l_SSNPanel.setOpaque(false);
	
	m_Name		= new JTextField ();
	m_Name.setHorizontalAlignment (JTextField.LEFT);
	m_Name.setEditable(false);

	m_MaidenName	= new JTextField ();
	m_MaidenName.setHorizontalAlignment (JTextField.LEFT);
	m_MaidenName.setEditable(false);
	
	m_RecordNumber	= new JFormattedTextField (new RecordNumberFormatter());
	m_RecordNumber.setHorizontalAlignment (JTextField.RIGHT);
	m_RecordNumber.setEditable(true);
	m_RecordNumber.addActionListener(this);
	
	UIManager.getDefaults().put("TextField.inactiveBackground", l_DefaultColor );

	this.relocalize ();
    this.reset();
	
	this.add (m_SSNLabel, 		l_Constraints.xywh(1, 1, 1, 1));	
	this.add (m_NameLabel, 		l_Constraints.xywh(3, 1, 1, 1));	
	this.add (m_MaidenNameLabel,l_Constraints.xywh(5, 1, 1, 1));	
	this.add (m_RecordLabel, 	l_Constraints.xywh(7, 1, 1, 1));	

	this.add (l_SSNPanel, 		l_Constraints.xywh(1, 3, 1, 1));	
	this.add (m_Name, 			l_Constraints.xywh(3, 3, 1, 1));	
	this.add (m_MaidenName, 	l_Constraints.xywh(5, 3, 1, 1));	
	this.add (m_RecordNumber, 	l_Constraints.xywh(7, 3, 1, 1));		
	
	}
	
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
	if (m_Border != null)
		m_Border.setTitle(Translatrix.getTranslationString("PatientSummaryPanel.Title"));
	
	if (m_SSNLabel!=null) 
		m_SSNLabel.setText (Translatrix.getTranslationString("PatientSummaryPanel.SSNLabel"));
	
	if (m_NameLabel!=null) 		 
		m_NameLabel.setText (Translatrix.getTranslationString("PatientSummaryPanel.NameLabel"));
	
	if (m_MaidenNameLabel!=null)
		m_MaidenNameLabel.setText ( this.maidenNameIsMarriedName()?Translatrix.getTranslationString("PatientSummaryPanel.MarriedNameLabel")
									  							  :Translatrix.getTranslationString("PatientSummaryPanel.MaidenNameLabel"));
	
	if (m_RecordLabel!=null)
		m_RecordLabel.setText (Translatrix.getTranslationString("PatientSummaryPanel.RecordLabel"));	
	}

//---------------------------------------------------------------------------

public boolean maidenNameIsMarriedName ()
	{
	if (	(PatientManagerModule.getInstance().administrativeElementsPlugin.getValue(SettingConstants.MAIDEN_CONFIG) != null)
		&&  ((Boolean) PatientManagerModule.getInstance().administrativeElementsPlugin.getValue(SettingConstants.MAIDEN_CONFIG)).equals(Boolean.TRUE)) 
		{
		return true;
		}

	return false;
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

public void setPatient (Patient p_Patient)
	{
	String	l_SSN;
	String  l_Name;
	
	if (p_Patient != null && p_Patient.getId() != null)
		{
		m_Patient = p_Patient;
		
		l_SSN = (p_Patient.getSocialSecurityNumber() != null) ? p_Patient.getSocialSecurityNumber() : "";
		l_Name = (p_Patient.getSurName() != null) ? p_Patient.getSurName().toUpperCase() : "";
		l_Name += " ";
		l_Name += (p_Patient.getFirstName() != null) ? p_Patient.getFirstName() : "";
		
		if (m_SSN  != null) 			m_SSN.setValue(l_SSN);
		if (m_Name != null) 		 	m_Name.setText(l_Name);
		if (m_MaidenName != null) 		m_MaidenName.setText(p_Patient.getMaidenName());
		if (m_RecordNumber != null) 	m_RecordNumber.setValue(p_Patient.getId().toString());
		}
	}

//---------------------------------------------------------------------------

public Patient getPatient ()
	{
	return m_Patient;
	}

//---------------------------------------------------------------------------

public void reset ()
	{
	m_SSN.setValue(SSNChecker.EMPTY_SSN_COMPACT);
	m_Name.setText("");
	m_MaidenName.setText("");
	m_RecordNumber.setValue(RecordNumberFormatter.c_EmptyField);
	m_Patient = null;
	}

//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event) 
	{
	if (p_Event.getSource() == m_SSN
			|| p_Event.getSource() == m_SSNSearchButton)
		{
		this.firePropertyChange(c_SSNChanged, null, m_SSN.getValue());
		}
	else if (p_Event.getSource() == m_RecordNumber)
		{
		this.firePropertyChange(c_RecordNumberChanged, null, m_RecordNumber.getValue());
		}
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
	
	}
