/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;


import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.office.gui.PhysicianComboBoxRenderer;

/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class PhysicianCellEditor extends AbstractCellEditor implements TableCellEditor,
																	   ActionListener
    {
	private JComboBox	 			m_PhysicianChooser;

	private Hashtable <Integer,Physician> m_PhysicianLookup;
	
	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public PhysicianCellEditor(Collection <Physician> p_Physicians) 
    {
	super ();
		
    m_PhysicianChooser	= new JComboBox ();
    m_PhysicianChooser.setRenderer(new PhysicianComboBoxRenderer ());
    m_PhysicianChooser.addActionListener(this);
    
    this.populatePhysicians (p_Physicians);
    this.buildPhysicianLookup (p_Physicians);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

public void populatePhysicians (Collection <Physician> p_Physicians)
	{
	Iterator <Physician>	l_PhysicianIterator;
	
	if (p_Physicians == null) return;
	
	l_PhysicianIterator = p_Physicians.iterator();
	while (l_PhysicianIterator.hasNext())
		{
		m_PhysicianChooser.addItem (l_PhysicianIterator.next());
		}
	}

//---------------------------------------------------------------------------

public void buildPhysicianLookup (Collection <Physician> p_Physicians)
	{
	Iterator <Physician>	l_PhysicianIterator;
	Physician				l_Physician;
	
	if (p_Physicians == null) return;
	
	m_PhysicianLookup = new Hashtable <Integer,Physician> ();
	
	l_PhysicianIterator = p_Physicians.iterator();
	while (l_PhysicianIterator.hasNext())
		{
		l_Physician = l_PhysicianIterator.next();
		m_PhysicianLookup.put(l_Physician.getId(), l_Physician);
		}
	}

//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************

//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
	Object	l_Value;
	
	l_Value = m_PhysicianChooser.getSelectedItem();
	if (l_Value instanceof Physician) 
		 return ((Physician)l_Value).getId();
	else return Integer.valueOf(0);
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent(JTable p_Table, Object p_InitialValue, 
										  boolean p_IsSelected, int p_Row, int p_Column) 
	{	
	Integer		l_PhysicianId;
	Physician 	l_Physician;
	
	if (p_InitialValue instanceof Integer) 
		{
		l_PhysicianId = (Integer) p_InitialValue;
		if (m_PhysicianLookup.containsKey(l_PhysicianId))
			{
			l_Physician = m_PhysicianLookup.get(l_PhysicianId);
			m_PhysicianChooser.setSelectedItem(l_Physician);	
//			m_StartEditingButton.setText((String)l_Physician.toString());
			}
		}
		
	return m_PhysicianChooser;
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource().equals (m_PhysicianChooser))
		{
		this.fireEditingStopped();
		}
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

