/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;

import java.awt.Component;

import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;



/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class SpinnerEditorField extends AbstractCellEditor implements TableCellEditor
    {
	private static final long serialVersionUID = 1L;

	private CellEditorSpinner m_Spinner; 
     	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public SpinnerEditorField(int p_Value, int p_Minimum, int p_Maximum, int p_StepSize) 
    {
	super ();
	
	m_Spinner = new CellEditorSpinner ();
	m_Spinner.setModel (new SpinnerNumberModel(p_Value, p_Minimum, p_Maximum, p_StepSize));
    }

//---------------------------------------------------------------------------

public SpinnerEditorField(double p_Value, double p_Minimum, double p_Maximum, double p_StepSize) 
    {
	super ();
	
	m_Spinner = new CellEditorSpinner ();
	m_Spinner.setModel (new SpinnerNumberModel(p_Value, p_Minimum, p_Maximum, p_StepSize));
    }

//---------------------------------------------------------------------------
	    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


public Object getCellEditorValue() 
	{
	return m_Spinner.getTextFieldValue();
	}


public JSpinner getSpinner ()
	{
	return m_Spinner;
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent (JTable p_Table, Object p_Value, 
										    boolean p_IsSelected, 
										    int p_Row, int p_Column) 
	{
//	m_Spinner.setValue(p_Value);
	if (p_Value instanceof Integer)
		{
		m_Spinner.setValue((Integer)p_Value);
		}
//	else if (p_Value instanceof Double)
//		{
//		m_Spinner.setValue((Double)p_Value);
//		}
	
	return m_Spinner;
	}


//***************************************************************************
//* Class Body                                                              *
//***************************************************************************


//***************************************************************************
//* CellEditorSpinner CLASS BODY                                            *
//***************************************************************************

	class CellEditorSpinner extends JSpinner
	{
		/* ======================================== */
		// 		MEMBERS
		/* ======================================== */
		
		private static final long	serialVersionUID	= 1L;
		
		private DefaultEditor 	editor;
		
		
		
		/* ======================================== */
		// 		CONSTRUCTORS
		/* ======================================== */
		
		public CellEditorSpinner()
		{
			super();
			editorChanged();
		}
		
		
		public CellEditorSpinner(SpinnerModel model)
		{
			super(model);
			editorChanged();
		}
		
		
		
		/* ======================================== */
		// 		GETTER & SETTER
		/* ======================================== */
		
		@Override
		public void setEditor(JComponent editor)
		{
			super.setEditor(editor);
			editorChanged();
		}
		
		
		public Object getTextFieldValue()
		{
			String 	enteredText;
			Integer value;
			
			if (editor == null)
				return super.getValue();
			
			enteredText = editor.getTextField().getText();
			
			try 
			{
				value = Integer.parseInt(enteredText);
				super.setValue(value);
			}
			catch (NumberFormatException nfe) {}
			
			return super.getValue();
		}
		
		
		
		/* ======================================== */
		// 		HELP METHODS
		/* ======================================== */
		
		private void editorChanged ()
		{
			editor = (DefaultEditor) getEditor();
		}
	}

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
}


