/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;



public class TextWrappingCellRenderer extends JTextArea implements TableCellRenderer 
	{

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final long serialVersionUID = 1L;
	    
    private int   c_vGap   = 2;
    private int   c_hGap   = 2;
	
    public TextWrappingCellRenderer() 
	{
		this(255);
	}

    public TextWrappingCellRenderer(int alpha) 
    {
    	setLineWrap(true);
    	setWrapStyleWord(true);
    	this.setBorder(BorderFactory.createEmptyBorder (c_vGap,c_hGap,c_vGap,c_hGap));
    	this.setFont (new Font (getFont().getName(), Font.PLAIN, 10));	
    }

    public TextWrappingCellRenderer(int alpha, Font font, int gap) 
    {
	c_vGap = gap;
    	setLineWrap(true);
    	setWrapStyleWord(true);
    	this.setBorder(BorderFactory.createEmptyBorder (c_vGap,c_hGap,c_vGap,c_hGap));
    	this.setFont (font);	
    }

public Component getTableCellRendererComponent(JTable p_Table, Object
          value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) 	
	{
	Color	l_Background;
	
	l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
									   GECAMedColors.c_EvenLineBackground;
	if (p_IsSelected) 
		 this.setBackground(p_Table.getSelectionBackground());
	else this.setBackground(l_Background);


	setText((String)value);//or something in value, like value.getNote()...
	setSize(p_Table.getColumnModel().getColumn(p_Column).getWidth(),
              getPreferredSize().height);
    
    if (p_Table.getRowHeight(p_Row) < getPreferredSize().height) {
    	p_Table.setRowHeight(p_Row, getPreferredSize().height);
      }
      return this;
  }
} 
