/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;


import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.util.Date;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.jtimechooser.JTimeChooser;


/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TimeCellEditor extends AbstractCellEditor implements TableCellEditor,
																  KeyListener,
																  ActionListener
    {
    private JTimeChooser m_TimeField; 
	
	private static final long serialVersionUID = 1L;
     
//    protected final static Pattern c_TimePattern = Pattern.compile (
//    		"^([01]?[0-9]|2[0-3]):(\\d{2})$",Pattern.CASE_INSENSITIVE);
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public TimeCellEditor() 
    {
	super ();
	
	m_TimeField = new JTimeChooser();
	m_TimeField.setEnabledWithDoubleClick(false);
	m_TimeField.setShowSeconds(false);
	m_TimeField.setShowIcon(false);
//	m_TimeField = new JFormattedTextField (createFormatter("##:##"));
//	m_TimeField.setValue("00:00");
	m_TimeField.getTimeField().addActionListener (this);
    m_TimeField.addKeyListener (this);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * creates a MaskFormatter object using the specified format template
 * @param p_Format specifies the template for new MaskFormatter object
 * @return MaskFormatter object implementing format specified by p_Format
 */
//---------------------------------------------------------------------------

//protected MaskFormatter createFormatter (String p_Format) 
//    {
//    MaskFormatter l_Formatter = null;
//    
//    try {
//        l_Formatter = new MaskFormatter (p_Format);
//        l_Formatter.setAllowsInvalid(false);
//     	} 
//    catch (ParseException p_Exception) 
//        {
//        }
//  
//    return l_Formatter;
//    }

//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
	return m_TimeField.getDateWithTime(new Date());
//	GregorianCalendar	l_Calendar;
//	Date	   			l_Time;
//	Matcher				l_Matcher;
//	int					l_Hours   = 0;
//	int					l_Minutes = 0;
//	
//	l_Matcher = c_TimePattern.matcher ((String) m_TimeField.getValue());
//     if (l_Matcher.matches())
//        {
//    	l_Hours   = (new Integer (l_Matcher.group(1))).intValue();
//    	l_Minutes = (new Integer (l_Matcher.group(2))).intValue();	    	 
//        }
//    
//    l_Calendar = new GregorianCalendar (0,0,0,l_Hours,l_Minutes,0);
//    l_Time = l_Calendar.getTime();
//      
//	return l_Time;
}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent (JTable p_Table, Object p_Value,
        									  boolean p_IsSelected, int p_Row, int p_Column)
	{
//	GregorianCalendar	l_Calendar;
//	String				l_Value;
//	int					l_Hours;
//	int					l_Minutes;
//	
//	if (p_Value instanceof Date)
//		{
//		l_Calendar = new GregorianCalendar ();
//		l_Calendar.setTime((Date)p_Value);
//		l_Hours   = l_Calendar.get(Calendar.HOUR_OF_DAY);
//		l_Minutes = l_Calendar.get(Calendar.MINUTE);
//			
//		l_Value  = (l_Hours < 10)? "0"   + Integer.valueOf(l_Hours).toString():Integer.valueOf(l_Hours).toString();
//		l_Value += ":";
//		l_Value += (l_Minutes < 10)? "0" + Integer.valueOf(l_Minutes).toString():Integer.valueOf(l_Minutes).toString();
//
//		m_TimeField.setValue(l_Value);		
//		}
	
	if (p_Value instanceof Date)
		m_TimeField.setTime((Date)p_Value);
	
	return m_TimeField;
	}

//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event) 
	{
	this.stopCellEditing();
	}

//---------------------------------------------------------------------------

public void keyPressed(KeyEvent p_Event)
	{
	if (p_Event.getKeyCode() == KeyEvent.VK_TAB)
		{
		try	{
			m_TimeField.getTimeField().commitEdit();
			}
		catch (ParseException p_Exception)
			{
			// Can be safely ignored here.
			}
		this.stopCellEditing();
		}
	}

//---------------------------------------------------------------------------

public void keyReleased(KeyEvent p_Event)
	{
	}

//---------------------------------------------------------------------------

public void keyTyped(KeyEvent p_Event)
	{
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

