/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.act;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class ActRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              	m_Label;
	private JCheckBox		   		m_Checkbox;
	private DateFormat				m_DateFormat;
	private DateFormat				m_TimeFormat;
	private NumberFormat			m_AmountFormat;
	private ImageIcon				m_Verified;
	private ImageIcon				m_Unverified;
	
	private ActListModel			m_TableModel;
	private TableSorter				m_ActSorter;   
//	private Act						m_Act;
//	private int						m_LastRow;
 
	private Hashtable <Integer, String>	m_PhysicianLookup;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
	private static Color COL_ACTIVE 	= null;
	private static Color COL_INACTIVE = null;
    	
	
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public ActRenderer (Collection <Physician> p_Physicians)
      {
      super();

      Iterator <Physician> l_PhysicianIterator;
      Physician			   l_Physician;
      
      m_Label = new JLabel ();
      
      COL_ACTIVE 	= m_Label.getForeground();
  	  COL_INACTIVE 	= new Color(153,153,153);
      
      m_Label.setOpaque(true);
      m_Label.setHorizontalAlignment (SwingConstants.CENTER);
      m_Label.setEnabled(true);	
      
      m_Checkbox = new JCheckBox ();
      m_Checkbox.setHorizontalAlignment (SwingConstants.CENTER);
      
      m_AmountFormat = NumberFormat.getInstance();
      m_AmountFormat.setMinimumFractionDigits(2);
      m_AmountFormat.setMaximumFractionDigits(2);
      
      m_Verified 	= BillingModule.getIconResource ("act_verified_state.png");
      m_Unverified 	= BillingModule.getIconResource ("act_unverified_state.png");
      
      m_PhysicianLookup = new Hashtable <Integer, String> ();
      m_PhysicianLookup.put(Integer.valueOf(0), "n/a");
      
      if (p_Physicians != null)
      	{
    	l_PhysicianIterator = p_Physicians.iterator();
      	while (l_PhysicianIterator.hasNext())
      		{
      		l_Physician = l_PhysicianIterator.next();
      		m_PhysicianLookup.put(l_Physician.getId(), l_Physician.toString());
       		}   	
      	}
       
      this.relocalize();       
      }

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

private boolean isEditable (JTable p_Table)
	{
	TableSorter		l_ActSorter;
	ActListModel	l_TableModel;    

	l_ActSorter 	= (TableSorter) p_Table.getModel();
	l_TableModel 	= (ActListModel) l_ActSorter.getTableModel();
	
	return l_TableModel.isEditable();
	}

//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_ActSorter != null) && m_ActSorter.isSorting())
		{
		l_ModelRow = m_ActSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
     
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
		m_DateFormat = GECAMedGuiUtils.getDateFormat(false);
		m_TimeFormat = GECAMedGuiUtils.getTimeFormat(false);
 	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component		l_Component		= null;
	Color			l_Background;
	int				l_Row;
	int				l_Column		= -1;
	Act 			l_Act 			= null;
	boolean 		l_MarkCell 		= false;
	
	m_Label.setForeground(COL_ACTIVE);	
	
	if (m_TableModel == null) 
		{
		m_ActSorter 	= (TableSorter) p_Table.getModel();
		m_TableModel 	= (ActListModel) m_ActSorter.getTableModel();
//		m_LastRow	  	= -1;
		}

	if (m_TableModel != null) // && (p_Row != m_LastRow))
		{
		l_Row = this.modelRow (p_Row);
		l_Act = m_TableModel.getActAt(l_Row);
//		m_LastRow = l_Row;
		}
	
	if ((p_Value != null) && (l_Act != null)) 
		{
		m_Label.setText (null);
		m_Label.setToolTipText (null);
		m_Label.setIcon (null);
		l_Column = this.modelColumn(p_Table, p_Column);
	
		l_Column = m_TableModel.getViewToModelColumn(l_Column);
		
		switch (l_Column)
			{
			case ActListModel.c_IndexColumn :
				
				m_Label.setText(String.valueOf(p_Row+1));
				l_Component = m_Label;
				break;
				
			case ActListModel.c_HospClassColumn :
				
				m_Label.setText(String.valueOf(p_Value));
				l_Component = m_Label;
				break;
				
			case ActListModel.c_DateColumn :
					
				m_Label.setText (m_DateFormat.format ((Date)p_Value));
				
				if (l_Act.getVerified()) m_Label.setIcon(m_Verified);
									else m_Label.setIcon (m_Unverified);
				
				l_Component = m_Label;
				break;
	
			case ActListModel.c_ShowColumn :
		
				m_Checkbox.setSelected(((Boolean)p_Value).booleanValue());
				m_Checkbox.setEnabled(this.isEditable(p_Table));
				l_Component = m_Checkbox;
				break;
	
			case ActListModel.c_TimeColumn :
				m_Label.setText (m_TimeFormat.format ((Date)p_Value));
				if (l_Act.getShowTime().booleanValue() == true) {
					m_Label.setForeground(COL_ACTIVE);					
				} else {
					m_Label.setForeground(COL_INACTIVE);		
				}
				
//				if (l_Act.getShowTime().booleanValue() == true)
//					m_Label.setText (m_TimeFormat.format ((Date)p_Value));
//				else m_Label.setText ("");
				l_Component = m_Label;
				break;
			
			case ActListModel.c_PhysicianColumn :

				if (m_PhysicianLookup.containsKey((Integer)p_Value))
					{
					m_Label.setText(m_PhysicianLookup.get ((Integer)p_Value));
					}
				l_Component = m_Label;
				break;
			
			case ActListModel.c_AmountColumn :
		
				l_MarkCell = l_Act.getFixAmount() != null;
				m_Label.setText (m_AmountFormat.format ((Double)p_Value));
				if (l_MarkCell)
					 m_Label.setToolTipText(Translatrix.getTranslationString("ActRenderer.fixAmountToolTip"));
				else m_Label.setToolTipText(null);
				l_Component = m_Label;
				break;
	
			default:

				m_Label.setText (p_Value.toString());
				l_Component = m_Label;
				break;
			}
		}
		
	if (l_Component == null) return l_Component;
	
	if (p_Table != null) l_Component.setEnabled (p_Table.isEnabled());

	if (l_MarkCell)
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedOddLineBackground
										 : GECAMedColors.c_RedEvenLineBackground;
	else if ((p_Table != null) && (p_IsSelected)) 
		l_Background = p_Table.getSelectionBackground();
	else 
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground 
										 : GECAMedColors.c_EvenLineBackground;
	
	l_Component.setBackground(l_Background);

	return l_Component;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
