package lu.tudor.santec.gecamed.billing.gui.act;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;


public class AdjustmentEditor extends AbstractCellEditor implements TableCellEditor, 
																KeyListener, 
																ActionListener
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private IntegerField adjustmentField;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public AdjustmentEditor ()
	{
		adjustmentField = new IntegerField(3);
		adjustmentField.addActionListener(this);
		adjustmentField.addKeyListener(this);
	}
	
	
	
	/* ======================================== */
	// 		IMPLEMENTED METHODS
	/* ======================================== */
	
	public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column)
	{
		adjustmentField.setText(String.valueOf(value));
		
		return adjustmentField;
	}
	
	
	public Object getCellEditorValue()
	{
		try {
			return adjustmentField.getValue();
		}
		catch (NumberFormatException e)
		{
			return null;
		}
	}


	public void actionPerformed(ActionEvent e)
	{
		stopCellEditing();
	}


	public void keyTyped(KeyEvent e)
	{
		if (	   e.getKeyCode() == KeyEvent.VK_TAB
				|| e.getKeyCode() == KeyEvent.VK_ENTER)
			this.stopCellEditing();
		else if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
			this.cancelCellEditing();
	}


	public void keyPressed(KeyEvent e) {}
	public void keyReleased(KeyEvent e) {}



	public Component getTextField ()
	{
		return adjustmentField;
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	
}
