/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.act;


import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.billing.gui.TextWrappingCellRenderer;


/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class LabelCellEditor extends AbstractCellEditor implements TableCellEditor,
																   KeyListener
    {
    private TextWrappingCellRenderer m_LabelField; 
	
	private static final long serialVersionUID = 1L;
     
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public LabelCellEditor() 
    {
	super ();
	
	m_LabelField = new TextWrappingCellRenderer ();
	m_LabelField.addKeyListener (this);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
	return m_LabelField.getText();
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent (JTable p_Table, Object p_Value,
        									  boolean p_IsSelected, int p_Row, int p_Column)
	{
	if (p_Value instanceof String)
		{
		m_LabelField.setText((String)p_Value);		
		}
	
	return m_LabelField;
	}

//---------------------------------------------------------------------------

public void keyPressed(KeyEvent p_Event)
	{
	if (	(p_Event.getKeyCode() == KeyEvent.VK_TAB)
		 || (p_Event.getKeyCode() == KeyEvent.VK_ENTER))
		{
		this.stopCellEditing();
		}
	else if ((p_Event.getKeyCode() == KeyEvent.VK_ESCAPE))
		{
		this.cancelCellEditing();
		}
	}

//---------------------------------------------------------------------------

public void keyReleased(KeyEvent p_Event)
	{
	}

//---------------------------------------------------------------------------

public void keyTyped(KeyEvent p_Event)
	{
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

