/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.act.addinfo;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/**
 * @author 
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class LateralityChooser extends JPanel implements ActionListener,
													 KeyListener,
													 MenuKeyListener,
													 FocusListener, 
													 AdvancedEditorEcomponent
    {
     
	private AbstractCellEditor	m_Editor;
	private JPopupMenu			m_Popup = null; 
	private String				m_Laterality;
	private boolean				m_Canceled;
	private ButtonGroup m_ButtonGroup;
	
	
	private static Hashtable <Character, JToggleButton> m_LateralityLookup = null;
     
	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public LateralityChooser (AbstractCellEditor p_Editor) 
    {
	this.setLayout(new GridLayout(0, 3));
		
	m_Editor = p_Editor;
	if (m_LateralityLookup == null) m_LateralityLookup = new Hashtable <Character, JToggleButton> ();
	
	populateLateralityChooser ();
    
	m_Popup = new JPopupMenu(); 
	m_Popup.setLightWeightPopupEnabled(true);
	m_Popup.add(this);
	m_Popup.addMenuKeyListener(this);
	
	m_Popup.addPopupMenuListener(new PopupMenuListener() {
		public void popupMenuWillBecomeVisible(PopupMenuEvent e) {}
		public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {}
		public void popupMenuCanceled(PopupMenuEvent e) {
			m_Canceled = false;
			m_Popup.setVisible(false);
			m_Editor.stopCellEditing();
		}
    });
	
    }


//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

public void updateUI() 
	{
	super.updateUI();
	setEnabled(isEnabled());

	if (m_Popup != null) SwingUtilities.updateComponentTreeUI(m_Popup);
	}

//---------------------------------------------------------------------------

public void populateLateralityChooser ()
	{

		JToggleButton		l_Button;
		m_ButtonGroup = new ButtonGroup();
	
		l_Button = new JToggleButton ("G");
		l_Button.addKeyListener (this);
		l_Button.setToolTipText("Gauche");
		l_Button.setFocusTraversalKeysEnabled(false);
		this.add(l_Button);
		m_ButtonGroup.add(l_Button);
		m_LateralityLookup.put ('G',l_Button);
		
		l_Button = new JToggleButton ("D");
		l_Button.addKeyListener (this);
		l_Button.setToolTipText("Droite");
		l_Button.setFocusTraversalKeysEnabled(false);
		this.add(l_Button);
		m_ButtonGroup.add(l_Button);
		m_LateralityLookup.put ('D',l_Button);	
		
		l_Button = new JToggleButton ("B");
		l_Button.addKeyListener (this);
		l_Button.setToolTipText("Bilateral");
		l_Button.setFocusTraversalKeysEnabled(false);
		this.add(l_Button);
		m_ButtonGroup.add(l_Button);
		m_LateralityLookup.put ('B',l_Button);	
	}

//---------------------------------------------------------------------------

private void processKeyChar (char p_Character)
	{
	switch (p_Character)    
		{
		case KeyEvent.VK_ENTER  : m_Canceled = false;
								  m_Popup.setVisible(false);
								  m_Editor.stopCellEditing();
								  break;
		
		case KeyEvent.VK_TAB  	: m_Canceled = false;
								  m_Popup.setVisible(false);
								  m_Editor.stopCellEditing();
								  break;
								
		case KeyEvent.VK_ESCAPE : m_Canceled = true;
								  m_Popup.setVisible(false);
								  m_Editor.stopCellEditing();
								  break;
		
		case KeyEvent.VK_DELETE : m_Canceled = true;
								  m_Laterality = "";
		  						  m_Popup.setVisible(false);
		  						  m_Editor.stopCellEditing();
								  break;
		
		default	: this.toggleLaterality (p_Character);
		}							
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************
//---------------------------------------------------------------------------

public void setValue (String p_Laterality)
	{
	char [] 				l_Lateralities;
	int						l_Index;
	Character				l_Laterality;
	
	JToggleButton			l_Button;
		
	m_ButtonGroup.clearSelection();

	if (p_Laterality == null) return;
	
	m_Laterality = p_Laterality;
	l_Lateralities = m_Laterality.toCharArray();
	
	for (l_Index = 0; l_Index < l_Lateralities.length; l_Index++)
		{
		l_Laterality = Character.valueOf (l_Lateralities[l_Index]);
		if (m_LateralityLookup.containsKey(l_Laterality))
			{
			l_Button = m_LateralityLookup.get(l_Laterality);
			l_Button.setSelected(true);
			}
		}
	}

//---------------------------------------------------------------------------

public String getValue ()
	{
	Enumeration <Character>	l_Keys;
	Character				l_Suffix;
	JToggleButton			l_Button;
	String					l_ChosenLaterality;
	
	if (m_Canceled) return m_Laterality; 
	// TODO Auto-generated method stub
	
	l_Keys = m_LateralityLookup.keys();	
	l_ChosenLaterality = new String ();
	
	while (l_Keys.hasMoreElements())
		{
		l_Suffix = l_Keys.nextElement();
		l_Button = m_LateralityLookup.get(l_Suffix);
		if (l_Button.isSelected()) l_ChosenLaterality += l_Suffix.toString();
		}
	
	return l_ChosenLaterality;
	}

//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event)
	{
	JComponent		l_Source;
	
	if (p_Event.getSource() instanceof JComponent)
		{
		l_Source = (JComponent) p_Event.getSource();		
		m_Popup.show (l_Source,0,l_Source.getHeight());
		m_Canceled = false;
		}
	}

//---------------------------------------------------------------------------

public void toggleLaterality (Character p_Laterality)
	{
	Character		l_Typed;
	JToggleButton	l_Button;
	
	l_Typed = Character.toUpperCase (p_Laterality);
	if (m_LateralityLookup.containsKey (l_Typed))
		{
		l_Button = m_LateralityLookup.get (l_Typed);  
			if (l_Button.isSelected()) {
				m_ButtonGroup.clearSelection();
			} else {
				l_Button.setSelected(true);
			}
		}
	}

//---------------------------------------------------------------------------

public void menuKeyPressed(MenuKeyEvent p_Event) 
	{
	if(!p_Event.isConsumed())
		{
		this.processKeyChar (p_Event.getKeyChar());    
		}	
	}

//---------------------------------------------------------------------------

public void menuKeyReleased(MenuKeyEvent p_Event) 
	{
	}

//---------------------------------------------------------------------------

public void menuKeyTyped(MenuKeyEvent p_Event) 
	{
	}

//---------------------------------------------------------------------------

public void keyPressed(KeyEvent p_Event) 
	{
	if(!p_Event.isConsumed())
		{
		this.processKeyChar (p_Event.getKeyChar());    
		}	
	}

//---------------------------------------------------------------------------

public void keyReleased(KeyEvent p_Event) 
	{
	}

//---------------------------------------------------------------------------

public void keyTyped(KeyEvent p_Event) 
	{
	}


public void focusGained(FocusEvent e) {}


public void focusLost(FocusEvent e) {
	m_Canceled = false;
	m_Popup.setVisible(false);
	m_Editor.stopCellEditing();
}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

