/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.act.addinfo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedHashMap;
import java.util.Set;

import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author 
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class ToothChooser extends JPanel implements ActionListener,
													 KeyListener,
													 MenuKeyListener,
													 FocusListener, 
													 AdvancedEditorEcomponent
    {
     
	private AbstractCellEditor	m_Editor;
	private JPopupMenu			m_Popup = null; 
	private String				m_Info;
	private boolean				m_Canceled;
	
	private LinkedHashMap<String, JToggleButton> m_Lookup = null;
     
	private static final long serialVersionUID = 1L;
	private static final String DELIMITER = ",";
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public ToothChooser (AbstractCellEditor p_Editor) 
    {
	
	m_Editor = p_Editor;
	
	populateChooser ();
    
	m_Popup = new JPopupMenu(); 
	m_Popup.setLightWeightPopupEnabled(true);
	m_Popup.add(this);
	m_Popup.addMenuKeyListener(this);
	
	m_Popup.addPopupMenuListener(new PopupMenuListener() {
		public void popupMenuWillBecomeVisible(PopupMenuEvent e) {}
		public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {}
		public void popupMenuCanceled(PopupMenuEvent e) {
			m_Canceled = false;
			m_Popup.setVisible(false);
			m_Editor.stopCellEditing();
		}
    });
	
    }


//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

public void updateUI() 
	{
	super.updateUI();
	setEnabled(isEnabled());

	if (m_Popup != null) SwingUtilities.updateComponentTreeUI(m_Popup);
	}

//---------------------------------------------------------------------------

public void populateChooser ()
	{

	if (m_Lookup == null) m_Lookup = new LinkedHashMap <String, JToggleButton> ();
	
	
	FormLayout fl = new FormLayout(
			"2dlu, center:pref, 2dlu, fill:100dlu:grow, 10dlu, fill:100dlu:grow, 2dlu, center:pref, 2dlu",	// Cols
			"2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, "	// Rows
			);
	
	CellConstraints cc = new CellConstraints();
	this.setLayout(fl);
	
	JLabel jl = new JLabel("<html><h3>"+Translatrix.getTranslationString("toothchooser.permanent"), JLabel.CENTER);
	this.add(jl, cc.xyw(2, 2, 8 ));
	this.add(new JSeparator(), cc.xyw(2, 3, 8 ));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.upright"), JLabel.CENTER), cc.xyw(4, 4, 1 ));
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.upleft"), JLabel.CENTER), cc.xyw(6, 4, 1 ));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.right"), JLabel.CENTER), cc.xyw(2, 6, 1 ));
	
	JPanel permRP = new JPanel(new FormLayout(
			"pref:grow, pref:grow, pref:grow, pref:grow, pref:grow, pref:grow, pref:grow, pref:grow",	// Cols
			"pref, pref, pref"	// Rows
			));
	permRP.add(createTooth("18"), cc.xy(1, 1));
	permRP.add(createTooth("17"), cc.xy(2, 1));
	permRP.add(createTooth("16"), cc.xy(3, 1));
	permRP.add(createTooth("15"), cc.xy(4, 1));
	permRP.add(createTooth("14"), cc.xy(5, 1));
	permRP.add(createTooth("13"), cc.xy(6, 1));
	permRP.add(createTooth("12"), cc.xy(7, 1));
	permRP.add(createTooth("11"), cc.xy(8, 1));
	permRP.add(new JSeparator(), cc.xyw(1, 2, 8));
	permRP.add(createTooth("48"), cc.xy(1, 3));
	permRP.add(createTooth("47"), cc.xy(2, 3));
	permRP.add(createTooth("46"), cc.xy(3, 3));
	permRP.add(createTooth("45"), cc.xy(4, 3));
	permRP.add(createTooth("44"), cc.xy(5, 3));
	permRP.add(createTooth("43"), cc.xy(6, 3));
	permRP.add(createTooth("42"), cc.xy(7, 3));
	permRP.add(createTooth("41"), cc.xy(8, 3));
	this.add(permRP, cc.xy(4, 6));
	
	JPanel permLP = new JPanel(new FormLayout(
			"pref:grow, pref:grow, pref:grow, pref:grow, pref:grow, pref:grow, pref:grow, pref:grow",	// Cols
			"pref, pref, pref"	// Rows
			));
	permLP.add(createTooth("21"), cc.xy(1, 1));
	permLP.add(createTooth("22"), cc.xy(2, 1));
	permLP.add(createTooth("23"), cc.xy(3, 1));
	permLP.add(createTooth("24"), cc.xy(4, 1));
	permLP.add(createTooth("25"), cc.xy(5, 1));
	permLP.add(createTooth("26"), cc.xy(6, 1));
	permLP.add(createTooth("27"), cc.xy(7, 1));
	permLP.add(createTooth("28"), cc.xy(8, 1));
	permLP.add(new JSeparator(), cc.xyw(1, 2, 8));
	permLP.add(createTooth("31"), cc.xy(1, 3));
	permLP.add(createTooth("32"), cc.xy(2, 3));
	permLP.add(createTooth("33"), cc.xy(3, 3));
	permLP.add(createTooth("34"), cc.xy(4, 3));
	permLP.add(createTooth("35"), cc.xy(5, 3));
	permLP.add(createTooth("36"), cc.xy(6, 3));
	permLP.add(createTooth("37"), cc.xy(7, 3));
	permLP.add(createTooth("38"), cc.xy(8, 3));
	this.add(permLP, cc.xy(6, 6));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.left"), JLabel.CENTER),  cc.xyw(8, 6, 1 ));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.lowright"), JLabel.CENTER), cc.xyw(4, 8, 1 ));
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.lowleft"), JLabel.CENTER), cc.xyw(6, 8, 1 ));
	
	this.add(new JSeparator(), cc.xyw(2, 9, 8 ));
	jl = new JLabel("<html><h3>"+Translatrix.getTranslationString("toothchooser.baby"), JLabel.CENTER);
	this.add(jl, cc.xyw(2, 10, 8 ));
	this.add(new JSeparator(), cc.xyw(2, 11, 8 ));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.upright"), JLabel.CENTER), cc.xyw(4, 12, 1 ));
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.upleft"), JLabel.CENTER), cc.xyw(6, 12, 1 ));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.right"), JLabel.CENTER), cc.xyw(2, 14, 1 ));
	
	JPanel babyLP = new JPanel(new FormLayout(
			"pref:grow, pref:grow, pref:grow, pref:grow, pref:grow",	// Cols
			"pref, pref, pref"	// Rows
			));
	babyLP.add(createTooth("55"), cc.xy(1, 1));
	babyLP.add(createTooth("54"), cc.xy(2, 1));
	babyLP.add(createTooth("53"), cc.xy(3, 1));
	babyLP.add(createTooth("52"), cc.xy(4, 1));
	babyLP.add(createTooth("51"), cc.xy(5, 1));
	babyLP.add(new JSeparator(), cc.xyw(1, 2, 5));
	babyLP.add(createTooth("85"), cc.xy(1, 3));
	babyLP.add(createTooth("84"), cc.xy(2, 3));
	babyLP.add(createTooth("83"), cc.xy(3, 3));
	babyLP.add(createTooth("82"), cc.xy(4, 3));
	babyLP.add(createTooth("81"), cc.xy(5, 3));
	this.add(babyLP, cc.xy(4, 14));
	
	JPanel babyRP = new JPanel(new FormLayout(
			"pref:grow, pref:grow, pref:grow, pref:grow, pref:grow",	// Cols
			"pref, pref, pref"	// Rows
			));
	babyRP.add(createTooth("61"), cc.xy(1, 1));
	babyRP.add(createTooth("62"), cc.xy(2, 1));
	babyRP.add(createTooth("63"), cc.xy(3, 1));
	babyRP.add(createTooth("64"), cc.xy(4, 1));
	babyRP.add(createTooth("65"), cc.xy(5, 1));
	babyRP.add(new JSeparator(), cc.xyw(1, 2, 5));
	babyRP.add(createTooth("71"), cc.xy(1, 3));
	babyRP.add(createTooth("72"), cc.xy(2, 3));
	babyRP.add(createTooth("73"), cc.xy(3, 3));
	babyRP.add(createTooth("74"), cc.xy(4, 3));
	babyRP.add(createTooth("75"), cc.xy(5, 3));
	this.add(babyRP, cc.xy(6, 14));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.left"), JLabel.CENTER),  cc.xyw(8, 14, 1 ));
	
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.lowright"), JLabel.CENTER), cc.xyw(4, 16, 1 ));
	this.add(new JLabel(Translatrix.getTranslationString("toothchooser.lowleft"), JLabel.CENTER), cc.xyw(6, 16, 1 ));
	
//		JToggleButton		l_Button;
//		m_ButtonGroup = new ButtonGroup();
//	
//		l_Button = new JToggleButton ("G");
//		l_Button.addKeyListener (this);
//		l_Button.setToolTipText("Gauche");
//		this.add(l_Button);
//		m_ButtonGroup.add(l_Button);
//		m_Lookup.put ('G',l_Button);
//		
//		l_Button = new JToggleButton ("D");
//		l_Button.addKeyListener (this);
//		l_Button.setToolTipText("Droite");
//		this.add(l_Button);
//		m_ButtonGroup.add(l_Button);
//		m_Lookup.put ('D',l_Button);	
//		
//		l_Button = new JToggleButton ("B");
//		l_Button.addKeyListener (this);
//		l_Button.setToolTipText("Bilateral");
//		this.add(l_Button);
//		m_ButtonGroup.add(l_Button);
//		m_Lookup.put ('B',l_Button);	
		
	}

//---------------------------------------------------------------------------

private JToggleButton createTooth(String string) {
	JToggleButton b = new JToggleButton(string);
	b.setFocusTraversalKeysEnabled(false);
	b.addKeyListener(this);
	b.setMargin(new java.awt.Insets(0, 0, 0, 0));
	this.m_Lookup.put(string, b);
	return b;
}


private void processKeyChar (char p_Character)
	{
	switch (p_Character)    
		{
		case KeyEvent.VK_ENTER  : m_Canceled = false;
								  m_Popup.setVisible(false);
								  m_Editor.stopCellEditing();
								  break;
								  
		case KeyEvent.VK_TAB  	: m_Canceled = false;
								  m_Popup.setVisible(false);
								  m_Editor.stopCellEditing();
								  break;
								
		case KeyEvent.VK_ESCAPE : m_Canceled = true;
								  m_Popup.setVisible(false);
								  m_Editor.stopCellEditing();
								  break;
		
		case KeyEvent.VK_DELETE : m_Canceled = true;
								  m_Info = "";
		  						  m_Popup.setVisible(false);
		  						  m_Editor.stopCellEditing();
								  break;
		
//		default	: this.toggleLaterality (p_Character);
		}							
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************
//---------------------------------------------------------------------------

public void setValue (String p_Info)
	{
	int						l_Index;
	String					l_Tooth;
	
	JToggleButton			l_Button;

	if (p_Info == null) return;
	
	m_Info = p_Info;
	String[] tooth = p_Info.split(DELIMITER);
	
	for (JToggleButton jb : m_Lookup.values()) {
		jb.setSelected(false);
	}
	
	for (l_Index = 0; l_Index < tooth.length; l_Index++)
		{
		l_Tooth = tooth[l_Index].trim();
		if (m_Lookup.containsKey(l_Tooth))
			{
			l_Button = m_Lookup.get(l_Tooth);
			l_Button.setSelected(true);
			}
		}
	}

//---------------------------------------------------------------------------

public String getValue ()
	{
	Set<String>	l_Keys;
	String					l_Suffix;
	JToggleButton			l_Button;
	String					l_ChosenTooth;
	
	if (m_Canceled) return m_Info; 

	l_Keys = m_Lookup.keySet();	
	l_ChosenTooth = new String ();
	
	String delim = "";
	for (String key : l_Keys) {
		l_Suffix = key;
		l_Button = m_Lookup.get(l_Suffix);
		if (l_Button.isSelected()) {
			l_ChosenTooth += (delim + l_Suffix.toString());
			delim = DELIMITER;
		}
	}
	
	return l_ChosenTooth;
	}

//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event)
	{
	JComponent		l_Source;
	
	if (p_Event.getSource() instanceof JComponent)
		{
		l_Source = (JComponent) p_Event.getSource();		
		m_Popup.show (l_Source,0,l_Source.getHeight());
		m_Canceled = false;
		}
	}

//---------------------------------------------------------------------------

//public void toggleLaterality (Character p_Laterality)
//	{
//	Character		l_Typed;
//	JButton	l_Button;
//	
//	l_Typed = Character.toUpperCase (p_Laterality);
//	if (m_Lookup.containsKey (l_Typed))
//		{
//		l_Button = m_Lookup.get (l_Typed);  
//			if (l_Button.isSelected()) {
//				m_ButtonGroup.clearSelection();
//			} else {
//				l_Button.setSelected(true);
//			}
//		}
//	}

//---------------------------------------------------------------------------

public void menuKeyPressed(MenuKeyEvent p_Event) 
	{
	if(!p_Event.isConsumed())
		{
		this.processKeyChar (p_Event.getKeyChar());    
		}	
	}

//---------------------------------------------------------------------------

public void menuKeyReleased(MenuKeyEvent p_Event) 
	{
	}

//---------------------------------------------------------------------------

public void menuKeyTyped(MenuKeyEvent p_Event) 
	{
	}

//---------------------------------------------------------------------------

public void keyPressed(KeyEvent p_Event) 
	{
	if(!p_Event.isConsumed())
		{
		this.processKeyChar (p_Event.getKeyChar());    
		}	
	}

//---------------------------------------------------------------------------

public void keyReleased(KeyEvent p_Event) 
	{
	}

//---------------------------------------------------------------------------

public void keyTyped(KeyEvent p_Event) 
	{
	}


public void focusGained(FocusEvent e) {}


public void focusLost(FocusEvent e) {
	m_Canceled = false;
	m_Popup.setVisible(false);
	m_Editor.stopCellEditing();
}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

public static void main(String argv[]) {
    Translatrix.addBundle("lu.tudor.santec.gecamed.billing.gui.resources.WidgetResources");
	JDialog jd = new JDialog();
	ToothChooser tc = new ToothChooser(null);
	jd.add(tc);
	jd.pack();
	jd.setVisible(true);
	
}


}

