/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TransactionListAction extends GECAMedAction 
	{
	private static final long serialVersionUID = 1L;

//***************************************************************************
//* Constructor                                                             *
//***************************************************************************

//---------------------------------------------------------------------------
/** Constructor.
 * @param p_Parent specifies the parent GECAMedModule this action was created for.
 * @param p_Name specifies the name for the Action to be created
 * @param p_Icon specifies the icon representing the Action
 * @param p_Shortcut specifies the shortcut key (EventKey code) to be assigned to the action.
 * @param p_IsTopBarAction specifies whether Action should appear as button in top button bar.
 * @param p_IsBottomBarAction specifies whether Action should appear as button in bottom button bar.
 */
//---------------------------------------------------------------------------

public TransactionListAction (GECAMedModule  	p_Parent,
	                      String      	p_Name, 
	                      ImageIcon   	p_Icon,
	                      int         	p_Shortcut,
	                      boolean			p_IsMenuAction,
	                      boolean     	p_IsTopBarAction,
	                      boolean	   		p_IsBottomBarAction) 
	{	
	super(p_Parent, p_Name, p_Icon, p_Shortcut, p_IsMenuAction, p_IsTopBarAction, p_IsBottomBarAction);
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------
/** Invoked when an action occurs.
 * @param The Action causing the method to be called.
 */
//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event) 
	{
	if (m_Parent instanceof BillingModule)
		{
		((BillingModule)m_Parent).printTransactionList ();
		}
	}
	
//***************************************************************************
//* End of Class				                            					*
//***************************************************************************
}
