/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;
import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;

/**
 * a renderer for KeyValue objects in comboboxes
 *
 * @author Nico MACK
 * 
 * @version
 * <br>$Log$
 * <br>Revision 1.2  2008-09-25 09:42:42  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-03-04 16:16:48  mack
 * <br>Initial commit of file 
 * <br>
 * <br>Revision 1.5  2008-01-15 13:08:50  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class KeyValueComboBoxRenderer extends DefaultComboBoxRenderer
{
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
    private static final long serialVersionUID = 1L;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public KeyValueComboBoxRenderer ()
	{
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer#getRenderString(java.lang.Object)
 */
protected String getRenderString (Object p_Object)
    {
    KeyValue l_KeyValue;
    String	 l_Rendered;
    
    l_Rendered = "";
    
    if (p_Object instanceof KeyValue)
    		{
    		l_KeyValue = (KeyValue) p_Object;
    		l_Rendered = l_KeyValue.getLabel();
    		}
    else l_Rendered = "Not a Key Value";
    
    return l_Rendered;
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}

