/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class KeyValueDialog extends JDialog implements ActionListener,
													   ItemListener,
													   PropertyChangeListener,
													   Relocalizable
{
	
	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger.getLogger(KeyValueDialog.class.getName());
	
	private static final long serialVersionUID = 1L;
	
	private KeyValue				m_KeyValue;
	
	private JPanel					m_TagPanel;
	private TitledBorder			m_TagBorder;
	private JLabel					m_TagLabel;
	private JLabel					m_DescriptionLabel;
	private JTextField				m_Tag;
	private JTextArea				m_Description;

	private JLabel					m_FractionDigitsLabel;
	private JSpinner				m_FractionDigits;
	private JTextField				m_FractionDigitsField;
	
	private JPanel					m_ValuePanel;
	private TitledBorder			m_ValueBorder;
	private JLabel					m_ValueLabel;
	private JLabel					m_FromDateLabel;
	private JFormattedTextField		m_Value;
	private JDateChooser			m_FromDate;
	
	private JButton					m_UpdateButton;
	private JButton					m_CancelButton;
	private boolean					m_Canceled;

	private NumberFormat			m_KeyValueFormat;

	private TitledBorder m_KeyValueBorder;

	private JPanel m_KeyValuePanel;

	private JLabel m_KeyValueLabel;

	private JComboBox<KeyValue> m_KeyValueChooser;

	private JCheckBox m_KeyValueNewBox;

	private IntegerField m_KeyValueNewType;

	private JLabel m_KeyValueNewBoxLabel;

	private JLabel m_KeyValueNewTypeLabel;
	
	private KeyValue EMPTY_KEVAL = new KeyValue();

	private TitledBorder m_InfoBorder;

	private JPanel m_InfoPanel;

	private JCheckBox m_InfoCheckBox;

	private JLabel m_InfoLabel;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
		
	private final static String c_Columns			  = "3dlu,fill:max(30dlu;pref):grow," +
														"3dlu,fill:max(35dlu;pref)," +
														"3dlu,fill:max(35dlu;pref),3dlu";
		
	private final static String c_Rows				  = "3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref,3dlu";
	
	private final static String c_TagColumns      	  = "3dlu,fill:max(40dlu;pref)," +
														"3dlu,fill:max(60dlu;pref):grow,3dlu";

	private final static String c_TagRows 	     	  = "3dlu,fill:pref," +
														"3dlu,fill:pref,3dlu";

	private final static String c_ValueColumns    =		"3dlu,fill:max(40dlu;pref)," +
														"3dlu,fill:max(60dlu;pref):grow,3dlu";

	private final static String c_ValueRows 	  = 	"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref,3dlu";
	
	private final static String c_KeyValueColumns     = "3dlu,fill:max(40dlu;pref)," +
														"3dlu,fill:max(60dlu;pref):grow,3dlu";

	private final static String c_KeyValueRows 	      = "3dlu,fill:pref,3dlu," + 
														"fill:pref,3dlu," +
														"fill:pref,3dlu";

	private static final String c_Title				  = "KeyValueDialog.Title";
	private static final String c_TagBorder			  = "KeyValueDialog.TagBorder";
	private static final String c_TagLabel			  = "KeyValueDialog.TagLabel";
	private static final String c_DescriptionLabel	  = "KeyValueDialog.DescriptionLabel";
	private static final String c_FractionDigitsLabel = "KeyValueDialog.FractionDigitsLabel";
	private static final String c_ValueBorder         = "KeyValueDialog.ValueBorder";
	private static final String c_ValueLabel     	  = "KeyValueDialog.ValueLabel";
	private static final String c_FromDateLabel       = "KeyValueDialog.FromDateLabel";
	private static final String c_KeyValueBorder	  = "KeyValueDialog.KeyValueBorder";
	private static final String c_KeyValueLabel       = "KeyValueDialog.KeyValueLabel";
	private static final String c_KeyValueNewTypeLabel= "KeyValueDialog.KeyValueNewTypeLabel";
	private static final String c_KeyValueNewBoxLabel = "KeyValueDialog.KeyValueNewBoxLabel";
	
//***************************************************************************
//* Constructor                                                             *
//***************************************************************************
	
public KeyValueDialog ()	
	{	
	super (MainFrame.getInstance(),Translatrix.getTranslationString(c_Title),true);
		
	EMPTY_KEVAL.setLabel("");
	
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;	
	Color			l_DefaultColor;
	
	this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
	
	l_Constraints  = new CellConstraints();
	
	l_DefaultColor = (Color) UIManager.getDefaults().get("TextField.inactiveBackground");   
	UIManager.getDefaults().put("TextField.inactiveBackground", Color.WHITE );
		
	m_KeyValueFormat = new DecimalFormat ("#0.00000");
	m_KeyValueFormat.setMaximumFractionDigits(5);
	m_KeyValueFormat.setMinimumFractionDigits(4);
	m_KeyValueFormat.setMaximumIntegerDigits(2);
	m_KeyValueFormat.setMinimumIntegerDigits(1);
	
	this.buildInfoPanel();
	this.buildTagPanel();
	this.buildKeyValuePanel();
	this.buildValuePanel();

	m_UpdateButton    = new JButton ();
	m_UpdateButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.OK));
	m_UpdateButton.addActionListener(this);
	
	m_CancelButton    = new JButton ();
	m_CancelButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
	m_CancelButton.addActionListener(this);
	
	this.relocalize();
	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);

	l_Layout = new FormLayout(c_Columns, c_Rows);
    this.setLayout (l_Layout);

    this.add (m_InfoPanel,  			l_Constraints.xywh(2, 2, 5, 1));
	this.add (m_TagPanel,  				l_Constraints.xywh(2, 4, 5, 1));
	this.add (m_KeyValuePanel,  		l_Constraints.xywh(2, 6, 5, 1));
	this.add (m_ValuePanel,   			l_Constraints.xywh(2, 8, 5, 1));
	this.add (m_UpdateButton,  			l_Constraints.xywh(4, 10, 1, 1));
	this.add (m_CancelButton,  			l_Constraints.xywh(6, 10, 1, 1));
	
	UIManager.getDefaults().put("TextField.inactiveBackground", l_DefaultColor );

	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

private JComponent	buildInfoPanel ()
{
CellConstraints	l_Constraints;
FormLayout		l_Layout;	

l_Layout      = new FormLayout("3dlu,pref:grow,3dlu,", "3dlu,pref,3dlu, pref,3dlu");
l_Constraints = new CellConstraints();

m_InfoBorder = new TitledBorder (Translatrix.getTranslationString("KeyvalueDialog.editTitle"));

m_InfoPanel = new JPanel ();
m_InfoPanel.setOpaque (false);
m_InfoPanel.setLayout(l_Layout);
m_InfoPanel.setBorder(m_InfoBorder);

m_InfoCheckBox = new JCheckBox(Translatrix.getTranslationString("KeyvalueDialog.editBox"));
m_InfoCheckBox.setOpaque(false);
m_InfoCheckBox.addActionListener(new ActionListener() {
	public void actionPerformed(ActionEvent e) {
		setEnabled(m_InfoCheckBox.isSelected());
	}
});

m_InfoLabel	 = new JLabel(Translatrix.getTranslationString("KeyvalueDialog.editLabel"));
m_InfoLabel.setForeground(Color.RED);

m_InfoPanel.add (m_InfoLabel,  				l_Constraints.xywh(2, 2, 1, 1));
m_InfoPanel.add (m_InfoCheckBox,  			l_Constraints.xywh(2, 4, 1, 1));

return m_InfoPanel;
}


private JPanel	buildTagPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;	

	l_Layout      = new FormLayout(c_TagColumns, c_TagRows);
	l_Constraints = new CellConstraints();
	
	m_TagBorder = new TitledBorder ("");

	m_TagPanel = new JPanel ();
	m_TagPanel.setOpaque (false);
	m_TagPanel.setLayout(l_Layout);
	m_TagPanel.setBorder(m_TagBorder);
	
	m_TagLabel  = new JLabel ();
	m_TagLabel.setForeground(GECAMedColors.c_LabelColor);

	m_DescriptionLabel  = new JLabel ();
	m_DescriptionLabel.setForeground(GECAMedColors.c_LabelColor);

	m_Tag = new JTextField ();
	m_Tag.setHorizontalAlignment(JTextField.LEFT);
	
	m_Description = new JTextArea (4,20);
	m_Description.setLineWrap(true);
	m_Description.setWrapStyleWord(true);
	
	m_TagPanel.add (m_TagLabel,  			l_Constraints.xywh(2, 2, 1, 1));
	m_TagPanel.add (m_Tag,   				l_Constraints.xywh(4, 2, 1, 1));
	m_TagPanel.add (m_DescriptionLabel,  	l_Constraints.xywh(2, 4, 1, 1));
	m_TagPanel.add (m_Description,   		l_Constraints.xywh(4, 4, 1, 1));
		
	return m_TagPanel;
	}


//---------------------------------------------------------------------------

private JPanel	buildKeyValuePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;	

	l_Layout      = new FormLayout(c_KeyValueColumns, c_KeyValueRows);
	l_Constraints = new CellConstraints();
	
	m_KeyValueBorder = new TitledBorder ("");
	
	m_KeyValuePanel = new JPanel ();
	m_KeyValuePanel.setOpaque (false);
	m_KeyValuePanel.setLayout(l_Layout);
	m_KeyValuePanel.setBorder(m_KeyValueBorder);
	
	m_KeyValueLabel  = new JLabel ();
	m_KeyValueLabel.setForeground(GECAMedColors.c_LabelColor);

	m_KeyValueChooser     = new JComboBox<KeyValue> ();
//	m_KeyValueChooser.setRenderer(new KeyValueComboBoxRenderer ());
	m_KeyValueChooser.addItemListener(this);
	
	m_KeyValueNewBoxLabel = new JLabel();
	m_KeyValueNewBoxLabel.setForeground(GECAMedColors.c_LabelColor);
	m_KeyValueNewBox = new JCheckBox();
	m_KeyValueNewBox.setOpaque(false);
	m_KeyValueNewBox.setSelected(false);
	m_KeyValueNewBox.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			enableNewType(m_KeyValueNewBox.isSelected());
		}
	});
	
	m_KeyValueNewTypeLabel = new JLabel();
	m_KeyValueNewTypeLabel.setEnabled(false);
	m_KeyValueNewType = new IntegerField();
	m_KeyValueNewType.setEnabled(false);
	
	
	m_KeyValuePanel.add (m_KeyValueLabel,  		l_Constraints.xywh(2, 2, 1, 1));
	m_KeyValuePanel.add (m_KeyValueChooser,   	l_Constraints.xywh(4, 2, 1, 1));
	m_KeyValuePanel.add (m_KeyValueNewBoxLabel, l_Constraints.xywh(2, 4, 1, 1));
	m_KeyValuePanel.add (m_KeyValueNewBox,   	l_Constraints.xywh(4, 4, 1, 1));
	m_KeyValuePanel.add (m_KeyValueNewTypeLabel,l_Constraints.xywh(2, 6, 1, 1));
	m_KeyValuePanel.add (m_KeyValueNewType,   	l_Constraints.xywh(4, 6, 1, 1));
	
	return m_KeyValuePanel;
	}

protected void enableNewType (boolean selected) {

	if (selected) {
		int					l_DialogOption;
		
		// Warn the user not to add a key, if an existing key changed
		l_DialogOption	= GECAMedBaseDialogImpl.showMessageDialog(
				MainFrame.getInstance(), 
				Translatrix.getTranslationString("KeyValueDialog.WarnBeforeAddingKey_title"),
				Translatrix.getTranslationString("KeyValueDialog.WarnBeforeAddingKey_message"), 
				GECAMedBaseDialogImpl.YES_NO_BUTTON_MODE, 
				GECAMedModule.getIcon(GECAMedIconNames.WARNING));
		
		if (l_DialogOption != GECAMedBaseDialogImpl.YES_OPTION)
		{
			m_KeyValueChooser.removeItem(EMPTY_KEVAL);
			m_KeyValueNewBox.setSelected(false);
			m_KeyValueNewType.setText("");
			return;
		} 
		m_KeyValueChooser.addItem(EMPTY_KEVAL);
		m_KeyValueChooser.setSelectedItem(EMPTY_KEVAL);
	} else {
		m_KeyValueChooser.removeItem(EMPTY_KEVAL);
	}
	
	m_KeyValueChooser.setEnabled(!selected);
	m_KeyValueLabel.setEnabled(!selected);
	m_KeyValueNewType.setEnabled(selected);
	m_KeyValueNewTypeLabel.setEnabled(selected);

}

public void setEnabled (boolean p_EnableIt)
{
	
m_Tag.setEditable(p_EnableIt);
m_Description.setEditable(p_EnableIt);
m_KeyValueChooser.setEnabled(p_EnableIt);
m_KeyValueNewBox.setEnabled (p_EnableIt);
m_Value.setEditable(p_EnableIt);
m_FractionDigits.setEnabled(p_EnableIt);
m_FromDate.setEnabled(p_EnableIt);

m_UpdateButton.setEnabled(p_EnableIt);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

private JPanel buildValuePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;	

	l_Layout = new FormLayout(c_ValueColumns, c_ValueRows);
	l_Constraints = new CellConstraints();

	m_ValueBorder = new TitledBorder ("");

	m_ValuePanel = new JPanel ();
	m_ValuePanel.setOpaque (false);
	m_ValuePanel.setLayout (l_Layout);
	m_ValuePanel.setBorder (m_ValueBorder);
	
	m_ValueLabel  = new JLabel ();
	m_ValueLabel.setForeground(GECAMedColors.c_LabelColor);

	m_FromDateLabel  = new JLabel ();
	m_FromDateLabel.setForeground(GECAMedColors.c_LabelColor);

	m_Value = new JFormattedTextField (m_KeyValueFormat);
	m_Value.setHorizontalAlignment(JTextField.RIGHT);
	m_Value.setText (m_KeyValueFormat.format(0));
	m_Value.addPropertyChangeListener(this);
	
	m_FractionDigitsLabel  = new JLabel ();
	m_FractionDigitsLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_FractionDigits   = new JSpinner (new SpinnerNumberModel (1,1,2,1));
	
	m_FractionDigitsField = new JTextField ();
	m_FractionDigitsField.setHorizontalAlignment(JTextField.RIGHT);
	m_FractionDigitsField.setText ("0");
	m_FractionDigitsField.setEditable(false);
	
	m_FromDate = GECAMedGuiUtils.getDateChooser(false);
	m_FromDate.setDate(new Date ());
	m_FromDate.addPropertyChangeListener(this);
	m_FromDate.getDateEditor().addPropertyChangeListener(this);
	
	m_ValuePanel.add (m_ValueLabel,  		l_Constraints.xywh(2, 2, 1, 1));
	m_ValuePanel.add (m_Value,   			l_Constraints.xywh(4, 2, 1, 1));
	m_ValuePanel.add (m_FractionDigitsLabel,l_Constraints.xywh(2, 4, 1, 1));
	m_ValuePanel.add (m_FractionDigits,   	l_Constraints.xywh(4, 4, 1, 1));
	m_ValuePanel.add (m_FromDateLabel,  	l_Constraints.xywh(2, 6, 1, 1));
	m_ValuePanel.add (m_FromDate,   		l_Constraints.xywh(4, 6, 1, 1));
		
	return m_ValuePanel;
	}

//---------------------------------------------------------------------------

public void setKeyValues (Collection <KeyValue> p_KeyValues)
{
	Iterator <KeyValue>	l_KeyValueIterator;
	
	if (p_KeyValues == null) return;
	
	m_KeyValueChooser.removeItemListener (this);
	m_KeyValueChooser.removeAllItems();
	l_KeyValueIterator = p_KeyValues.iterator();
	while (l_KeyValueIterator.hasNext())
		{
		m_KeyValueChooser.addItem (l_KeyValueIterator.next());
		}
	m_KeyValueChooser.setSelectedIndex(0);
	m_KeyValueChooser.addItemListener (this);
}

private double getValue ()
	{
	Number	l_NextValue;

	try	{
		l_NextValue = m_KeyValueFormat.parse (m_Value.getText());
		}
	catch (ParseException p_Exception)
		{
		l_NextValue = 0;
		}

	return l_NextValue.doubleValue();
	}

//---------------------------------------------------------------------------

private KeyValue updateKeyValueFromDialog (KeyValue p_KeyValue)
	{	
	if (p_KeyValue == null) return p_KeyValue;	
		
	p_KeyValue.setLabel(m_Tag.getText());	
	p_KeyValue.setDescription(m_Description.getText());
	
	if (m_KeyValueNewBox.isSelected()) {
		p_KeyValue.setKeyType(m_KeyValueNewType.getValue());
	} else {
		p_KeyValue.setKeyType(((KeyValue)m_KeyValueChooser.getSelectedItem()).getKeyType());		
	}
	
	p_KeyValue.setApplicability(m_FromDate.getDate());
	p_KeyValue.setValue(this.getValue());
	p_KeyValue.setFractionDigits((Integer)(m_FractionDigits.getValue()));

	return p_KeyValue;
	}

//---------------------------------------------------------------------------

private void updateDialogFromKeyValue (KeyValue p_KeyValue)
	{	
	if (p_KeyValue == null)  {
		m_Tag.setText("");
		m_Description.setText("");
		m_KeyValueChooser.setEnabled(true);
		m_KeyValueNewBox.setEnabled(true);
		m_KeyValueNewBox.setSelected(false);
		m_KeyValueNewType.setText("");
		m_KeyValueChooser.setSelectedIndex(0);	
		m_Value.setText ("0.00");		
		m_FromDate.setDate(new Date());
		m_FractionDigits.setValue(2);
		m_FractionDigitsField.setText("2");
	} else {
		m_Tag.setText(p_KeyValue.getLabel());
		m_Description.setText(p_KeyValue.getDescription());
		
		m_KeyValueChooser.setEnabled(! p_KeyValue.isPersistent());
		m_KeyValueNewBox.setEnabled(! p_KeyValue.isPersistent());
		m_KeyValueNewBox.setSelected(false);
		m_KeyValueNewType.setText("");
		
		for (int i = 0; i < m_KeyValueChooser.getItemCount(); i++) {
			KeyValue val = m_KeyValueChooser.getItemAt(i);
			if (val.getKeyType() !=null && val.getKeyType().equals(p_KeyValue.getKeyType())) {
				m_KeyValueChooser.setSelectedIndex(i);	
				m_KeyValueNewType.setText(val.getKeyType()+"");
				break;
			}
		}
		
		try {
			m_Value.setText (m_KeyValueFormat.format(p_KeyValue.getValue()));		
		} catch (Exception e) {
			logger.warn("error formating keyvalue", e);
		}
		m_FromDate.setDate(p_KeyValue.getApplicability());
		m_FractionDigits.setValue(p_KeyValue.getFractionDigits());
		m_FractionDigitsField.setText(p_KeyValue.getFractionDigits().toString());
	}
		
	}

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public void setKeyValue (KeyValue p_KeyValue)
	{
	if (p_KeyValue != null) m_KeyValue = p_KeyValue;
	m_Canceled = false;
	

	}

//---------------------------------------------------------------------------

public KeyValue getKeyValue ()
	{
	return m_KeyValue;
	}

//---------------------------------------------------------------------------

public boolean wasCanceled ()
	{
	return m_Canceled;	
	}

//---------------------------------------------------------------------------

public void setVisible (boolean p_showIt)
	{
	if (p_showIt)
		{
		m_KeyValue = this.getKeyValue();
		this.enableNewType(false);
		this.updateDialogFromKeyValue(m_KeyValue);
		
		m_InfoCheckBox.setEnabled(m_KeyValue.isPersistent());
		m_InfoLabel.setEnabled(m_KeyValue.isPersistent());
		setEnabled(! m_KeyValue.isPersistent());
		
		}
	super.setVisible(p_showIt);
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_ActionEvent) 
	{
	if (p_ActionEvent.getSource() == m_CancelButton)
		{
		this.setVisible (false);
		m_Canceled = true;
		}
	else if (p_ActionEvent.getSource() == m_UpdateButton)
		{
		m_KeyValue = this.updateKeyValueFromDialog(m_KeyValue);
		m_Canceled = false;
		this.setVisible (false);
		}
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	this.setTitle(Translatrix.getTranslationString(c_Title));

	if (m_TagBorder != null)
		m_TagBorder.setTitle (Translatrix.getTranslationString(c_TagBorder));
		
	if (m_TagLabel != null)
		m_TagLabel.setText (Translatrix.getTranslationString(c_TagLabel));

	if (m_DescriptionLabel != null)
		m_DescriptionLabel.setText (Translatrix.getTranslationString(c_DescriptionLabel));

	if (m_FractionDigitsLabel != null)
		m_FractionDigitsLabel.setText (Translatrix.getTranslationString(c_FractionDigitsLabel));
	
	if (m_ValueBorder != null)
		m_ValueBorder.setTitle (Translatrix.getTranslationString(c_ValueBorder));

	if (m_ValueLabel != null)
		m_ValueLabel.setText (Translatrix.getTranslationString(c_ValueLabel));
	
	if (m_FromDateLabel != null)
		m_FromDateLabel.setText (Translatrix.getTranslationString(c_FromDateLabel));
	
	if (m_KeyValueBorder != null)
		m_KeyValueBorder.setTitle (Translatrix.getTranslationString(c_KeyValueBorder));
	
	if (m_KeyValueLabel != null)
		m_KeyValueLabel.setText (Translatrix.getTranslationString(c_KeyValueLabel));
	
	if (m_KeyValueNewBoxLabel != null)
		m_KeyValueNewBoxLabel.setText(Translatrix.getTranslationString(c_KeyValueNewBoxLabel));
	
	if (m_KeyValueNewTypeLabel != null)
		m_KeyValueNewTypeLabel.setText (Translatrix.getTranslationString(c_KeyValueNewTypeLabel));
	
	if (m_FromDate != null) 
		{
		m_FromDate.setLocale (Translatrix.getLocale());
		m_FromDate.setDateFormatString("d MMMM yyyy");   
		m_FromDate.getDateEditor().setLocale (Translatrix.getLocale());
		}

	if (m_UpdateButton != null)
		m_UpdateButton.setText (Translatrix.getTranslationString("core.save"));
	
	if (m_CancelButton != null)
		m_CancelButton.setText(Translatrix.getTranslationString("core.cancel"));
	}

//---------------------------------------------------------------------------

public void itemStateChanged(ItemEvent p_ItemEvent) 
	{
//	Object	l_Source;
//	
//	l_Source = p_ItemEvent.getItemSelectable();
//	if ((l_Source == m_EditCurrent) && (this.isEnabled()))
//		{
//		if (p_ItemEvent.getStateChange() == ItemEvent.DESELECTED)
//			{
//			this.setEnabledState(false);
//			}
//		else if (p_ItemEvent.getStateChange() == ItemEvent.SELECTED)
//			{
//			this.setEnabledState(true);
//			}
//		}
	}

//---------------------------------------------------------------------------

public void propertyChange(PropertyChangeEvent p_Event)
	{
	if (!this.isVisible()) return;
	
//	if ((p_Event.getSource().equals(m_FromDate)) 
//			&& ("date".equals(p_Event.getPropertyName())))
//		{
//		this.makeFuturValueCurrent();
//		}
//	else if (p_Event.getSource().equals(m_Value))
//		{
//		this.makeFuturValueCurrent();	
//		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class				                            				*
//***************************************************************************
//---------------------------------------------------------------------------	
}
