/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.RateIndex;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;

public class RateTreeCellRenderer extends DefaultTreeCellRenderer
	{
	private static final long serialVersionUID = 1L;

	private ImageIcon	m_RateIcon;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public RateTreeCellRenderer ()
	{
	this.setOpaque(true);	
	m_RateIcon = BillingModule.getIconResource("rate_tiny.png");
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTreeCellRendererComponent(JTree p_Tree, Object p_Value, 
											  boolean p_IsSelected, boolean p_IsExpanded, boolean p_IsLeaf, 
											  int p_Row, boolean p_HasFocus) 
	{
    RateTreeNode				l_Node;
	Component 					l_Component;
	DefaultTreeCellRenderer		l_Renderer;
	Icon						l_Icon;
	
	l_Component = super.getTreeCellRendererComponent(p_Tree, p_Value, 
													 p_IsSelected, p_IsExpanded, p_IsLeaf,
													 p_Row, p_HasFocus);	
	
	if (l_Component instanceof DefaultTreeCellRenderer)
		{
		l_Renderer = (DefaultTreeCellRenderer)l_Component;
		l_Node =     (RateTreeNode) p_Value;
		if (l_Node.getRate() != null) 
			{
			this.setIcon(m_RateIcon);
			this.setText(l_Node.getRate().getCode());
			}
		else if (p_IsLeaf && l_Node.getRate() != null) 
		{
			this.setIcon(m_RateIcon);
			this.setText(l_Node.getRate().getCode());
		}
		else
			{
			l_Icon = (p_IsSelected)?l_Renderer.getOpenIcon():l_Renderer.getClosedIcon();
			this.setIcon(l_Icon);	
				if (l_Node.getRateIndex() != null) {
					RateIndex l_Rate = l_Node.getRateIndex();
					this.setText(RatesPanel.getNodeLabel(l_Rate));
//					this.setText(l_Node.getRateIndex().getTitle());
				}
			}
		}
	
	return this;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                             *
//***************************************************************************
//---------------------------------------------------------------------------

	}
