/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.util.ConcurrentModificationException;
import java.util.Enumeration;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Rate;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.RateIndex;

import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

//***************************************************************************
//* Class Definition and Members	                                        *
//***************************************************************************

public class RateTreeNode extends DefaultMutableTreeTableNode
	{
//	private static final long serialVersionUID = 1L;
	
	RateIndex			m_RateIndex;
	Rate				m_Rate;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public RateIndex getRateIndex ()
	{
	return 	m_RateIndex;
	}
	
//---------------------------------------------------------------------------

public void setRateIndex (RateIndex p_RateIndex)
	{
	m_RateIndex = p_RateIndex;
	}
	
//---------------------------------------------------------------------------

public Rate getRate ()
	{
	return 	m_Rate;
	}
	
//---------------------------------------------------------------------------

public void setRate (Rate p_Rate)
	{
	m_Rate 	= p_Rate;
	}

//---------------------------------------------------------------------------

public void removeAllChildren()
{
	removeAllChildren(this);
}

//---------------------------------------------------------------------------

private void removeAllChildren (MutableTreeTableNode p_Node)
	{
	Enumeration<? extends MutableTreeTableNode>	l_Children = p_Node.children();
	MutableTreeTableNode l_Child;
	
	while (l_Children.hasMoreElements())
		{
		try {
			l_Child	= l_Children.nextElement();
			removeAllChildren(l_Child);			
			p_Node.remove(l_Child);
		} catch (ConcurrentModificationException e) {
		}
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Clas                                                             *
//***************************************************************************
//---------------------------------------------------------------------------

	}
