/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.config;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.utils.BillingUserSettings;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
*
* @author nmac / jhermen
*/

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class BillingUserSettingsPlugin extends SettingsPlugin 
	{
	private static final long serialVersionUID = 1L;
	
	private JPanel					m_TemplateSettingsPanel;
	
	private JLabel					m_TemplateButtonsLabel;
	private JSpinner				m_TemplateButtons;
	private JLabel					m_TemplateButtonsUnit;
	private JLabel					m_LoadTemplateSuffixesLabel;
	private JCheckBox				m_LoadTemplateSuffixes;
	private JLabel					m_LoadTemplateQuantityLabel;
	private JCheckBox				m_LoadTemplateQuantity;
	
	private JPanel					m_TransactionsPanel;	
	private JLabel					m_EffectiveTransactionsLabel;
	private JCheckBox				m_EffectiveTransactions;
	
	private JPanel					m_VerificationPanel;
	private JLabel					m_AutoVerificationLabel;
	private JCheckBox				m_AutoVerification;
	
	private JPanel					m_InvoiceEditingPanel;
	private JLabel					m_AutomaticallyAddActsLabel;
	private JCheckBox				m_AutomaticallyAddActs;
	
	private JPanel					m_AgendaGroupsPanel;
//	private ButtonGroup				m_AgendaGroupsButtons;
	private JRadioButton			m_ClientAgendaGroups;
	private JRadioButton			m_ServerAgendaGroups;
	
	private JPanel					m_MixedActsPanel;
	private JLabel					m_RulesNotAppliedWarning;
	private JRadioButton			m_NeverWarnIfRulesNotApplied;
	private JRadioButton			m_UcmWarnIfRulesNotApplied;
	private JRadioButton			m_AlwaysWarnIfRulesNotApplied;
	private JLabel					m_ApplyRulesForNonCnsInsurance;
	private JRadioButton			m_AllowRulesForNotCnsInsuranceNever;
	private JRadioButton			m_AllowRulesForNotCnsInsuranceAsk;
	private JRadioButton			m_AllowRulesForNotCnsInsuranceAlways;
	
	private JLabel					m_AllowMixedActsLabel;
	private JRadioButton			m_NeverAllowCnsWithNonCnsActs;
	private JRadioButton			m_AskAllowCnsWithNonCnsActs;
	private JRadioButton			m_AlwaysAllowCnsWithNonCnsActs;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	public static final String	c_ServerAgendaGroups						= "server";
	public static final String	c_ClientAgendaGroups						= "client";
	
	public static final int		c_WarnIfRulesNotAppliedNever				= 0;
	public static final int		c_WarnIfRulesNotAppliedUCM					= 1;
	public static final int		c_WarnIfRulesNotAppliedAlways				= 2;
	private static final int	c_WarnIfRulesNotAppliedDefault				= c_WarnIfRulesNotAppliedUCM;
	
	public static final int		c_AllowRulesForNotCnsInsuranceNever			= 0;
	public static final int		c_AllowRulesForNotCnsInsuranceAsk			= 1;
	public static final int		c_AllowRulesForNotCnsInsuranceAlways		= 2;
	private static final int	c_AllowRulesForNotCnsInsuranceDefault		= c_AllowRulesForNotCnsInsuranceAsk;
	
	public static final int		c_AllowCnsAndNonCnsCodesOnInvoiceNever		= 0;
	public static final int		c_AllowCnsAndNonCNSCodesOnInvoiceAsk		= 1;
	public static final int		c_AllowCnsAndNonCNSCodesOnInvoiceAlways		= 2;
	private static final int	c_AllowCNSAndNonCNSCodesOnInvoiceDefault	= c_AllowCnsAndNonCNSCodesOnInvoiceAsk;
	
	
	public static final String	c_AgendaGroupsStationary			= c_ServerAgendaGroups;
	public static final int		c_TemplateButtonsStationary			= 6;
	public static final boolean c_LoadTemplateSuffixesStationary	= false;
	public static final boolean c_LoadTemplateQuantityStationary	= false;
	public static final boolean	c_EffectiveTransactionsStationary	= false;	
	public static final boolean	c_AutoVerificationStationary		= false;	
	public static final boolean c_AutomaticallyAddActsStationary	= true;
	
	public static final String c_BillingSettingsName = BillingModule.MODULE_NAME;
	
	private final static String c_TemplateColumns		= 	"3dlu,fill:max(100dlu;pref)," +
															"3dlu,fill:max(25dlu;pref)," +
															"3dlu,fill:max(50dlu;pref),3dlu";

	private final static String c_TemplateRows			=   "3dlu,fill:pref:grow," +
	    													"3dlu,fill:pref," +
	    													"3dlu,fill:pref," +
													    	"3dlu,fill:pref,3dlu,";

	private final static String c_TransactionsColumns	= 	"3dlu,fill:max(100dlu;pref)," +
															"3dlu,fill:max(75dlu;pref),3dlu";

	private final static String c_TransactionsRows		=   "3dlu,fill:pref,3dlu";

	private final static String c_VerificationColumns	= 	"3dlu,fill:max(100dlu;pref)," +
															"3dlu,fill:max(75dlu;pref),3dlu";

	private final static String c_VerificationRows		=   "3dlu,fill:pref,3dlu";

	private final static String c_InvoiceEditingColumns	= 	"3dlu,fill:max(100dlu;pref)," +
															"3dlu,fill:max(75dlu;pref),3dlu";

	private final static String c_InvoiceEditingRows	=   "3dlu,fill:pref,3dlu";

//	private final static String c_AgendaGroupsColumns	= 	"3dlu,fill:pref,3dlu";
//
//	private final static String c_AgendaGroupsRows		=   "3dlu,fill:pref," +
//													    	"3dlu,fill:pref,3dlu";
	
//***************************************************************************
//* Constructors                                       						*
//***************************************************************************
	
//---------------------------------------------------------------------------
	
public BillingUserSettingsPlugin (String p_Name) 
	{
	super(p_Name);
	this.init();
	}

//---------------------------------------------------------------------------

public BillingUserSettingsPlugin () 
	{
	super(c_BillingSettingsName);
	this.init();
	}
	
//---------------------------------------------------------------------------

private void init ()
	{
	this.setStationaryValues();
	buildPanel();	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

private void buildPanel() 
	{
	CellConstraints	l_Constraints	= new CellConstraints();
	FormLayout		l_Layout;
	SpinnerModel	l_SpinnerModel;
	ButtonGroup		l_ButtonGroup;
	
	//======================================================================
	//= Build Template Settings Panel
	//======================================================================

	l_Layout = new FormLayout(c_TemplateColumns, c_TemplateRows);
	
	m_TemplateSettingsPanel 	= createSubPanel("");
	m_TemplateSettingsPanel.setLayout(l_Layout);
	
	l_SpinnerModel 				= new SpinnerNumberModel (0,0,1000,1);
	
	m_TemplateButtonsLabel  	= new JLabel ();
	m_TemplateButtons       	= new JSpinner (l_SpinnerModel);
	m_TemplateButtonsUnit		= new JLabel ();
	
	m_LoadTemplateSuffixesLabel	= new JLabel();
	m_LoadTemplateSuffixes		= new JCheckBox();
	
	m_LoadTemplateQuantityLabel	= new JLabel();
	m_LoadTemplateQuantity		= new JCheckBox();
	
	m_TemplateSettingsPanel.add (m_TemplateButtonsLabel,		l_Constraints.xywh(2, 2, 1, 3));
	m_TemplateSettingsPanel.add (m_TemplateButtons,				l_Constraints.xywh(4, 4, 1, 1));
	m_TemplateSettingsPanel.add (m_TemplateButtonsUnit,			l_Constraints.xywh(6, 4, 1, 1));
	m_TemplateSettingsPanel.add (m_LoadTemplateSuffixesLabel,	l_Constraints.xywh(2, 6, 1, 1));
	m_TemplateSettingsPanel.add (m_LoadTemplateSuffixes,		l_Constraints.xywh(4, 6, 1, 1));
	m_TemplateSettingsPanel.add (m_LoadTemplateQuantityLabel,	l_Constraints.xywh(2, 8, 1, 1));
	m_TemplateSettingsPanel.add (m_LoadTemplateQuantity,		l_Constraints.xywh(4, 8, 1, 1));
			
	//======================================================================
	//= Build Transactions Settings Panel
	//======================================================================
	
	l_Layout = new FormLayout(c_TransactionsColumns, c_TransactionsRows);
	
	m_TransactionsPanel = createSubPanel("");
	m_TransactionsPanel.setLayout(l_Layout);
	
	m_EffectiveTransactionsLabel	    = new JLabel ();
	m_EffectiveTransactions = new JCheckBox ();
	
	m_TransactionsPanel.add (m_EffectiveTransactionsLabel,  l_Constraints.xywh(2, 2, 1, 1));
	m_TransactionsPanel.add (m_EffectiveTransactions,   	l_Constraints.xywh(4, 2, 1, 1));
	
	//======================================================================
	//= Build Verification Settings Panel
	//======================================================================
	
	l_Layout = new FormLayout(c_VerificationColumns, c_VerificationRows);
	
	m_VerificationPanel = createSubPanel("");
	m_VerificationPanel.setLayout(l_Layout);
	
	m_AutoVerificationLabel	= new JLabel ();
	m_AutoVerification 		= new JCheckBox ();
	
	m_VerificationPanel.add (m_AutoVerificationLabel,  l_Constraints.xywh(2, 2, 1, 1));
	m_VerificationPanel.add (m_AutoVerification,   	   l_Constraints.xywh(4, 2, 1, 1));

	//======================================================================
	//= Invoice Editing Settings Panel
	//======================================================================
	
	l_Layout = new FormLayout(c_InvoiceEditingColumns, c_InvoiceEditingRows);
	
	m_InvoiceEditingPanel = createSubPanel("");
	m_InvoiceEditingPanel.setLayout(l_Layout);
	
	m_AutomaticallyAddActsLabel	= new JLabel ();
	m_AutomaticallyAddActs 		= new JCheckBox ();
	
	m_InvoiceEditingPanel.add (m_AutomaticallyAddActsLabel,  l_Constraints.xywh(2, 2, 1, 1));
	m_InvoiceEditingPanel.add (m_AutomaticallyAddActs,   	 l_Constraints.xywh(4, 2, 1, 1));

	//======================================================================
	//= Build Agenda Groups Settings Panel
	//======================================================================
	
	l_Layout = new FormLayout("3dlu,f:p,3dlu,f:p,3dlu", 
			" 0dlu,f:p," + // server rules
			" 0dlu,f:p," + // client rules
			" 3dlu,f:p," + // never warn
			" 3dlu,f:p," + // warn if UCM affiliated
			" 3dlu,f:p," + // always warn
			"10dlu,f:p," + // always allow
			" 3dlu,f:p," + // ask to allow
			" 3dlu,f:p," + // never allow
			" 3dlu");
	
	m_AgendaGroupsPanel = createSubPanel ("");
	m_AgendaGroupsPanel.setLayout(l_Layout);
	
	m_ServerAgendaGroups = new JRadioButton ();
	m_ServerAgendaGroups.setActionCommand (c_ServerAgendaGroups);
	m_ServerAgendaGroups.setSelected(true);
	m_ServerAgendaGroups.setEnabled(false);
	
	m_ClientAgendaGroups = new JRadioButton ();
	m_ClientAgendaGroups.setActionCommand (c_ClientAgendaGroups);
	m_ClientAgendaGroups.setEnabled(false);
	
	l_ButtonGroup = new ButtonGroup();
	l_ButtonGroup.add(m_ServerAgendaGroups);
	l_ButtonGroup.add(m_ClientAgendaGroups);
	
	m_RulesNotAppliedWarning		= new JLabel();
	m_NeverWarnIfRulesNotApplied	= new JRadioButton();
	m_UcmWarnIfRulesNotApplied		= new JRadioButton();
	m_AlwaysWarnIfRulesNotApplied	= new JRadioButton();
	
	l_ButtonGroup					= new ButtonGroup();
	l_ButtonGroup.add(m_NeverWarnIfRulesNotApplied);
	l_ButtonGroup.add(m_AlwaysWarnIfRulesNotApplied);
	l_ButtonGroup.add(m_UcmWarnIfRulesNotApplied);
	
	m_ApplyRulesForNonCnsInsurance			= new JLabel();
	m_AllowRulesForNotCnsInsuranceNever		= new JRadioButton();
	m_AllowRulesForNotCnsInsuranceAsk		= new JRadioButton();
	m_AllowRulesForNotCnsInsuranceAlways	= new JRadioButton();
	
	l_ButtonGroup					= new ButtonGroup();
	l_ButtonGroup.add(m_AllowRulesForNotCnsInsuranceNever);
	l_ButtonGroup.add(m_AllowRulesForNotCnsInsuranceAsk);
	l_ButtonGroup.add(m_AllowRulesForNotCnsInsuranceAlways);
	
	
	// dont't show these options, as they're not implemented
//	m_AgendaGroupsPanel.add(m_ServerAgendaGroups, 					l_Constraints.xyw (2, 2, 3));
//	m_AgendaGroupsPanel.add(m_ClientAgendaGroups, 					l_Constraints.xyw (2, 4, 3));
	m_AgendaGroupsPanel.add(m_RulesNotAppliedWarning,				l_Constraints.xywh(2, 6, 1, 5, 
			CellConstraints.FILL, CellConstraints.TOP));
	m_AgendaGroupsPanel.add(m_NeverWarnIfRulesNotApplied,			l_Constraints.xy  (4, 6));
	m_AgendaGroupsPanel.add(m_UcmWarnIfRulesNotApplied,				l_Constraints.xy  (4, 8));
	m_AgendaGroupsPanel.add(m_AlwaysWarnIfRulesNotApplied,			l_Constraints.xy  (4,10));
	m_AgendaGroupsPanel.add(m_ApplyRulesForNonCnsInsurance,			l_Constraints.xywh(2,12, 1, 5, 
			CellConstraints.FILL, CellConstraints.TOP));
	m_AgendaGroupsPanel.add(m_AllowRulesForNotCnsInsuranceAlways,	l_Constraints.xy  (4,12));
	m_AgendaGroupsPanel.add(m_AllowRulesForNotCnsInsuranceAsk,		l_Constraints.xy  (4,14));
	m_AgendaGroupsPanel.add(m_AllowRulesForNotCnsInsuranceNever,	l_Constraints.xy  (4,16));
	
	//======================================================================
	//= Build Warning Settings Panel
	//======================================================================
	
	l_Layout = new FormLayout("3dlu,f:p,3dlu,f:p,3dlu", "3dlu,f:p,3dlu,f:p,3dlu,f:p,3dlu");
	
	m_MixedActsPanel				= createSubPanel("");
	m_MixedActsPanel.setLayout(l_Layout);
	
	m_AllowMixedActsLabel			= new JLabel();
	m_NeverAllowCnsWithNonCnsActs	= new JRadioButton();
	m_AskAllowCnsWithNonCnsActs		= new JRadioButton();
	m_AlwaysAllowCnsWithNonCnsActs	= new JRadioButton();
	
	l_ButtonGroup					= new ButtonGroup();
	l_ButtonGroup.add(m_NeverAllowCnsWithNonCnsActs);
	l_ButtonGroup.add(m_AskAllowCnsWithNonCnsActs);
	l_ButtonGroup.add(m_AlwaysAllowCnsWithNonCnsActs);
	
	m_MixedActsPanel.add(m_AllowMixedActsLabel,				l_Constraints.xywh(2, 2, 1, 5, CellConstraints.FILL, CellConstraints.TOP));
	m_MixedActsPanel.add(m_NeverAllowCnsWithNonCnsActs,		l_Constraints.xy  (4, 2));
	m_MixedActsPanel.add(m_AskAllowCnsWithNonCnsActs,		l_Constraints.xy  (4, 4));
	m_MixedActsPanel.add(m_AlwaysAllowCnsWithNonCnsActs,	l_Constraints.xy  (4, 6));
	
	this.addSubPanel(m_InvoiceEditingPanel);
	this.addSubPanel(m_TemplateSettingsPanel);
	this.addSubPanel(m_TransactionsPanel);
	this.addSubPanel(m_VerificationPanel);
	this.addSubPanel(m_AgendaGroupsPanel);
	this.addSubPanel(m_MixedActsPanel);
	
	
	setIcon(BillingModule.getIconResource("billing.png"));
	
	this.relocalize();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void revertToDefaults() 
	{
	Integer option;
	
	
	m_AutomaticallyAddActs.setSelected ((this.getDefault(BillingUserSettings.c_AutomaticallyAddActsSetting) != null)
			   ?(Boolean)this.getDefault(BillingUserSettings.c_AutomaticallyAddActsSetting)
			   :c_AutomaticallyAddActsStationary);

	m_TemplateButtons.setValue			(this.getDefault (BillingUserSettings.c_TemplateButtonsSetting));
	m_LoadTemplateSuffixes.setSelected	((this.getDefault(BillingUserSettings.c_LoadTemplateSuffixesSettings) != null)
													?(Boolean)this.getDefault(BillingUserSettings.c_LoadTemplateSuffixesSettings)
													:c_LoadTemplateSuffixesStationary);
	m_LoadTemplateQuantity.setSelected	((this.getDefault(BillingUserSettings.c_LoadTemplateQuantitySettings) != null)
													?(Boolean)this.getDefault(BillingUserSettings.c_LoadTemplateQuantitySettings)
													:c_LoadTemplateQuantityStationary);
	m_EffectiveTransactions.setSelected ((this.getDefault(BillingUserSettings.c_EffectiveTransactionsSetting) != null)
												   ?(Boolean)this.getDefault(BillingUserSettings.c_EffectiveTransactionsSetting)
												   :c_EffectiveTransactionsStationary);
	
	m_AutoVerification.setSelected ((this.getDefault(BillingUserSettings.c_AutoVerificationSetting) != null)
												   ?(Boolean)this.getDefault(BillingUserSettings.c_AutoVerificationSetting)
												   :c_AutoVerificationStationary);
	
	m_ServerAgendaGroups.setSelected(c_ServerAgendaGroups.equals (this.getDefault(BillingUserSettings.c_AgendaGroupsSetting)));
	m_ClientAgendaGroups.setSelected(c_ClientAgendaGroups.equals (this.getDefault(BillingUserSettings.c_AgendaGroupsSetting)));
	
	option	= (Integer) this.getDefault(BillingUserSettings.c_WarnIfRulesNotApplied);
	if (option == null)
		option	= c_WarnIfRulesNotAppliedDefault;
	
	switch (option.intValue())
	{
		case c_WarnIfRulesNotAppliedAlways:
			m_AlwaysWarnIfRulesNotApplied.setSelected(true);
			break;
			
		case c_WarnIfRulesNotAppliedUCM:
			m_UcmWarnIfRulesNotApplied.setSelected(true);
			break;
			
		case c_WarnIfRulesNotAppliedNever:
		default:
			m_NeverWarnIfRulesNotApplied.setSelected(true);
			break;
	}
	
	option	= (Integer) this.getDefault(BillingUserSettings.c_AllowPrivateActsForCnsInsurance);
	if (option == null)
		option = c_AllowCNSAndNonCNSCodesOnInvoiceDefault;
	
	switch (option.intValue())
	{
		case c_AllowCnsAndNonCNSCodesOnInvoiceAlways:
			m_AlwaysAllowCnsWithNonCnsActs.setSelected(true);
			break;
		
		case c_AllowCnsAndNonCnsCodesOnInvoiceNever:
			m_NeverAllowCnsWithNonCnsActs.setSelected(true);
			break;
		
		case c_AllowCnsAndNonCNSCodesOnInvoiceAsk:
		default:
			m_AskAllowCnsWithNonCnsActs.setSelected(true);
			break;
	}
	
	option	= (Integer) this.getDefault(BillingUserSettings.c_AllowRulesForNotCnsInsurance);
	if (option == null)
		option = c_AllowRulesForNotCnsInsuranceDefault;
	
	switch (option.intValue())
	{
		case c_AllowRulesForNotCnsInsuranceNever:
			m_AllowRulesForNotCnsInsuranceNever.setSelected(true);
			break;
		
		case c_AllowRulesForNotCnsInsuranceAlways:
			m_AllowRulesForNotCnsInsuranceAlways.setSelected(true);
			break;
		
		case c_AllowRulesForNotCnsInsuranceAsk:
		default:
			m_AllowRulesForNotCnsInsuranceAsk.setSelected(true);
			break;
	}
	
	
	this.reflectSettings();
	super.revertToDefaults();
	}

//---------------------------------------------------------------------------

public void updateSettings() 
	{
	this.setValue (BillingUserSettings.c_AutomaticallyAddActsSetting, m_AutomaticallyAddActs.isSelected());
	
	this.setValue (BillingUserSettings.c_TemplateButtonsSetting, m_TemplateButtons.getValue());
	
	this.setValue (BillingUserSettings.c_LoadTemplateSuffixesSettings, m_LoadTemplateSuffixes.isSelected());
	
	this.setValue (BillingUserSettings.c_LoadTemplateQuantitySettings, m_LoadTemplateQuantity.isSelected());
	
	this.setValue (BillingUserSettings.c_EffectiveTransactionsSetting, m_EffectiveTransactions.isSelected());
	
	this.setValue (BillingUserSettings.c_AutoVerificationSetting, m_AutoVerification.isSelected());

	if (m_ServerAgendaGroups.isSelected()) 
		{
		this.setValue(BillingUserSettings.c_AgendaGroupsSetting, 	c_ServerAgendaGroups);
		}
	else if (m_ClientAgendaGroups.isSelected()) 	
		{
		this.setValue(BillingUserSettings.c_AgendaGroupsSetting, 	c_ClientAgendaGroups);
		}
	
	if (m_NeverWarnIfRulesNotApplied.isSelected())
		this.setValue(BillingUserSettings.c_WarnIfRulesNotApplied, c_WarnIfRulesNotAppliedNever);
	else if (m_UcmWarnIfRulesNotApplied.isSelected())
		this.setValue(BillingUserSettings.c_WarnIfRulesNotApplied, c_WarnIfRulesNotAppliedUCM);
	else if (m_AlwaysWarnIfRulesNotApplied.isSelected())
		this.setValue(BillingUserSettings.c_WarnIfRulesNotApplied, c_WarnIfRulesNotAppliedAlways);
	
	if (m_NeverAllowCnsWithNonCnsActs.isSelected())
		this.setValue(BillingUserSettings.c_AllowPrivateActsForCnsInsurance, c_AllowCnsAndNonCnsCodesOnInvoiceNever);
	else if (m_AskAllowCnsWithNonCnsActs.isSelected())
		this.setValue(BillingUserSettings.c_AllowPrivateActsForCnsInsurance, c_AllowCnsAndNonCNSCodesOnInvoiceAsk);
	else if (m_AlwaysAllowCnsWithNonCnsActs.isSelected())
		this.setValue(BillingUserSettings.c_AllowPrivateActsForCnsInsurance, c_AllowCnsAndNonCNSCodesOnInvoiceAlways);
	
	if (m_AllowRulesForNotCnsInsuranceAlways.isSelected())
		this.setValue(BillingUserSettings.c_AllowRulesForNotCnsInsurance, c_AllowRulesForNotCnsInsuranceAlways);
	else if (m_AllowRulesForNotCnsInsuranceAsk.isSelected())
		this.setValue(BillingUserSettings.c_AllowRulesForNotCnsInsurance, c_AllowRulesForNotCnsInsuranceAsk);
	else if (m_AllowRulesForNotCnsInsuranceNever.isSelected())
		this.setValue(BillingUserSettings.c_AllowRulesForNotCnsInsurance, c_AllowRulesForNotCnsInsuranceNever);
	
	
	super.updateSettings();
	}

//---------------------------------------------------------------------------

public void reflectSettings() 
	{
	Integer option;
	
	
	super.reflectSettings();
	
	m_AutomaticallyAddActs.setSelected	((Boolean)this.getValue(BillingUserSettings.c_AutomaticallyAddActsSetting));
	m_TemplateButtons.setValue			(this.getValue (BillingUserSettings.c_TemplateButtonsSetting));
	m_LoadTemplateSuffixes.setSelected	((Boolean)this.getValue(BillingUserSettings.c_LoadTemplateSuffixesSettings));
	m_LoadTemplateQuantity.setSelected	((Boolean)this.getValue(BillingUserSettings.c_LoadTemplateQuantitySettings));
	m_EffectiveTransactions.setSelected ((Boolean)this.getValue(BillingUserSettings.c_EffectiveTransactionsSetting));
	m_AutoVerification.setSelected 		((Boolean)this.getValue(BillingUserSettings.c_AutoVerificationSetting));
	m_ServerAgendaGroups.setSelected	(c_ServerAgendaGroups.equals (this.getValue(BillingUserSettings.c_AgendaGroupsSetting)));
	m_ClientAgendaGroups.setSelected	(c_ClientAgendaGroups.equals (this.getValue(BillingUserSettings.c_AgendaGroupsSetting)));
	
	option	= (Integer) this.getValue(BillingUserSettings.c_WarnIfRulesNotApplied);
	if (option == null)
		option	= c_WarnIfRulesNotAppliedDefault;
	
	switch (option.intValue())
		{
		case c_WarnIfRulesNotAppliedAlways:
			m_AlwaysWarnIfRulesNotApplied.setSelected(true);
			break;

		case c_WarnIfRulesNotAppliedUCM:
			m_UcmWarnIfRulesNotApplied.setSelected(true);
			break;

		case c_WarnIfRulesNotAppliedNever:
		default:
			m_NeverWarnIfRulesNotApplied.setSelected(true);
			break;
		}
	
	option	= (Integer) this.getValue(BillingUserSettings.c_AllowPrivateActsForCnsInsurance);
	if (option == null)
		option = c_AllowCNSAndNonCNSCodesOnInvoiceDefault;
	
	switch (option.intValue())
		{
		case c_AllowCnsAndNonCNSCodesOnInvoiceAsk:
			m_AskAllowCnsWithNonCnsActs.setSelected(true);
			break;
		
		case c_AllowCnsAndNonCnsCodesOnInvoiceNever:
			m_NeverAllowCnsWithNonCnsActs.setSelected(true);
			break;
			
		case c_AllowCnsAndNonCNSCodesOnInvoiceAlways:
		default:
			m_AlwaysAllowCnsWithNonCnsActs.setSelected(true);
			break;
		}
	
	option	= (Integer) this.getValue(BillingUserSettings.c_AllowRulesForNotCnsInsurance);
	if (option == null)
		option = c_AllowRulesForNotCnsInsuranceDefault;
	
	switch (option.intValue())
		{
		case c_AllowRulesForNotCnsInsuranceAlways:
			m_AllowRulesForNotCnsInsuranceAlways.setSelected(true);
			break;
		
		case c_AllowRulesForNotCnsInsuranceNever:
			m_AllowRulesForNotCnsInsuranceNever.setSelected(true);
			break;
			
		case c_AllowRulesForNotCnsInsuranceAsk:
		default:
			m_AllowRulesForNotCnsInsuranceAsk.setSelected(true);
			break;
		}
	}

//---------------------------------------------------------------------------

public void setStationaryValues() 
	{
	setStationary(BillingUserSettings.c_AgendaGroupsSetting, 			c_AgendaGroupsStationary);
	setStationary(BillingUserSettings.c_AllowPrivateActsForCnsInsurance,c_AllowCNSAndNonCNSCodesOnInvoiceDefault);
	setStationary(BillingUserSettings.c_AllowRulesForNotCnsInsurance,	c_AllowRulesForNotCnsInsuranceDefault);
	setStationary(BillingUserSettings.c_AutomaticallyAddActsSetting,    c_AutomaticallyAddActsStationary);
	setStationary(BillingUserSettings.c_AutoVerificationSetting, 		c_AutoVerificationStationary);
	setStationary(BillingUserSettings.c_EffectiveTransactionsSetting, 	c_EffectiveTransactionsStationary);
	setStationary(BillingUserSettings.c_LoadTemplateQuantitySettings, 	c_LoadTemplateQuantityStationary);
	setStationary(BillingUserSettings.c_LoadTemplateSuffixesSettings, 	c_LoadTemplateSuffixesStationary);
	setStationary(BillingUserSettings.c_TemplateButtonsSetting, 		c_TemplateButtonsStationary);
	setStationary(BillingUserSettings.c_WarnIfRulesNotApplied,			c_WarnIfRulesNotAppliedDefault);
	
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	super.relocalize();
		
	this.setLabel(Translatrix.getTranslationString("BillingUserSettingsPlugin.Title"));
	
	this.setSubPanelTitle (m_InvoiceEditingPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.InvoiceEditing"));
	m_AutomaticallyAddActsLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.AutomaticallyAddActsLabel"));

	this.setSubPanelTitle (m_TemplateSettingsPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.Title"));
	m_TemplateButtonsLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.TemplateButtonsLabel"));
	m_TemplateButtonsUnit.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.TemplateButtonsUnit"));
	m_LoadTemplateSuffixesLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.LoadTemplateSuffixes"));
	m_LoadTemplateQuantityLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.LoadTemplateQuantity"));
	
	this.setSubPanelTitle (m_TransactionsPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.TransactionsTitle"));
	m_EffectiveTransactionsLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.EffectiveTransactionsLabel"));

	this.setSubPanelTitle (m_VerificationPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.VerificationTitle"));
	m_AutoVerificationLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.AutoVerificationLabel"));

	this.setSubPanelTitle (m_AgendaGroupsPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.AgendaGroupsTitle"));	
	m_ServerAgendaGroups.setText (Translatrix.getTranslationString("BillingUserSettingsPlugin.ServerAgendaGroupsButton"));
	m_ClientAgendaGroups.setText (Translatrix.getTranslationString("BillingUserSettingsPlugin.ClientAgendaGroupsButton"));
	
//	this.setSubPanelTitle(m_RulesWarningPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.Title"));
	m_RulesNotAppliedWarning.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.WarnSavingWithoutRulesLabel"));
	m_NeverWarnIfRulesNotApplied.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.WarnSavingWithoutRulesNever"));
	m_UcmWarnIfRulesNotApplied.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.WarnSavingWithoutRulesUcmAffiliated"));
	m_AlwaysWarnIfRulesNotApplied.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.WarnSavingWithoutRulesAlways"));
	
	m_ApplyRulesForNonCnsInsurance.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.AllowRulesForNotCnsInsuranceLabel"));
	m_AllowRulesForNotCnsInsuranceNever.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.AllowRulesForNotCnsInsuranceNever"));
	m_AllowRulesForNotCnsInsuranceAsk.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.AllowRulesForNotCnsInsuranceAsk"));
	m_AllowRulesForNotCnsInsuranceAlways.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.RuleWarning.AllowRulesForNotCnsInsuranceAlways"));
	
	this.setSubPanelTitle(m_MixedActsPanel, Translatrix.getTranslationString("BillingUserSettingsPlugin.MixedActs.Title"));
	m_AllowMixedActsLabel.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.MixedActs.AllowMixedRatesLabel"));
	m_NeverAllowCnsWithNonCnsActs.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.MixedActs.AllowMixedRatesNever"));
	m_AskAllowCnsWithNonCnsActs.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.MixedActs.AllowMixedRatesAsk"));
	m_AlwaysAllowCnsWithNonCnsActs.setText(Translatrix.getTranslationString("BillingUserSettingsPlugin.MixedActs.AllowMixedRatesAlways"));
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
}
