/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.event.invoice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

/**
 * The InvoiceEventDispatcher class basically encapsulates functionality
 * required to manage InvoiceChangeEvents Listeners. It offers methods to add and
 * remove InvoiceListeners as well as a method to call every registered
 * listener's invoiceChanged method.
 * @author nico.mack@tudor.lu
 */

public class InvoiceEventDispatcher 
{
	private Collection <InvoiceListener> m_InvoiceListeners;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new instance of InvoiceEventDispatcher class.
 */
//---------------------------------------------------------------------------

public InvoiceEventDispatcher ()
	{
	m_InvoiceListeners = new ArrayList <InvoiceListener> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Adds the specified InvoiceListener to the list of listeners to be
 * notified.
 * @param p_Listener specifies the InvoiceListener to be added
 */
//---------------------------------------------------------------------------

public void addInvoiceListener (InvoiceListener p_Listener)
	{
	if ((m_InvoiceListeners == null) || (p_Listener == null)) return;
	
	m_InvoiceListeners.add(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * Removes the specified InvoiceListener from the list of listeners to be
 * notified.
 * @param p_Listener specifies the InvoiceListener to be removed
 */
//---------------------------------------------------------------------------

public void removeInvoiceListener (InvoiceListener p_Listener)
	{
	if ((m_InvoiceListeners == null) || (p_Listener == null)) return;

	m_InvoiceListeners.remove(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * the notifyInvoiceListeners will notify all the registered Listener's
 * about the invoice change represented by the specified invoice event.
 * Notification is done by calling every listener's <code>invoiceChanged</code>
 * method.
 * @param p_Event specifies the invoice change event to be passed to every
 * listener's <code>invoiceChanged</code> method.
 */
//---------------------------------------------------------------------------

public void notifyInvoiceListeners (InvoiceChangeEvent p_Event)
	{
	Iterator <InvoiceListener>	l_ListenerIterator;
	InvoiceListener				l_Listener;
	
	if (m_InvoiceListeners == null) return;
	
	l_ListenerIterator = m_InvoiceListeners.iterator();
	while (l_ListenerIterator.hasNext())
		{
		l_Listener = l_ListenerIterator.next();
		l_Listener.invoiceChanged(p_Event);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}
