/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.invoice;

import java.util.Collection;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class InvoiceStateFilter implements TableFilter 
{
	private Collection <Integer> m_AcceptedStates;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public InvoiceStateFilter ()
	{
	m_AcceptedStates = null;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                		*
//***************************************************************************
//---------------------------------------------------------------------------
	
public boolean accept(Object p_Value) 
	{
	Integer	l_State;
	
	if (m_AcceptedStates == null) return true;
	
	if (m_AcceptedStates.size() == 0) return true;
	
	if (p_Value != null)
		{
		l_State = (Integer) p_Value;
		if (m_AcceptedStates.contains(l_State)) return true;
		}
	
	return false;
	}

//---------------------------------------------------------------------------

public void compile() 
	{
	}

//---------------------------------------------------------------------------

public boolean isFiltering() 
	{
	if (m_AcceptedStates == null) return false;
							 else return true;
	}

//---------------------------------------------------------------------------

public void setFilter (Object p_FilterValue) 
	{
	if (p_FilterValue instanceof Collection) 
		m_AcceptedStates = (Collection) p_FilterValue;	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
//---------------------------------------------------------------------------

}
