/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.invoice;

import java.awt.Color;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.hibernate.Hibernate;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.utils.InvoiceWorkflow;
import lu.tudor.santec.gecamed.core.gui.widgets.animatedicon.AnimatedIcon;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************
public class InvoiceStatusPanel extends JPanel 
	{
	private static final long serialVersionUID = 1L;
	
	private JLabel				m_PrintIcon;
	private JLabel				m_PayerIcon;
	private JLabel				m_MemoIcon;
	private JLabel				m_AccidentIcon;
	private JLabel				m_PaymentIcon;
	private JLabel				m_ReminderIcon;
	
	private JLabel				m_LineNumberLabel;
	private JLabel				m_AmountLabel;
	private JLabel				m_PaymentLabel;
	private JLabel				m_BalanceLabel;
	private JLabel				m_MajorationLabel;
	private JLabel				m_ModifierLabel;
	private JLabel				m_ModificationDateLabel;
	
	private JTextField			m_LineNumber;
	private JTextField			m_Amount;
	private JTextField			m_Payment;
	private JTextField			m_Balance;
	private JTextField			m_Majoration;
	
	private JTextField			m_Modifier;
	private JTextField  		m_ModificationDate;
	
	private	Invoice				m_Invoice;
	private NumberFormat		m_CurrencyFormat;
	private SimpleDateFormat	m_DateFormat;
	
	private ImageIcon			m_SelfPayer;
	private ImageIcon			m_ThirdPartyPayer;
	private ImageIcon			m_AccidentStatic;
	private AnimatedIcon		m_AccidentBlinking;
	private ImageIcon			m_MemoStatic;
	private AnimatedIcon		m_MemoBlinking;
	private ImageIcon			m_NoReminder;
	private ImageIcon			m_OneReminder;
	private ImageIcon			m_TwoReminders;
	private ImageIcon			m_ThreeReminders;
	
	private String[]			m_Filler;
	
	private static final Color c_Background = new Color (200,200,200);
//	private static final Color c_Background = new Color (184,207,229);
	
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private final static String c_Columns= "fill:max(10dlu;pref),3dlu," +
										 "fill:max(10dlu;pref),3dlu," +
										 "fill:max(10dlu;pref),3dlu," +
										 "fill:max(10dlu;pref),3dlu," +
										 "fill:max(10dlu;pref),3dlu," +
										 "fill:max(10dlu;pref)," 	  +
										 "60dlu," +
										 "fill:max(20dlu;pref),3dlu," +
										 "fill:max(50dlu;pref),3dlu," +
										 "fill:max(50dlu;pref),3dlu," +
										 "fill:max(50dlu;pref),3dlu," +
										 "fill:max(50dlu;pref)," +
										 "40dlu," +
										 "fill:max(50dlu;pref),3dlu," +
										 "fill:max(80dlu;pref)";
	
	private final static String c_Rows=    "fill:pref,3dlu,fill:pref";
		
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
	
public InvoiceStatusPanel ()
	{
	CellConstraints		l_Constraints;
    FormLayout			l_Layout;
       
    m_Invoice = null;
    
    l_Constraints  = new CellConstraints();
     
    l_Layout = new FormLayout(c_Columns, c_Rows);
    this.setLayout(l_Layout);
    
    m_SelfPayer 		= BillingModule.getIconResource("patient.png");
    m_ThirdPartyPayer 	= BillingModule.getIconResource ("thirdparty.png");
    
    m_AccidentStatic   	= BillingModule.getIconResource("accident.png");
    m_AccidentBlinking 	= new AnimatedIcon (BillingModule.getIconResource ("accident_blink.gif"));
    
    m_MemoStatic 	  	= BillingModule.getIconResource("memo.png");
    m_MemoBlinking 	  	= new AnimatedIcon (BillingModule.getIconResource ("memo_flashing_gray.gif"));
    
    m_NoReminder	  	= BillingModule.getIconResource ("no_reminder.png");
    m_OneReminder	  	= BillingModule.getIconResource ("one_reminder.png");
    m_TwoReminders	  	= BillingModule.getIconResource ("two_reminders.png");
    m_ThreeReminders  	= BillingModule.getIconResource ("three_reminders.png");
    
    m_PrintIcon   = new JLabel (BillingModule.getIconResource("print.png"));
	m_PrintIcon.setEnabled (false);
	m_PayerIcon   = new JLabel (m_SelfPayer);
	m_PayerIcon.setEnabled (false);
	m_MemoIcon   = new JLabel (m_MemoStatic);
	m_MemoIcon.setEnabled (false);
	m_AccidentIcon  = new JLabel (m_AccidentStatic);
	m_AccidentIcon.setEnabled (false);
	m_PaymentIcon = new JLabel (BillingModule.getIconResource("billing.png"));
	m_PaymentIcon.setEnabled (false);
	m_ReminderIcon = new JLabel (m_NoReminder);
	m_ReminderIcon.setEnabled (false);
	
	m_LineNumberLabel 		= new JLabel ();
	m_AmountLabel			= new JLabel ();
	m_PaymentLabel			= new JLabel ();
	m_BalanceLabel			= new JLabel ();
	m_MajorationLabel		= new JLabel ();
	m_ModifierLabel			= new JLabel ();
	m_ModificationDateLabel = new JLabel ();
	
	m_LineNumber	= new JTextField ();
	m_LineNumber.setHorizontalAlignment (JTextField.RIGHT);
	m_LineNumber.setEditable(false);
	
	m_Amount		= new JTextField ();
	m_Amount.setHorizontalAlignment (JTextField.RIGHT);
	m_Amount.setEditable(false);

	m_Payment	= new JTextField ();
	m_Payment.setHorizontalAlignment (JTextField.RIGHT);
	m_Payment.setEditable(false);

	m_Balance	= new JTextField ();
	m_Balance.setHorizontalAlignment (JTextField.RIGHT);
	m_Balance.setEditable(false);
	
	m_Majoration = new JTextField ();
	m_Majoration.setHorizontalAlignment (JTextField.RIGHT);
	m_Majoration.setEditable(false);
	
	m_Modifier	= new JTextField ();
	m_Modifier.setHorizontalAlignment (JTextField.CENTER);
	m_Modifier.setEditable(false);

	m_ModificationDate	= new JTextField ();
	m_ModificationDate.setHorizontalAlignment (JTextField.CENTER);
	m_ModificationDate.setEditable(false);

	m_Filler = new String [1];
	
	this.relocalize ();
    
	this.add (m_LineNumberLabel, 		l_Constraints.xywh(13, 1, 1, 1));	
	this.add (m_AmountLabel, 	 		l_Constraints.xywh(15, 1, 1, 1));	
	this.add (m_PaymentLabel, 	 		l_Constraints.xywh(17, 1, 1, 1));	
	this.add (m_BalanceLabel, 	 		l_Constraints.xywh(19, 1, 1, 1));	
	this.add (m_MajorationLabel, 		l_Constraints.xywh(21, 1, 1, 1));	
	this.add (m_ModifierLabel,   		l_Constraints.xywh(23, 1, 1, 1));	
	this.add (m_ModificationDateLabel,  l_Constraints.xywh(25, 1, 1, 1));	
    
	this.add (m_PrintIcon, 				l_Constraints.xywh(1, 1, 1, 3));	
	this.add (m_PayerIcon, 				l_Constraints.xywh(3, 1, 1, 3));	
	this.add (m_AccidentIcon, 			l_Constraints.xywh(5, 1, 1, 3));	
	this.add (m_MemoIcon, 				l_Constraints.xywh(7, 1, 1, 3));	
	this.add (m_PaymentIcon, 			l_Constraints.xywh(9, 1, 1, 3));	
	this.add (m_ReminderIcon, 			l_Constraints.xywh(11, 1, 1, 3));	

	this.add (m_LineNumber, 			l_Constraints.xywh(13, 3, 1, 1));	
	this.add (m_Amount, 				l_Constraints.xywh(15, 3, 1, 1));	
	this.add (m_Payment, 				l_Constraints.xywh(17, 3, 1, 1));	
	this.add (m_Balance, 				l_Constraints.xywh(19, 3, 1, 1));	
	this.add (m_Majoration, 			l_Constraints.xywh(21, 3, 1, 1));	
	this.add (m_Modifier, 				l_Constraints.xywh(23, 3, 1, 1));	
	this.add (m_ModificationDate, 		l_Constraints.xywh(25, 3, 1, 1));	
	
	this.setBackground(c_Background);
	}
	
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
	Locale  l_Locale;
	  	
	l_Locale = Translatrix.getLocale ();
	    	  	
	if (l_Locale != null)
		{
		m_DateFormat = new SimpleDateFormat ("d MMMM yyyy HH:mm",l_Locale);
//		m_CurrencyFormat = NumberFormat.getCurrencyInstance (l_Locale);
		m_CurrencyFormat = NumberFormat.getCurrencyInstance (Locale.FRANCE);
		}
	else 
		{
		m_DateFormat = new SimpleDateFormat ("d MMMM yyyy HH:mm");   
		m_CurrencyFormat = NumberFormat.getCurrencyInstance ();
		}

	m_CurrencyFormat.setCurrency(Currency.getInstance ("EUR"));
	
	if (m_LineNumberLabel!=null) 
		m_LineNumberLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.LineNumberLabel"));
	
	if (m_AmountLabel!=null) 		 
		m_AmountLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.AmountLabel"));
	
	if (m_PaymentLabel!=null)
		m_PaymentLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.PaymentLabel"));
	
	if (m_BalanceLabel!=null)
		m_BalanceLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.BalanceLabel"));	
	
	if (m_MajorationLabel!=null)
		m_MajorationLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.MajorationLabel"));	
	
	if (m_ModifierLabel!=null)
		m_ModifierLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.ModifierLabel"));	
	
	if (m_ModificationDateLabel!=null)
		m_ModificationDateLabel.setText (Translatrix.getTranslationString("InvoiceStatusPanel.ModificationDateLabel"));	
	}

//---------------------------------------------------------------------------

private void reflectInvoice ()
	{
	double	l_Majoration;
	int		l_Percent;
	String	l_Modifier;
	
	
	if (m_Invoice == null) return;
	
	if (m_Invoice.isAccident())
		{
		m_AccidentIcon.setIcon (m_AccidentBlinking);
		m_AccidentIcon.setEnabled(true);
		m_AccidentIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.InvoiceAccidentTip"));
		}
	else 
		{	
		m_AccidentIcon.setIcon (m_AccidentStatic);
		m_AccidentIcon.setEnabled(false);
		m_AccidentIcon.setToolTipText ("");
		}
		
	if ((m_Invoice.getNumberOfMemos() != null) && (m_Invoice.getNumberOfMemos() > 0))
		{
		m_MemoIcon.setIcon (m_MemoBlinking);
		m_MemoIcon.setEnabled (true);
		m_MemoIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.InvoiceHasMemosTip"));
		}
	else
		{
		m_MemoIcon.setIcon (m_MemoStatic);
		m_MemoIcon.setEnabled (false);
		m_MemoIcon.setToolTipText("");
		}
	
	if (!m_Invoice.alreadyPrinted())
		{
		m_PrintIcon.setEnabled(false);
		m_PrintIcon.setToolTipText ("");
		m_ReminderIcon.setEnabled(false);
		}
	else 
		{
		m_Filler [0] = m_DateFormat.format(m_Invoice.getPrintDate());
		
		m_PrintIcon.setEnabled(true);
		m_PrintIcon.setToolTipText (Translatrix.getTranslationString("InvoiceStatusPanel.InvoicePrintedTip",m_Filler));
		m_ReminderIcon.setEnabled(true);
		}
		
	if (m_Invoice.getState().intValue() != InvoiceWorkflow.c_PaidState)
		{ 
		m_PaymentIcon.setEnabled(false);
		m_PaymentIcon.setToolTipText("");
		}
	else 
		{
		m_PaymentIcon.setEnabled(true);
		m_PaymentIcon.setToolTipText (Translatrix.getTranslationString("InvoiceStatusPanel.InvoicePaidTip"));
		if (m_Invoice.isSettled())
			{
			m_ReminderIcon.setEnabled(false);
			m_ReminderIcon.setToolTipText("");
			}
		}
		
	if (m_Invoice.isPaidByThirdParty())
		{
		m_PayerIcon.setIcon (m_ThirdPartyPayer);
		m_PayerIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.InvoicePaidByThirdPartyTip"));	
		m_PayerIcon.setEnabled(true);
		}
	else
		{
		m_PayerIcon.setIcon (m_SelfPayer);
		m_PayerIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.InvoicePaidByPatientTip"));	
		m_PayerIcon.setEnabled(true);
		}
		
	switch (m_Invoice.getNumberOfReminders())
		{
		case 0: m_ReminderIcon.setIcon(m_NoReminder);
				m_ReminderIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.NoReminderTip"));
				break;
		case 1: m_ReminderIcon.setIcon(m_OneReminder);
				m_ReminderIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.OneReminderTip"));
				break;
		case 2: m_ReminderIcon.setIcon(m_TwoReminders);
				m_ReminderIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.TwoRemindersTip"));
				break;
		case 3: m_ReminderIcon.setIcon(m_ThreeReminders);
				m_ReminderIcon.setToolTipText(Translatrix.getTranslationString("InvoiceStatusPanel.ThreeRemindersTip"));
				break;
		}
	
	m_Invoice.monetize();
	
	m_LineNumber.setText (m_Invoice.getNumberOfActs().toString());
	m_Amount.setText(m_CurrencyFormat.format(m_Invoice.getAmount().doubleValue()));
	m_Payment.setText(m_CurrencyFormat.format(m_Invoice.getPayment().doubleValue()));
	m_Balance.setText(m_CurrencyFormat.format(m_Invoice.getBalance().doubleValue()));
	
	if (m_Invoice.getMajoration() != null)
		{
		l_Majoration = m_Invoice.getMajoration().doubleValue() * 100;
		l_Percent = (int)(Math.round (l_Majoration) - 100);
		m_Majoration.setText(l_Percent + "%");
		}
	else m_Majoration.setText("");
	
	if (m_Invoice.getModifier() != null)
		{
		try {			
			if (Hibernate.isInitialized(m_Invoice.getModifier())) {
				l_Modifier = m_Invoice.getModifier().getLogin();
				m_Modifier.setText(l_Modifier);				
			} else {
				m_Modifier.setText("");
			}
		} catch (Exception e) {
			m_Modifier.setText("");
		}
		}
	else m_Modifier.setText("");
	
	if (m_Invoice.getModificationDate() != null)
		{
		m_ModificationDate.setText(m_DateFormat.format(m_Invoice.getModificationDate()));
		}
	else m_ModificationDate.setText ("");
	
	this.revalidate();
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public void reset ()
	{
	m_PrintIcon.setEnabled (false);
	m_PayerIcon.setEnabled (false);
	m_MemoIcon.setEnabled (false);
	m_AccidentIcon.setEnabled (false);
	m_PaymentIcon.setEnabled (false);
	m_ReminderIcon.setEnabled (false);
	
	m_LineNumber.setText ("");
	m_Amount.setText("");
	m_Payment.setText("");
	m_Balance.setText("");
	m_Majoration.setText("");
	}

//---------------------------------------------------------------------------


public void setInvoice (Invoice p_Invoice)
	{
	if (p_Invoice != null) 
		{
		m_Invoice = p_Invoice;
		this.reflectInvoice ();
		}
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
	
	}
