/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.ledger;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Ledger;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Payment;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class LedgerListModel extends AbstractTableModel
    {
 	private static final long serialVersionUID = 1L;
 	
    private Vector      	<Ledger> m_Ledgers;        
    
    public static final Date c_Epoch = new Date (0);
   
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    public static final String c_CashierHeader			= "LedgerListModel.CashierHeader";
    public static final String c_SettlementHeader		= "LedgerListModel.SettlementHeader";
    public static final String c_SettlementDateHeader	= "LedgerListModel.SettlementDateHeader";
    public static final String c_TransactionDateHeader	= "LedgerListModel.TransactionDateHeader";
    public static final String c_DebitHeader 			= "LedgerListModel.DebitHeader";
    public static final String c_CreditHeader 			= "LedgerListModel.CreditHeader";
          
    public static final int 	c_CashierColumn 			= 0;
    public static final int 	c_SettlementColumn			= 1;
    public static final int 	c_SettlementDateColumn		= 2;
    public static final int 	c_TransactionDateColumn		= 3;
    public static final int 	c_DebitColumn		 		= 4;
    public static final int 	c_CreditColumn		 		= 5;
    
    public static final  String c_TableHeaders [] = { 	c_CashierHeader,
    													c_SettlementHeader,
    													c_SettlementDateHeader,
    													c_TransactionDateHeader,
    													c_DebitHeader,
	    												c_CreditHeader };
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public LedgerListModel ()
    {
    m_Ledgers	    	= new Vector <Ledger> ();
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************
//---------------------------------------------------------------------------

private String getSettlement (Settlement p_Settlement)
	{
	Payment	l_Payment;
	Account	l_Account;
	String	l_Settlement	= "";
	
	if (p_Settlement == null) return "";
	
	if (p_Settlement.getPayment() != null)
		{
		l_Payment = p_Settlement.getPayment();
		l_Settlement = l_Payment.getMethod();
		}
	else
		{
		l_Account = p_Settlement.getTransferAccount();
		l_Settlement = l_Account.getBankname();
		}
	
	return l_Settlement;
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Ledgers.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    Ledger  l_Ledger;
    
    l_Ledger = new Ledger ();
    
    if ((p_Row >= 0) && (p_Row < m_Ledgers.size()))
        {
    	l_Ledger = m_Ledgers.elementAt (p_Row);
    	if (l_Ledger == null) l_Ledger = new Ledger ();
        }
	 
    switch (p_Column)
        {
        case c_CashierColumn		: return (l_Ledger.getCashier() != null)?l_Ledger.getCashier().getLogin():"";
        case c_SettlementColumn		: return (l_Ledger.getSettlement() != null)?this.getSettlement(l_Ledger.getSettlement()) : "";
        case c_SettlementDateColumn : return (l_Ledger.getSettlementDate() != null) ? l_Ledger.getSettlementDate() : c_Epoch;
        case c_TransactionDateColumn: return (l_Ledger.getTransactionDate() != null) ? l_Ledger.getTransactionDate() : c_Epoch;
        case c_DebitColumn			: return (l_Ledger.getDebit() != null) ? l_Ledger.getDebit() : 0d;
        case c_CreditColumn			: return (l_Ledger.getCredit() != null) ? l_Ledger.getCredit() : 0d;
     
        default: return "";
        }
    }
        
//---------------------------------------------------------------------------

public Class getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------
/**
 * queries the ability to be edited of the cell specified by p_Row and p_Column
 * @param p_Row specifies the row to be queried
 * @param p_Column specifies the column to be queried
 * @return <CODE>true</CODE> if the specified cell is editable, <CODE>false</CODE> otherwise
 */
//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
    return false;
    }
 
//---------------------------------------------------------------------------

public Ledger getLedgerAt (int p_Row)
    {
    Ledger  l_Ledger;
     
    if ((p_Row >= 0) && (p_Row < m_Ledgers.size()))
        {
    	l_Ledger = m_Ledgers.elementAt (p_Row);
        return l_Ledger;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void removeAllLedgers ()
	{
	int	l_LastRow;
	
	l_LastRow = m_Ledgers.size() -1;
	
	m_Ledgers.removeAllElements ();
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}

//---------------------------------------------------------------------------

public void setLedgers (Collection <Ledger> p_Ledgers)
    {
    if (p_Ledgers == null) return;
        
    this.removeAllLedgers ();
    m_Ledgers.addAll (p_Ledgers);
          
    fireTableRowsInserted (0,m_Ledgers.size());
    }

//---------------------------------------------------------------------------

public Collection <Ledger> getLedgers ()
    {
	LinkedHashSet <Ledger> l_Ledgers;
	
	l_Ledgers = new LinkedHashSet <Ledger> (m_Ledgers);
	
	return l_Ledgers;
	}    
        
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
