/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.medpres;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class MedTransPanel extends JPanel implements Relocalizable
	{
	private static final long serialVersionUID = 1L;
	
	private final String MEDTRANS_NULL = " - "; 
	
    private HashMap<String, MedPres> medHash = new HashMap<String, MedPres>();
	
	private static MedTransPanel m_Instance;
	
	private TitledBorder			m_Border;
	
	private JLabel					m_Label;

	private JComboBox<Object>  				m_Phys;
	
	private Invoice 				m_CurrentInvoice;
	
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private final static String c_Columns= 	"fill:max(60dlu;pref),3dlu";
	private final static String c_Rows=    "fill:pref,3dlu,fill:pref";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public MedTransPanel ()
    {
	m_Instance = this;
	
	CellConstraints		l_Constraints;
    FormLayout			l_Layout;
    Color				l_DefaultColor; 
    
    l_Constraints  = new CellConstraints();
    
    l_Layout = new FormLayout(c_Columns, c_Rows);
    this.setLayout(l_Layout);
    this.setOpaque(false);
    
	m_Border = new TitledBorder (Translatrix.getTranslationString("MedTransPanel.Title"));
    this.setBorder (m_Border);
     
    m_Label	= new JLabel ();
    m_Label.setForeground (GECAMedColors.c_LabelColor);
    m_Label.setText (Translatrix.getTranslationString("MedTransPanel.Label"));
    
    l_DefaultColor = (Color) UIManager.getDefaults().get("TextField.inactiveBackground");   
    UIManager.getDefaults().put("TextField.inactiveBackground", Color.WHITE );
    
    m_Phys 		= new JComboBox<Object> ();
    UIManager.getDefaults().put("TextField.inactiveBackground", l_DefaultColor );
    
    this.relocalize ();
    
    this.add (m_Label, l_Constraints.xywh(1, 1, 1, 1));
    this.add (m_Phys, 	   l_Constraints.xywh(1, 3, 1, 1)); 
    }

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void setEnabled (boolean p_EnableIt) {
	this.m_Phys.setEnabled(p_EnableIt);
	
	
}

public void relocalize() 
	{	  	
	if (m_Border != null) 
		m_Border.setTitle (Translatrix.getTranslationString("MedTransPanel.Title"));

	if (m_Label != null)
		m_Label.setText (Translatrix.getTranslationString("MedTransPanel.Label"));
	}

//---------------------------------------------------------------------------

public void populateMedTrans()
	{
		Collection<Contact> medPres = BillingModule.getMedPres();
		m_Phys.removeAllItems();
		medHash.clear();
		m_Phys.addItem(MEDTRANS_NULL);
		
		for (Contact contact : medPres) {
			MedPres mp = new MedPres(contact);
			medHash.put(mp.getUcm(), mp);
			m_Phys.addItem(mp);
		}
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public void setInvoice (Invoice p_Invoice)
	{
	if (p_Invoice == null) return;
	
	m_CurrentInvoice = p_Invoice;
	
	this.setMedTrans(p_Invoice.getMedTrans());
	}

//---------------------------------------------------------------------------

public boolean updateInvoice (Invoice p_Invoice)
	{
	boolean l_InvoiceModified = false;
	
	if (p_Invoice == null) return false;
	
	if ( !(this.getMedTrans() == null && p_Invoice.getMedTrans() == null) &&
			!this.getMedTrans().equals (p_Invoice.getMedTrans()))
		{
		p_Invoice.setMedTrans(this.getMedTrans());
		l_InvoiceModified = true;
		}

	return l_InvoiceModified;
	}

//---------------------------------------------------------------------------

public void reset ()
	{
	this.setMedTrans(MEDTRANS_NULL);
	}

//---------------------------------------------------------------------------

public String getMedTrans ()
	{
		Object med = m_Phys.getSelectedItem();
		if (med instanceof MedPres) {
			return ((MedPres)med).getUcm();
		} else  {
			return null;
		}
	}

//---------------------------------------------------------------------------

public void setMedTrans (String p_UCM)
	{
	if (p_UCM == null) {
		m_Phys.setSelectedItem(MEDTRANS_NULL);
	}
	MedPres med = medHash.get(p_UCM);
	if (med == null) {
		m_Phys.setSelectedItem(MEDTRANS_NULL);
	} else {
		m_Phys.setSelectedItem(med);
	}

	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
