/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * MemoListModel.java
 *
 * Created on June 26, 2006
 */

package lu.tudor.santec.gecamed.billing.gui.memo;

/**
 *
 * @author  santec
 */

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Memo;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class MemoListModel extends AbstractTableModel
    {
 	private static final long serialVersionUID = 1L;
 	
    private Vector      	<Memo> 	m_Memos;        
    private GecamedUser			m_CurrentAuthor; 
    private boolean				m_HasEditAllMemosPermission; 
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    public static final String c_LockedHeader		 	= "MemoListModel.LockedHeader";
    public static final String c_CreationTimeHeader		= "MemoListModel.CreationTimeHeader";
    public static final String c_AuthorHeader 			= "MemoListModel.AuthorHeader";
    public static final String c_NoteHeader		 		= "MemoListModel.NoteHeader";
          
    public static final int		c_LockedColumn			= 0;
    public static final int		c_CreationTimeColumn	= 1;
    public static final int		c_AuthorColumn			= 2;
    public static final int		c_NoteColumn			= 3;
   
    static final public String c_TableHeaders [] = { 	c_LockedHeader,
    													c_CreationTimeHeader,
    													c_AuthorHeader,
    													c_NoteHeader   };
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public MemoListModel ()
    {	
    m_Memos= new Vector <Memo> ();
    m_HasEditAllMemosPermission = false;
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//---------------------------------------------------------------------------

public void setCurrentAuthor (GecamedUser p_Author)
	{
	m_CurrentAuthor 			  	= p_Author;
	m_HasEditAllMemosPermission 	= GECAMedModule.userHasPermission (p_Author,"BillingModule","editAllMemos");	
	}

//---------------------------------------------------------------------------

public boolean isLocked (Memo p_Memo)
	{
    if (p_Memo.getAuthor() != null)
    		{
    		if (p_Memo.getAuthor().equals(m_CurrentAuthor) || m_HasEditAllMemosPermission)
    			 return false;
    		else return true;
    		}
 	return true;
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Memos.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    Memo  l_Memo = null;
    
    if ((p_Row >= 0) && (p_Row < m_Memos.size()))
        {
    	l_Memo = m_Memos.elementAt (p_Row);
    	if (l_Memo == null) l_Memo = new Memo ();
        }
    else  l_Memo = new Memo ();
    
    switch (p_Column)
        {
        case  0: return isLocked (l_Memo);
        case  1: return (l_Memo.getCreationDate()  != null) ? (Date) l_Memo.getCreationDate() : new Date ();      		 
        case  2: return (l_Memo.getAuthor() 		!= null) ? l_Memo.getAuthor() : new GecamedUser();       
        case  3: return (l_Memo.getNote() 			!= null) ? l_Memo.getNote() : "";
                
        default: return "";
        }
    }
        
//---------------------------------------------------------------------------

public void setValueAt (Object p_Value, int p_Row, int p_Column)
	{
	Memo		l_Memo;
	
	if ((p_Value == null) || (p_Row >= m_Memos.size())) return;
	
	l_Memo = (Memo) m_Memos.elementAt (p_Row);
	if (l_Memo == null) return;
	
	switch (p_Column)
    		{
    		case 3: l_Memo.setNote((String) p_Value);
    				fireTableCellUpdated (p_Row,p_Column);
    				break;
    		}
	}

//---------------------------------------------------------------------------

public Class getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------
/**
 * queries the ability to be edited of the cell specified by p_Row and p_Column
 * @param p_Row specifies the row to be queried
 * @param p_Column specifies the column to be queried
 * @return <CODE>true</CODE> if the specified cell is editable, <CODE>false</CODE> otherwise
 */
//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
	Memo  l_Memo = null;
	
	switch (p_Column)
    		{
    		case  0: return false;
    		case  1: return false;
    		case  2: return false;
    		case  3: if ((p_Row >= 0) && (p_Row < m_Memos.size()))
    					{
    					l_Memo = m_Memos.elementAt (p_Row);
    					return !isLocked(l_Memo);
    					}
             
    		default: return false;
    		}	
    }
 
//---------------------------------------------------------------------------

public Memo	getMemoAt (int p_Row)
    {
    Memo  l_Memo;
     
    if ((p_Row >= 0) && (p_Row < m_Memos.size()))
        {
    	l_Memo = m_Memos.elementAt (p_Row);
        return l_Memo;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void addMemo (Memo p_Memo)
    {
    int l_Row;
	
	if (p_Memo != null)    
        {    
    	m_Memos.addElement (p_Memo);
	
    	l_Row = m_Memos.size() - 1;
    	fireTableRowsInserted (l_Row,l_Row);
        }
    }
	
//---------------------------------------------------------------------------

public void removeAllMemos ()
	{
	int l_LastRow;
	
	l_LastRow = m_Memos.size() -1;
	m_Memos.removeAllElements ();
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}

//---------------------------------------------------------------------------

public void removeMemoAt (int p_Row)
    {
    if ((p_Row >= 0) && (p_Row < m_Memos.size()))
        {
     	m_Memos.removeElementAt(p_Row);    
     	fireTableRowsDeleted (p_Row,p_Row);
        }
    }

//---------------------------------------------------------------------------

public void setMemos (Set <Memo> p_Memos)
    {
    if (p_Memos == null) return;
        
    removeAllMemos ();
    m_Memos.addAll(p_Memos);
     
    fireTableRowsInserted (0,p_Memos.size());
    }

//---------------------------------------------------------------------------

public Set <Memo> getMemos ()
    {
	HashSet <Memo> l_Memos;
	
	l_Memos = new HashSet <Memo> (m_Memos);
	
	return l_Memos;
    }    
        
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
