/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.memo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Memo;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class MemoRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              	m_Label;
	private SimpleDateFormat		m_CreationTimeFormat;
	private ImageIcon				m_LockedIcon;   
	
	private String              	m_LockedColumn;
	private String              	m_CreationTimeColumn;
	private String              	m_AuthorColumn;
	private String              	m_NoteColumn;

	private Memo					m_Memo;
	private MemoListModel			m_TableModel;
	private TableSorter				m_MemoSorter;
	private int						m_LastRow;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
    
	private static final Color m_OddColor  = new Color (237,243,254);
    private static final Color m_EvenColor = new Color (255,255,255);
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public MemoRenderer ()
      {
      super();

      m_Label = new JLabel ();
      m_Label.setOpaque(true);
      
      m_Label.setHorizontalAlignment (SwingConstants.CENTER);
	  m_Label.setVerticalAlignment(SwingConstants.TOP);
      
      m_LockedIcon   = new ImageIcon (BillingModule.getIconResource ("locked.png").getImage().getScaledInstance(16, 16, Image.SCALE_SMOOTH));
       
      this.relocalize();       
      }

//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------
/** returns the ImageIcon Resource specified by p_IconName.
* @param p_IconName specifies the name of the icon to get from application resources.
* @return the ImageIcon specified by p_IconName, or <CODE>null</CODE> if specified does not exist.
*/
//---------------------------------------------------------------------------

protected ImageIcon getIconResource (String p_IconName) 
	{
	String  l_IconPath;   
	URL     l_Location;   
	        
	l_IconPath = new String ("resources/" + p_IconName);
	l_Location = this.getClass().getResource (l_IconPath);

	 
	if (l_Location != null) return new ImageIcon (l_Location);
	else return new ImageIcon (l_IconPath);
	}

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
	if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
     
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
   	Locale  l_Locale;
  	
	l_Locale = Translatrix.getLocale ();
	  	
	if (l_Locale != null)
		{
		m_CreationTimeFormat = new SimpleDateFormat ("d MMMM yyyy HH:mm",l_Locale);
		}
	else 
		{
		m_CreationTimeFormat = new SimpleDateFormat ("d MMMM yyyy HH:mm");   
		}
	
	m_LockedColumn   	 = Translatrix.getTranslationString(MemoListModel.c_LockedHeader);
	m_CreationTimeColumn = Translatrix.getTranslationString(MemoListModel.c_CreationTimeHeader);
	m_AuthorColumn		 = Translatrix.getTranslationString(MemoListModel.c_AuthorHeader);
	m_NoteColumn		 = Translatrix.getTranslationString(MemoListModel.c_NoteHeader);
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component		l_Component;
	Color			l_Background;
	int				l_Row;
	int				l_Column;
	
	if ((p_Table != null) && (m_TableModel == null)) 
		{
		m_MemoSorter 	= (TableSorter) p_Table.getModel();
		m_TableModel 	= (MemoListModel) m_MemoSorter.getTableModel();
		m_LastRow	  	= -1;
		}

	if (m_TableModel != null) //&& (p_Row != m_LastRow))
		{
		l_Row = m_MemoSorter.modelIndex(p_Row);
		m_Memo = m_TableModel.getMemoAt(l_Row);
		m_LastRow = p_Row;
		}

	if (m_Memo != null)
		{
		l_Column = this.modelColumn (p_Table, p_Column);
	
		switch (l_Column)
			{
			case MemoListModel.c_LockedColumn:

				if ((Boolean)p_Value) m_Label.setIcon(m_LockedIcon);
								 else m_Label.setIcon(null); 
				
				m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				m_Label.setText("");
				m_Label.setToolTipText("");
				break;

			case MemoListModel.c_CreationTimeColumn:

				m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				m_Label.setIcon(null);
				m_Label.setText(m_CreationTimeFormat.format((Date)p_Value));
				m_Label.setToolTipText("");
				break;
				
			case MemoListModel.c_AuthorColumn:

				m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				m_Label.setIcon(null);
				m_Label.setText(m_Memo.getAuthor().getLogin());
				m_Label.setToolTipText("");
				break;		

			case MemoListModel.c_NoteColumn:

				m_Label.setHorizontalAlignment (SwingConstants.LEFT);
				m_Label.setIcon(null);
				m_Label.setText((String)p_Value);
				m_Label.setToolTipText("");
				break;		
			
			default : m_Label.setText (p_Value.toString());
			}
		}
	else 
		{
		m_Label.setText (p_Value.toString());
		}
		
	l_Component = m_Label;
	
	if (p_Table != null) l_Component.setEnabled (p_Table.isEnabled());

	l_Background = ( p_Row % 2 == 0) ? m_OddColor : m_EvenColor;

	if ((p_Table != null) && (p_IsSelected)) 
		{
		l_Component.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		l_Component.setBackground(l_Background);
		}

	return l_Component;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
