/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.print;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class BatchPrintDialog extends JDialog implements ActionListener,
														 ChangeListener,
														 Relocalizable
{
	private JPanel						m_InvoicesPanel;
	private TitledBorder				m_InvoicesBorder;
	
	private JLabel						m_NumberOfInvoicesLabel;
	private JLabel						m_NumberOfCopiesLabel;
	
	private JTextField					m_NumberOfInvoices;
	private JSpinner					m_NumberOfCopies;
	
	private BatchPrintPanel				m_PrintPanel;
	private TitledBorder				m_PrintBorder;
	
	private JButton						m_CancelButton;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;

	private final static Dimension c_PreferredSize = new Dimension (200,400);

	//=======================================================================
	//= Layout Strings
	//=======================================================================

	private final static String c_Columns				= 	"3dlu,fill:max(75dlu;pref):grow," +
														  	"3dlu,fill:max(75dlu;pref):grow,3dlu";

	private final static String c_Rows					= 	"3dlu,fill:pref," +
	  														"3dlu,fill:pref," +
	  														"3dlu,fill:pref,3dlu";

	private final static String c_InvoicesColumns 		= 	"3dlu,fill:max(75dlu;pref)," +
	  													  	"3dlu,fill:max(75dlu;pref),3dlu";

	private final static String c_InvoicesRows 			= 	"3dlu,fill:pref," +
															"3dlu,fill:pref,3dlu";
	
	//=======================================================================
	//= I18N Strings
	//=======================================================================

	private final static String c_Title						= "BatchPrintDialog.Title";
	private final static String c_InvoicesBorder			= "BatchPrintDialog.InvoicesBorder";
	private final static String c_NumberOfInvoicesLabel		= "BatchPrintDialog.NumberOfInvoicesLabel";
	private final static String c_NumberOfCopiesLabel		= "BatchPrintDialog.NumberOfCopiesLabel";
	
	private final static String c_PrintBorder				= "BatchPrintDialog.PrintBorder";

//	private static Logger m_Logger = Logger.getLogger (BatchPrintDialog.class.getName());

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor                                                             *
//***************************************************************************
//---------------------------------------------------------------------------
	
public BatchPrintDialog ()
	{
	super (MainFrame.getInstance(),Translatrix.getTranslationString(c_Title),true);
	
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;	
	
	this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
	this.addWindowListener(new WindowAdapter()  {
		@Override
		public void windowClosing(WindowEvent e) {
			m_PrintPanel.abortBatchPrinting();
			super.windowClosing(e);
		}
		
	});
	
	l_Constraints  		= new CellConstraints();
	
	m_InvoicesBorder 	= new TitledBorder ("");
	
	m_NumberOfInvoicesLabel = new JLabel ();
	m_NumberOfInvoicesLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_NumberOfCopiesLabel = new JLabel ();
	m_NumberOfCopiesLabel.setForeground(GECAMedColors.c_LabelColor);

	m_CancelButton = new JButton ();
	m_CancelButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
	m_CancelButton.addActionListener(this);

	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
	this.relocalize();
		
	//=======================================================================
	//= Assemble Invoices Panel
	//=======================================================================

	l_Layout = new FormLayout(c_InvoicesColumns, c_InvoicesRows);
	m_InvoicesBorder = new TitledBorder (Translatrix.getTranslationString(c_InvoicesBorder));
	
	m_InvoicesPanel = new JPanel ();
	m_InvoicesPanel.setOpaque(false);
	m_InvoicesPanel.setLayout(l_Layout);
	m_InvoicesPanel.setBorder(m_InvoicesBorder);
	
	m_NumberOfInvoices = new JTextField ();
	m_NumberOfInvoices.setHorizontalAlignment(JTextField.RIGHT);
	m_NumberOfInvoices.setText ("0");
	m_NumberOfInvoices.setEditable(false);

	m_NumberOfCopies   = new JSpinner (new SpinnerNumberModel (0,0,10,1));
	m_NumberOfCopies.setValue(Integer.valueOf(1));
	m_NumberOfCopies.addChangeListener (this);
	
	m_InvoicesPanel.add (m_NumberOfInvoicesLabel,   l_Constraints.xywh(2, 2, 1, 1));
	m_InvoicesPanel.add (m_NumberOfInvoices,   		l_Constraints.xywh(4, 2, 1, 1));
	m_InvoicesPanel.add (m_NumberOfCopiesLabel,   	l_Constraints.xywh(2, 4, 1, 1));
	m_InvoicesPanel.add (m_NumberOfCopies,   		l_Constraints.xywh(4, 4, 1, 1));

	//=======================================================================
	//= Assemble Print Panel
	//=======================================================================

	m_PrintBorder = new TitledBorder (Translatrix.getTranslationString(c_PrintBorder));

	m_PrintPanel = new BatchPrintPanel ();
	m_PrintPanel.setBorder(m_PrintBorder);
		
	//=======================================================================
	//= Assemble Dialog
	//=======================================================================
 
	l_Layout = new FormLayout(c_Columns, c_Rows);
	this.setLayout(l_Layout);
	this.add (m_InvoicesPanel,  	 l_Constraints.xywh(2, 2, 3, 1));
	this.add (m_PrintPanel,  		 l_Constraints.xywh(2, 4, 3, 1));
	this.add (m_CancelButton,  		 l_Constraints.xywh(4, 6, 1, 1));
	
	this.setSize(c_PreferredSize);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public void setInvoiceStubs (Collection <InvoiceStub> p_InvoiceStubs)
	{
	Integer	l_Count;
	
	if (p_InvoiceStubs != null)
		{
		m_PrintPanel.setInvoiceStubs(p_InvoiceStubs);
		l_Count = Integer.valueOf(p_InvoiceStubs.size());
		m_NumberOfInvoices.setText (l_Count.toString());
		}
	}

//---------------------------------------------------------------------------

public void setSortingCriteria (int p_SortingProperty, int p_SortDirection)
	{
	m_PrintPanel.setSortingCriteria(p_SortingProperty, p_SortDirection);
	}

//---------------------------------------------------------------------------

public void setNumberOfCopies (int p_NumberOfCopies)
	{
	m_NumberOfCopies.setValue (Integer.valueOf(p_NumberOfCopies));
	}

//---------------------------------------------------------------------------

public Collection <InvoiceStub> getPrintedInvoiceStubs ()
	{
	return m_PrintPanel.getPrintedInvoiceStubs();
	}

//---------------------------------------------------------------------------

public boolean wasAborted ()
	{
	return m_PrintPanel.wasAborted();
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	if (m_InvoicesBorder != null)
		m_InvoicesBorder.setTitle(Translatrix.getTranslationString (c_InvoicesBorder));
		
	if (m_NumberOfInvoicesLabel != null)
		m_NumberOfInvoicesLabel.setText(Translatrix.getTranslationString (c_NumberOfInvoicesLabel));

	if (m_NumberOfCopiesLabel != null)
		m_NumberOfCopiesLabel.setText(Translatrix.getTranslationString (c_NumberOfCopiesLabel));
		
	if (m_PrintBorder != null)
		m_PrintBorder.setTitle(Translatrix.getTranslationString (c_PrintBorder));
	
	if (m_CancelButton != null) 
		m_CancelButton.setText(Translatrix.getTranslationString("core.cancel"));
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource().equals (m_CancelButton))
		{
		m_PrintPanel.abortBatchPrinting();
		this.setVisible (false);
		}
	}

//---------------------------------------------------------------------------

public void stateChanged(ChangeEvent p_Event) 
	{
	Integer l_NumberOfCopies;
	
	if (p_Event.getSource().equals (m_NumberOfCopies))
		{
		l_NumberOfCopies = (Integer)m_NumberOfCopies.getValue();
		m_PrintPanel.setNumberOfCopies(l_NumberOfCopies.intValue());
		}
	}
			
//---------------------------------------------------------------------------	
//***************************************************************************
//* End of Class				                            				*
//***************************************************************************
//---------------------------------------------------------------------------	
}
