package lu.tudor.santec.gecamed.billing.gui.print;

import javax.swing.JLabel;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: PrintCopyDialog.java,v $
 * <br>Revision 1.2  2013-12-10 11:26:18  ferring
 * <br>cancel option added
 * <br>
 * <br>Revision 1.1  2013-10-04 13:42:54  ferring
 * <br>First attempt to ask whether to print the invoice as original or as copy
 * <br>
 */

public class PrintCopyDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static PrintCopyDialog instance;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	private PrintCopyDialog ()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("PrintCopyDialog.title"), 
				YES_NO_CANCEL_BUTTON_MODE);
		
		yesButton.setText(Translatrix.getTranslationString("PrintCopyDialog.copy"));
		yesButton.setIcon(null);
		noButton.setText(Translatrix.getTranslationString("PrintCopyDialog.original"));
		noButton.setIcon(null);
		
		JLabel message = new JLabel(Translatrix.getTranslationString("PrintCopyDialog.message"));
		message.setOpaque(false);
		
		mainPanel.setLayout(new FormLayout("15px, f:p:g, 15px", "15px, f:p:g, 15px"));
		mainPanel.add(message, new CellConstraints(2, 2));
		
		pack();
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	/**
	 * @return <code>true</code> if the invoice shall be printed as copy, 
	 * <code>false</code> if the original shall be printed 
	 * or <code>null</code> if cancel or close option was chosen.
	 */
	public static Boolean showDialog ()
	{
//		if (instance == null)
			instance = new PrintCopyDialog();
		
		int option = instance.showCenteredDialog();
		
		if (option == YES_OPTION)
			return Boolean.FALSE;
		else if (option == NO_OPTION)
			return Boolean.TRUE;
		else // if (option == CANCEL_OPTION || option == CLOSED_OPTION)
			return null;
	}
}
