/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Payment;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.ejb.session.beans.InvoiceBean;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.InvoiceInterface;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.gui.config.AccountComboBoxRenderer;
import lu.tudor.santec.gecamed.billing.gui.hospitalisation.HospitalisationClassListModel;
import lu.tudor.santec.gecamed.billing.gui.invoice.StateChooser;
import lu.tudor.santec.gecamed.billing.gui.medpres.MedPres;
import lu.tudor.santec.gecamed.billing.gui.settlement.AccountListModel;
import lu.tudor.santec.gecamed.billing.gui.settlement.PaymentListModel;
import lu.tudor.santec.gecamed.billing.gui.statement.InsuranceListModel;
import lu.tudor.santec.gecamed.billing.gui.statement.PhysicianListModel;
import lu.tudor.santec.gecamed.billing.utils.BillingAdminSettings;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.GECAMedMessage;
import lu.tudor.santec.gecamed.core.gui.GECAMedMessageListener;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.RegistrationDesk;
import lu.tudor.santec.gecamed.core.gui.utils.ComponentTitledPanel;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.core.utils.querybuilder.Group;
import lu.tudor.santec.gecamed.core.utils.querybuilder.HibernateCondition;
import lu.tudor.santec.gecamed.core.utils.querybuilder.HibernateOperator;
import lu.tudor.santec.gecamed.core.utils.querybuilder.HibernateSubSelect;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationClass;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.gui.HospitalisationClassComboBoxRenderer;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class InvoiceSearchDialog extends JDialog implements ItemListener,
															ListSelectionListener,
															ActionListener,
															PropertyChangeListener,
															Relocalizable, 
															GECAMedMessageListener
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private ComponentTitledPanel	m_PhysicianBorder;
	private JPanel					m_PhysicianPanel;
	private JCheckBox				m_SearchByPhysician;
	private PhysicianListModel		m_Physicians;
	private JList					m_PhysicianList;
	private JScrollPane				m_PhysicianScroller;
	private JCheckBox				m_SearchActs;
	
	private ComponentTitledPanel	m_InsuranceBorder;
	private JPanel					m_InsurancePanel;
	private JCheckBox				m_SearchByInsurance;
	private JLabel					m_HealthInsurancesLabel;
	private InsuranceListModel		m_HealthInsurances;
	private JList					m_HealthInsuranceList;
	private JScrollPane				m_HealthInsuranceScroller;
	private JLabel					m_ThirdPartyPayersLabel;
	private InsuranceListModel		m_ThirdPartyPayers;
	private JList					m_ThirdPartyPayerList;
	private JScrollPane				m_ThirdPartyPayerScroller;
	private JCheckBox				m_NotThirdParty;
	
	private ComponentTitledPanel	m_InvoiceDateBorder;
	private JPanel					m_InvoiceDatePanel;
	private JCheckBox				m_SearchByInvoiceDate;
	private JLabel					m_InvoiceFromDateLabel;
	private JDateChooser			m_InvoiceFromDate;
	private JLabel					m_InvoiceUntilDateLabel;
	private JDateChooser			m_InvoiceUntilDate;
	
	private ComponentTitledPanel			m_HospitalisationClassBorder;
	private JPanel							m_HospitalisationClassPanel;
	private JCheckBox						m_SearchByHospitalisationClass;
	private HospitalisationClassListModel	m_HospitalisationClasses;
	private JList							m_HospitalisationClassList;
	private JScrollPane						m_HospitalisationClassScroller;

	private ComponentTitledPanel	m_StateBorder;
	private JPanel					m_StatePanel;
	private JCheckBox				m_SearchByState;
	private StateChooser			m_States;
	private JCheckBox				m_WithDeduction;
	private JCheckBox				m_PartialSettlement;
	
	private ComponentTitledPanel	m_SettlementDateBorder;
	private JPanel					m_SettlementDatePanel;
	private JCheckBox				m_SearchBySettlementDate;
	private JLabel					m_SettlementFromDateLabel;
	private JDateChooser			m_SettlementFromDate;
	private JLabel					m_SettlementUntilDateLabel;
	private JDateChooser			m_SettlementUntilDate;
	
	private ComponentTitledPanel	m_SettlementBorder;
	private JPanel					m_SettlementPanel;
	private JCheckBox				m_SearchBySettlement;
	private JLabel					m_PaymentLabel;
	private PaymentListModel		m_Payments;
	private JList					m_PaymentList;
	private JScrollPane				m_PaymentScroller;
	private JLabel					m_AccountLabel;
	private AccountListModel		m_Accounts;
	private JList					m_AccountList;
	private JScrollPane				m_AccountScroller;
	private AccountComboBoxRenderer m_AccountRenderer;
	
	private TitledBorder			m_SearchBorder;
	private JPanel					m_SearchPanel;
	private JLabel		 			m_SearchStep;
//	private JLabel					m_SearchStatus;
	private JButton					m_SearchButton;
	
	private TitledBorder			m_LoadBorder;
	private JPanel					m_LoadPanel;
	private JLabel		 			m_LoadStep;
	private JButton					m_LoadButton;
	
	private JButton					m_CancelButton;
	
	private InvoiceInterface		m_InvoiceInterface;
	private WhereClause				m_WhereClause;
	private Long					m_InvoiceCount;
	private boolean					m_Validated;
	
	private Hashtable <Payment,Integer> m_PaymentLookup;
	private Hashtable <Account,Integer> m_AccountLookup;

	private JPanel m_EmissionDatePanel;

	private JCheckBox m_SearchByEmissionDate;

	private JLabel m_EmissionFromDateLabel;

	private JLabel m_EmissionUntilDateLabel;

	private JDateChooser m_EmissionFromDate;

	private JDateChooser m_EmissionUntilDate;

	private ComponentTitledPanel m_EmissionDateBorder;

	private JPanel m_EndDatePanel;

	private JCheckBox m_SearchByEndDate;

	private JLabel m_EndFromDateLabel;

	private JLabel m_EndUntilDateLabel;

	private JDateChooser m_EndUntilDate;

	private ComponentTitledPanel m_EndDateBorder;

	private JPanel m_DueDatePanel;

	private JCheckBox m_SearchByDueDate;

	private JLabel m_DueFromDateLabel;

	private JDateChooser m_DueFromDate;

	private JLabel m_DueUntilDateLabel;

	private JDateChooser m_DueUntilDate;

	private ComponentTitledPanel m_DueDateBorder;

	private JPanel m_ReminderDatePanel;

	private JCheckBox m_SearchByReminderDate;

	private JLabel m_ReminderFromDateLabel;

	private JDateChooser m_ReminderFromDate;

	private JLabel m_ReminderUntilDateLabel;

	private JDateChooser m_ReminderUntilDate;

	private ComponentTitledPanel m_ReminderDateBorder;

	private JDateChooser m_EndFromDate;

	private JPanel m_MedPresPanel;

	private JCheckBox m_SearchByMedPres;

	private JList m_MedPresList;

	private JScrollPane m_MedPresScroller;

	private ComponentTitledPanel m_MedPresBorder;

	private WhereClause l_SubSelectClause;
	
	private static Logger m_Logger = Logger.getLogger (InvoiceSearchDialog.class.getName());
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
		
	private final static Dimension c_PreferredSize = new Dimension (800,400);

	private final static String c_AccountTemplate =
		
		"<html>" + AccountComboBoxRenderer.c_BankPlaceHolder + "<br>" +
        "<span style=\"font-size: 7px\">&nbsp;&nbsp;&nbsp;" + AccountComboBoxRenderer.c_IBANPlaceHolder + "</span></html>";

	private final static String c_Columns				= 	"3dlu,fill:max(40dlu;pref)," +
															"3dlu,fill:max(40dlu;pref)," +
															"3dlu,fill:max(40dlu;pref)," +
															"3dlu,fill:max(40dlu;pref)," +
															"3dlu,fill:max(50dlu;pref)," +
															"3dlu,fill:max(40dlu;pref)," +
															"3dlu,fill:max(40dlu;pref)," +
															"3dlu,fill:max(30dlu;pref),3dlu";
	
	private final static String c_Rows					=   "3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
										 					"3dlu,fill:pref,3dlu";

	private final static String c_PhysicianPanelColumns		=	"3dlu,fill:max(140dlu;pref):grow,3dlu";
	
	private final static String c_PhysicianPanelRows		=	"3dlu,fill:max(70dlu;pref)," + 
																"3dlu,fill:pref,3dlu";
	
	private final static String c_InsurancePanelColumns		=	"3dlu,fill:max(70dlu;pref)," +
																"3dlu,fill:max(70dlu;pref),3dlu";
	
	private final static String c_InsurancePanelRows		=	"3dlu,fill:pref," +
																"3dlu,fill:max(70dlu;pref)," +
																"3dlu,fill:pref,3dlu";

	private final static String c_InvoiceDatePanelColumns	=	"3dlu,fill:max(70dlu;pref):grow,3dlu";

	private final static String c_InvoiceDatePanelRows		=	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";
	
	private final static String c_HospitalisationClassPanelColumns	=	"3dlu,fill:max(60dlu;pref):grow,3dlu";

	private final static String c_HospitalisationClassPanelRows		=	"3dlu,fill:max(30dlu;pref):grow,3dlu";
	
	private final static String c_StatePanelColumns			=	"3dlu,fill:pref,3dlu";
	
	private final static String c_StatePanelRows			=	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";

	private final static String c_SettlementDatePanelColumns =	"3dlu,fill:max(70dlu;pref):grow,3dlu";

	private final static String c_SettlementDatePanelRows	 =	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";

	private final static String c_SettlementPanelColumns	=	"3dlu,fill:100px," +
																"3dlu,fill:150px:g," +
																"3dlu";
	
	private final static String c_SettlementPanelRows		=	"3dlu,fill:70dlu,3dlu";
	
	private final static String c_SearchPanelColumns 		= 	"3dlu,fill:pref," +
																"10dlu,fill:max(50dlu;pref)," +
																"3dlu,center:max(50dlu;pref):grow,3dlu";

	private final static String c_SearchPanelRows 			= 	"3dlu,fill:pref,3dlu";

	private final static String c_LoadPanelColumns 			= 	"3dlu,fill:pref," +
																"10dlu,fill:pref:grow,3dlu";

	private final static String c_LoadPanelRows 			= 	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";
	
	private final static String c_EmissionDatePanelColumns =	"3dlu,fill:max(70dlu;pref):grow,3dlu";
	private final static String c_EmissionDatePanelRows	 =	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";
	
	private final static String c_EndDatePanelColumns =	"3dlu,fill:max(70dlu;pref):grow,3dlu";
	private final static String c_EndDatePanelRows	 =	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";
	
	private final static String c_DueDatePanelColumns =	"3dlu,fill:max(70dlu;pref):grow,3dlu";
	private final static String c_DueDatePanelRows	 =	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";
	
	private final static String c_ReminderDatePanelColumns =	"3dlu,fill:max(70dlu;pref):grow,3dlu";
	private final static String c_ReminderDatePanelRows	 =	"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref," +
																"3dlu,fill:pref,3dlu";

	private final static String c_MedTransPanelColumns		=	"3dlu,fill:max(140dlu;pref):grow,3dlu";
	private final static String c_MedTransPanelRows		=	"3dlu,fill:max(70dlu;pref)," + 
																"3dlu,fill:pref,3dlu";
	
//***************************************************************************
//* Constructor                                                             *
//***************************************************************************

public 	InvoiceSearchDialog ()
	{
	super (MainFrame.getInstance(),Translatrix.getTranslationString("InvoiceSearchDialog.Title"),true);

	CellConstraints	l_Constraints;
	FormLayout		l_Layout;

	m_Validated = false;
	
	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);

	this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

	//------------------------------------------------------------------------
	// Build Physician Panel
	//------------------------------------------------------------------------

	this.buildPhysiciansPanel();
	this.buildInsurancePanel();
	this.buildInvoiceDatePanel();
	this.buildStatePanel();
	this.buildSettlementDatePanel();
	this.buildSettlementPanel();
	this.buildSearchPanel();
	this.buildLoadPanel();
	this.buildEndDatePanel();
	this.buildDueDatePanel();
	this.buildEmissionDatePanel();
	this.buildReminderDatePanel();
	this.buildMedPresPanel();

	if ((Boolean)BillingModule.getSetting(BillingAdminSettings.c_HospitalisationSetting))
		{
		this.buildHospitalisationClassPanel();
		}
	
	l_Constraints  = new CellConstraints();
	l_Layout = new FormLayout(c_Columns, c_Rows);
	this.setLayout(l_Layout);
	
	// row 1
	this.add(m_PhysicianBorder,     	l_Constraints.xywh(2, 2, 7, 1));
	this.add(m_InsuranceBorder,     	l_Constraints.xywh(10, 2, 7, 1));
	
	// row 2
	this.add(m_InvoiceDateBorder,		l_Constraints.xywh(2, 4, 3, 1));
	this.add(m_EmissionDateBorder,		l_Constraints.xywh(6, 4, 3, 1));
	if ((Boolean)BillingModule.getSetting(BillingAdminSettings.c_HospitalisationSetting))
		{
		this.add(m_StateBorder,					l_Constraints.xywh(10, 4, 3, 1));
		this.add(m_HospitalisationClassBorder,  l_Constraints.xywh(14, 4, 3, 1));
		}
	else this.add(m_StateBorder,					l_Constraints.xywh(10, 4, 7, 1));
	
	// row 3
	this.add(m_SettlementDateBorder,	l_Constraints.xywh(2, 6, 3, 1));
	this.add(m_EndDateBorder,			l_Constraints.xywh(6, 6, 3, 1));
	this.add(m_SettlementBorder,		l_Constraints.xywh(10, 6, 7, 1));
	
	// row 4
	this.add(m_DueDateBorder,			l_Constraints.xywh(2, 8, 3, 1));
	this.add(m_ReminderDateBorder,		l_Constraints.xywh(6, 8, 3, 1));
	this.add(m_MedPresBorder,			l_Constraints.xywh(10, 8, 7, 1));
	
	// row 5
	this.add(m_SearchPanel,				l_Constraints.xywh(2, 10, 7, 1));
	this.add(m_LoadPanel,				l_Constraints.xywh(10, 10, 7, 1));
	
	m_CancelButton = new JButton (Translatrix.getTranslationString("core.cancel"));
	m_CancelButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
	m_CancelButton.addActionListener(this);

	this.add (m_CancelButton,  l_Constraints.xywh(12, 12, 5, 1));
	
	this.setSize(c_PreferredSize);
	this.relocalize ();
	this.setLocationRelativeTo(MainFrame.getInstance());
	}

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

private boolean showOnlyInvoicesOfCurrentPhysician ()
	{
	boolean l_ShowOnlyCurrentPhysician;
	
	l_ShowOnlyCurrentPhysician = 
	
	!BillingModule.userHasPermission(MainFrame.PERMISSIONS_CORE, MainFrame.PERMISSION_CHANGE_PHYSICIAN)
	
	&&
		
	(Boolean)BillingModule.getSetting(BillingAdminSettings.c_SplitBillingSetting);
	
	return l_ShowOnlyCurrentPhysician;
	}

//---------------------------------------------------------------------------

private Date getInvoiceFromDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_InvoiceFromDate.getDate();
	l_UntilDate = m_InvoiceUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_FromDate = BillingModule.getEarliestDate (l_FromDate, l_UntilDate);
	
	return l_FromDate;
	}

//---------------------------------------------------------------------------

private Date getInvoiceUntilDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_InvoiceFromDate.getDate();
	l_UntilDate = m_InvoiceUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_UntilDate = BillingModule.getLatestDate (l_FromDate, l_UntilDate);
	
	return l_UntilDate;
	}

//---------------------------------------------------------------------------

private Date getSettlementFromDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_SettlementFromDate.getDate();
	l_UntilDate = m_SettlementUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_FromDate = BillingModule.getEarliestDate (l_FromDate, l_UntilDate);
	
	return l_FromDate;
	}

//---------------------------------------------------------------------------

private Date getEmissionFromDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_EmissionFromDate.getDate();
	l_UntilDate = m_EmissionUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_FromDate = BillingModule.getEarliestDate (l_FromDate, l_UntilDate);
	
	return l_FromDate;
	}

//---------------------------------------------------------------------------

private Date getEndFromDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_EndFromDate.getDate();
	l_UntilDate = m_EndUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_FromDate = BillingModule.getEarliestDate (l_FromDate, l_UntilDate);
	
	return l_FromDate;
	}

//---------------------------------------------------------------------------

private Date getDueFromDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_DueFromDate.getDate();
	l_UntilDate = m_DueUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_FromDate = BillingModule.getEarliestDate (l_FromDate, l_UntilDate);
	
	return l_FromDate;
	}

//---------------------------------------------------------------------------

private Date getReminderFromDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_ReminderFromDate.getDate();
	l_UntilDate = m_ReminderUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_FromDate = BillingModule.getEarliestDate (l_FromDate, l_UntilDate);
	
	return l_FromDate;
	}

//---------------------------------------------------------------------------
private Date getSettlementUntilDate ()
	{
	Date l_FromDate;
	Date l_UntilDate;
	
	l_FromDate  = m_SettlementFromDate.getDate();
	l_UntilDate = m_SettlementUntilDate.getDate();
	
	if ((l_FromDate != null) && (l_UntilDate != null))
		l_UntilDate = BillingModule.getLatestDate (l_FromDate, l_UntilDate);
	
	return l_UntilDate;
	}

//---------------------------------------------------------------------------

private Date getEmissionUntilDate ()
{
Date l_FromDate;
Date l_UntilDate;

l_FromDate  = m_EmissionFromDate.getDate();
l_UntilDate = m_EmissionUntilDate.getDate();

if ((l_FromDate != null) && (l_UntilDate != null))
	l_UntilDate = BillingModule.getLatestDate (l_FromDate, l_UntilDate);

return l_UntilDate;
}

//---------------------------------------------------------------------------

private Date getDueUntilDate ()
{
Date l_FromDate;
Date l_UntilDate;

l_FromDate  = m_DueFromDate.getDate();
l_UntilDate = m_DueUntilDate.getDate();

if ((l_FromDate != null) && (l_UntilDate != null))
	l_UntilDate = BillingModule.getLatestDate (l_FromDate, l_UntilDate);

return l_UntilDate;
}

//---------------------------------------------------------------------------

private Date getEndUntilDate ()
{
Date l_FromDate;
Date l_UntilDate;

l_FromDate  = m_EndFromDate.getDate();
l_UntilDate = m_EndUntilDate.getDate();

if ((l_FromDate != null) && (l_UntilDate != null))
	l_UntilDate = BillingModule.getLatestDate (l_FromDate, l_UntilDate);

return l_UntilDate;
}

//---------------------------------------------------------------------------

private Date getReminderUntilDate ()
{
Date l_FromDate;
Date l_UntilDate;

l_FromDate  = m_ReminderFromDate.getDate();
l_UntilDate = m_ReminderUntilDate.getDate();

if ((l_FromDate != null) && (l_UntilDate != null))
	l_UntilDate = BillingModule.getLatestDate (l_FromDate, l_UntilDate);

return l_UntilDate;
}

//---------------------------------------------------------------------------


private void buildPhysiciansPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_PhysicianPanel = new JPanel ();

	l_Layout = new FormLayout(c_PhysicianPanelColumns, c_PhysicianPanelRows);
	m_PhysicianPanel.setLayout (l_Layout);
	m_PhysicianPanel.setOpaque(true);
	
	m_SearchByPhysician = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.PhysiciansSwitch"));
    m_SearchByPhysician.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchByPhysician.setSelected(false);
    m_SearchByPhysician.addItemListener (this);
    
	m_Physicians = new PhysicianListModel ();
	
	m_PhysicianList = new JList (m_Physicians);
	m_PhysicianList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_PhysicianList.setLayoutOrientation(JList.VERTICAL);
	m_PhysicianList.setVisibleRowCount(-1);
	
	m_PhysicianScroller = new JScrollPane (m_PhysicianList);
	m_PhysicianScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
	
	m_SearchActs = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.SearchActs"));
    m_SearchActs.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SearchActs.setSelected(false);
	
	m_PhysicianPanel.add (m_PhysicianScroller, l_Constraints.xywh(2, 2, 1, 1));
	m_PhysicianPanel.add (m_SearchActs,        l_Constraints.xywh(2, 4, 1, 1));

	m_PhysicianBorder = new ComponentTitledPanel (m_SearchByPhysician,m_PhysicianPanel);
    m_PhysicianBorder.setOpaque(false);	

	m_Physicians.setPhysicians(GECAMedLists.getListCopy(Physician.class));
	
	this.enablePhysicianPanel(false);
	}

//---------------------------------------------------------------------------


private void buildMedPresPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_MedPresPanel = new JPanel ();

	l_Layout = new FormLayout(c_MedTransPanelColumns, c_MedTransPanelRows);
	m_MedPresPanel.setLayout (l_Layout);
	m_MedPresPanel.setOpaque(true);
	
	m_SearchByMedPres = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.MedPresSwitch"));
	m_SearchByMedPres.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SearchByMedPres.setSelected(false);
	m_SearchByMedPres.addItemListener (this);
  
	m_MedPresList = new JList<MedPres> ();
	m_MedPresList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_MedPresList.setLayoutOrientation(JList.VERTICAL);
	m_MedPresList.setVisibleRowCount(-1);
	
	m_MedPresScroller = new JScrollPane (m_MedPresList);
	m_MedPresScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

	m_MedPresPanel.add (m_MedPresScroller, l_Constraints.xywh(2, 2, 1, 1));

	m_MedPresBorder = new ComponentTitledPanel (m_SearchByMedPres,m_MedPresPanel);
    m_MedPresBorder.setOpaque(false);	

    RegistrationDesk.addGECAMedMessageListener(this);
    updateMedTrans();
    
    this.enableMedPresPanel( false);
	}

//---------------------------------------------------------------------------	

private void buildInsurancePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_InsurancePanel = new JPanel ();

	l_Layout = new FormLayout(c_InsurancePanelColumns, c_InsurancePanelRows);
	m_InsurancePanel.setLayout (l_Layout);
	m_InsurancePanel.setOpaque(true);
	
	m_SearchByInsurance = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.InsuranceSwitch"));
    m_SearchByInsurance.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchByInsurance.setSelected(false);
    m_SearchByInsurance.addItemListener (this);
		
	m_HealthInsurancesLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.HealthInsurancesLabel"));
	m_HealthInsurancesLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_HealthInsurances    = new InsuranceListModel ();

	m_HealthInsuranceList = new JList (m_HealthInsurances);
	m_HealthInsuranceList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_HealthInsuranceList.setLayoutOrientation(JList.VERTICAL);
	m_HealthInsuranceList.setVisibleRowCount(-1);
	
	m_HealthInsuranceScroller = new JScrollPane (m_HealthInsuranceList);
	m_HealthInsuranceScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
	
	m_ThirdPartyPayersLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.ThirdPartyPayersLabel"));
	m_ThirdPartyPayersLabel.setForeground(GECAMedColors.c_LabelColor);

	m_ThirdPartyPayers    = new InsuranceListModel ();

	m_ThirdPartyPayerList = new JList (m_ThirdPartyPayers);
	m_ThirdPartyPayerList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_ThirdPartyPayerList.setLayoutOrientation(JList.VERTICAL);
	m_ThirdPartyPayerList.setVisibleRowCount(-1);
	m_ThirdPartyPayerList.addListSelectionListener(this);
	
	m_ThirdPartyPayerScroller = new JScrollPane (m_ThirdPartyPayerList);
	m_ThirdPartyPayerScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
	
	m_NotThirdParty = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.NotThirdParty"));
	m_NotThirdParty.setBackground(GECAMedColors.c_GECAMedBackground);
	m_NotThirdParty.addItemListener(this);
	
	m_InsurancePanel.add (m_HealthInsurancesLabel, 		l_Constraints.xywh(2, 2, 1, 1));
	m_InsurancePanel.add (m_ThirdPartyPayersLabel, 		l_Constraints.xywh(4, 2, 1, 1));
	m_InsurancePanel.add (m_HealthInsuranceScroller, 	l_Constraints.xywh(2, 4, 1, 1));
	m_InsurancePanel.add (m_ThirdPartyPayerScroller, 	l_Constraints.xywh(4, 4, 1, 1));
	m_InsurancePanel.add (m_NotThirdParty, 				l_Constraints.xywh(4, 6, 1, 1));
 
	m_InsuranceBorder = new ComponentTitledPanel (m_SearchByInsurance,m_InsurancePanel);
    m_InsuranceBorder.setOpaque(false);	
	
	this.populateInsurances (BillingModule.getInstance().getHealthInsurances());
	
	this.enableInsurancePanel(false);
	}

//---------------------------------------------------------------------------

private void buildInvoiceDatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_InvoiceDatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_InvoiceDatePanelColumns, c_InvoiceDatePanelRows);
	m_InvoiceDatePanel.setLayout (l_Layout);
	m_InvoiceDatePanel.setOpaque(true);
	
	m_SearchByInvoiceDate = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.InvoiceDateSwitch"));
    m_SearchByInvoiceDate.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchByInvoiceDate.setSelected(false);
    m_SearchByInvoiceDate.addItemListener (this);
	
	m_InvoiceFromDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.InvoiceFromDateLabel"));
 	m_InvoiceFromDateLabel.setForeground(GECAMedColors.c_LabelColor);
 	m_InvoiceFromDate = GECAMedGuiUtils.getDateChooser(false);
	m_InvoiceFromDate.addPropertyChangeListener(this);
	
	m_InvoiceUntilDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.InvoiceUntilDateLabel"));
 	m_InvoiceUntilDateLabel.setForeground(GECAMedColors.c_LabelColor);
 	m_InvoiceUntilDate = GECAMedGuiUtils.getDateChooser(false);
  
 	m_InvoiceDatePanel.add (m_InvoiceFromDateLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_InvoiceDatePanel.add (m_InvoiceFromDate, 			l_Constraints.xywh(2, 4, 1, 1));
	m_InvoiceDatePanel.add (m_InvoiceUntilDateLabel, 	l_Constraints.xywh(2, 6, 1, 1));
	m_InvoiceDatePanel.add (m_InvoiceUntilDate, 		l_Constraints.xywh(2, 8, 1, 1));
 
    m_InvoiceDateBorder = new ComponentTitledPanel (m_SearchByInvoiceDate,m_InvoiceDatePanel);
    m_InvoiceDateBorder.setOpaque(false);	
	
	this.enableInvoiceDatePanel (false);
	}

//---------------------------------------------------------------------------

private void buildHospitalisationClassPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_HospitalisationClassPanel = new JPanel ();
	
	l_Layout = new FormLayout(c_HospitalisationClassPanelColumns, c_HospitalisationClassPanelRows);
	m_HospitalisationClassPanel.setLayout (l_Layout);
	m_HospitalisationClassPanel.setOpaque(true);
	
	m_SearchByHospitalisationClass = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.HospitalisationClassSwitch"));
    m_SearchByHospitalisationClass.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchByHospitalisationClass.setSelected(false);
    m_SearchByHospitalisationClass.addItemListener (this);
	
	m_HospitalisationClasses    = new HospitalisationClassListModel ();

	m_HospitalisationClassList = new JList (m_HospitalisationClasses);
	m_HospitalisationClassList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_HospitalisationClassList.setLayoutOrientation(JList.VERTICAL);
	m_HospitalisationClassList.setCellRenderer(new HospitalisationClassComboBoxRenderer (true,true));
	m_HospitalisationClassList.setVisibleRowCount(-1);
	
	m_HospitalisationClassScroller = new JScrollPane (m_HospitalisationClassList);
	m_HospitalisationClassScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
  
 	m_HospitalisationClassPanel.add (m_HospitalisationClassScroller, 	l_Constraints.xywh(2, 2, 1, 1));

    m_HospitalisationClassBorder = new ComponentTitledPanel (m_SearchByHospitalisationClass,m_HospitalisationClassPanel);
    m_HospitalisationClassBorder.setOpaque(false);	
	
	m_HospitalisationClasses.setHospitalisationClasses(BillingModule.getInstance().getHospitalisationClasses());

    this.enableHospitalisationClassPanel (false);
	}

//---------------------------------------------------------------------------

private void buildStatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_StatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_StatePanelColumns, c_StatePanelRows);
	m_StatePanel.setLayout (l_Layout);
	m_StatePanel.setOpaque(true);
	
	m_SearchByState = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.StateSwitch"));
    m_SearchByState.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchByState.setSelected(false);
    m_SearchByState.addItemListener (this);
	
	m_States = new StateChooser (StateChooser.c_MultipleSelection);
  
 	m_WithDeduction 	= new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.WithDeduction")); 
 	m_WithDeduction.setOpaque(false);
 	m_PartialSettlement = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.PartialSettlement")); 
	m_PartialSettlement.setOpaque (false);
	
	m_StatePanel.add (m_States, 			l_Constraints.xywh(2, 2, 1, 1));
	m_StatePanel.add (m_WithDeduction, 	l_Constraints.xywh(2, 4, 1, 1));
	m_StatePanel.add (m_PartialSettlement, 	l_Constraints.xywh(2, 6, 1, 1));

    m_StateBorder = new ComponentTitledPanel (m_SearchByState,m_StatePanel);
    m_StateBorder.setOpaque(false);	
	
	this.enableStatePanel(false);
	}

//---------------------------------------------------------------------------

private void buildSettlementDatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_SettlementDatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_SettlementDatePanelColumns, c_SettlementDatePanelRows);
	m_SettlementDatePanel.setLayout (l_Layout);
	m_SettlementDatePanel.setOpaque(true);
	
	m_SearchBySettlementDate = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementDateSwitch"));
    m_SearchBySettlementDate.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchBySettlementDate.setSelected(false);
    m_SearchBySettlementDate.addItemListener (this);
	
	m_SettlementFromDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementFromDateLabel"));
 	m_SettlementFromDateLabel.setForeground(GECAMedColors.c_LabelColor);
 	m_SettlementFromDate = GECAMedGuiUtils.getDateChooser(false);
	m_SettlementFromDate.addPropertyChangeListener(this);
	
	m_SettlementUntilDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementUntilDateLabel"));
  	m_SettlementUntilDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_SettlementUntilDate = GECAMedGuiUtils.getDateChooser(false);
  
 	m_SettlementDatePanel.add (m_SettlementFromDateLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_SettlementDatePanel.add (m_SettlementFromDate, 		l_Constraints.xywh(2, 4, 1, 1));
	m_SettlementDatePanel.add (m_SettlementUntilDateLabel, 	l_Constraints.xywh(2, 6, 1, 1));
	m_SettlementDatePanel.add (m_SettlementUntilDate, 		l_Constraints.xywh(2, 8, 1, 1));
 
    m_SettlementDateBorder = new ComponentTitledPanel (m_SearchBySettlementDate,m_SettlementDatePanel);
    m_SettlementDateBorder.setOpaque(false);	
	
	this.enableSettlementDatePanel (false);
	}

//---------------------------------------------------------------------------

private void buildEmissionDatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_EmissionDatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_EmissionDatePanelColumns, c_EmissionDatePanelRows);
	m_EmissionDatePanel.setLayout (l_Layout);
	m_EmissionDatePanel.setOpaque(true);
	
	m_SearchByEmissionDate = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.EmissionDateSwitch"));
	m_SearchByEmissionDate.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SearchByEmissionDate.setSelected(false);
	m_SearchByEmissionDate.addItemListener (this);
	
	m_EmissionFromDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementFromDateLabel"));
	m_EmissionFromDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_EmissionFromDate = GECAMedGuiUtils.getDateChooser(false);
	m_EmissionFromDate.addPropertyChangeListener(this);
	
	m_EmissionUntilDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementUntilDateLabel"));
	m_EmissionUntilDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_EmissionUntilDate = GECAMedGuiUtils.getDateChooser(false);

	m_EmissionDatePanel.add (m_EmissionFromDateLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_EmissionDatePanel.add (m_EmissionFromDate, 		l_Constraints.xywh(2, 4, 1, 1));
	m_EmissionDatePanel.add (m_EmissionUntilDateLabel, 	l_Constraints.xywh(2, 6, 1, 1));
	m_EmissionDatePanel.add (m_EmissionUntilDate, 		l_Constraints.xywh(2, 8, 1, 1));

	m_EmissionDateBorder = new ComponentTitledPanel (m_SearchByEmissionDate,m_EmissionDatePanel);
	m_EmissionDateBorder.setOpaque(false);	
	
	this.enableEmissionDatePanel (false);
	}

//---------------------------------------------------------------------------

private void buildEndDatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_EndDatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_EndDatePanelColumns, c_EndDatePanelRows);
	m_EndDatePanel.setLayout (l_Layout);
	m_EndDatePanel.setOpaque(true);
	
	m_SearchByEndDate = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.EndDateSwitch"));
	m_SearchByEndDate.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SearchByEndDate.setSelected(false);
	m_SearchByEndDate.addItemListener (this);
	
	m_EndFromDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementFromDateLabel"));
	m_EndFromDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_EndFromDate = GECAMedGuiUtils.getDateChooser(false);
	m_EndFromDate.addPropertyChangeListener(this);
	
	m_EndUntilDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementUntilDateLabel"));
	m_EndUntilDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_EndUntilDate = GECAMedGuiUtils.getDateChooser(false);

	m_EndDatePanel.add (m_EndFromDateLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_EndDatePanel.add (m_EndFromDate, 			l_Constraints.xywh(2, 4, 1, 1));
	m_EndDatePanel.add (m_EndUntilDateLabel, 	l_Constraints.xywh(2, 6, 1, 1));
	m_EndDatePanel.add (m_EndUntilDate, 		l_Constraints.xywh(2, 8, 1, 1));

	m_EndDateBorder = new ComponentTitledPanel (m_SearchByEndDate,m_EndDatePanel);
	m_EndDateBorder.setOpaque(false);	
	
	this.enableEndDatePanel (false);
	}

//---------------------------------------------------------------------------

private void buildDueDatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_DueDatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_DueDatePanelColumns, c_DueDatePanelRows);
	m_DueDatePanel.setLayout (l_Layout);
	m_DueDatePanel.setOpaque(true);
	
	m_SearchByDueDate = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.DueDateSwitch"));
	m_SearchByDueDate.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SearchByDueDate.setSelected(false);
	m_SearchByDueDate.addItemListener (this);
	
	m_DueFromDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementFromDateLabel"));
	m_DueFromDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_DueFromDate = GECAMedGuiUtils.getDateChooser(false);
	m_DueFromDate.addPropertyChangeListener(this);
	
	m_DueUntilDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementUntilDateLabel"));
	m_DueUntilDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_DueUntilDate = GECAMedGuiUtils.getDateChooser(false);

	m_DueDatePanel.add (m_DueFromDateLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_DueDatePanel.add (m_DueFromDate, 		l_Constraints.xywh(2, 4, 1, 1));
	m_DueDatePanel.add (m_DueUntilDateLabel, 	l_Constraints.xywh(2, 6, 1, 1));
	m_DueDatePanel.add (m_DueUntilDate, 		l_Constraints.xywh(2, 8, 1, 1));

	m_DueDateBorder = new ComponentTitledPanel (m_SearchByDueDate,m_DueDatePanel);
	m_DueDateBorder.setOpaque(false);	
	
	this.enableDueDatePanel (false);
	}

//---------------------------------------------------------------------------

private void buildReminderDatePanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_ReminderDatePanel = new JPanel ();
	
	l_Layout = new FormLayout(c_ReminderDatePanelColumns, c_ReminderDatePanelRows);
	m_ReminderDatePanel.setLayout (l_Layout);
	m_ReminderDatePanel.setOpaque(true);
	
	m_SearchByReminderDate = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.ReminderDateSwitch"));
	m_SearchByReminderDate.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SearchByReminderDate.setSelected(false);
	m_SearchByReminderDate.addItemListener (this);
	
	m_ReminderFromDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementFromDateLabel"));
	m_ReminderFromDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_ReminderFromDate = GECAMedGuiUtils.getDateChooser(false);
	m_ReminderFromDate.addPropertyChangeListener(this);
	
	m_ReminderUntilDateLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementUntilDateLabel"));
	m_ReminderUntilDateLabel.setForeground(GECAMedColors.c_LabelColor);
	m_ReminderUntilDate = GECAMedGuiUtils.getDateChooser(false);

	m_ReminderDatePanel.add (m_ReminderFromDateLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_ReminderDatePanel.add (m_ReminderFromDate, 		l_Constraints.xywh(2, 4, 1, 1));
	m_ReminderDatePanel.add (m_ReminderUntilDateLabel, 	l_Constraints.xywh(2, 6, 1, 1));
	m_ReminderDatePanel.add (m_ReminderUntilDate, 		l_Constraints.xywh(2, 8, 1, 1));

	m_ReminderDateBorder = new ComponentTitledPanel (m_SearchByReminderDate,m_ReminderDatePanel);
	m_ReminderDateBorder.setOpaque(false);	
	
	this.enableReminderDatePanel (false);
	}


//---------------------------------------------------------------------------

private void buildSettlementPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_SettlementPanel = new JPanel ();
	
	l_Layout = new FormLayout(c_SettlementPanelColumns, c_SettlementPanelRows);
	
	m_SettlementPanel.setLayout (l_Layout);
	m_SettlementPanel.setOpaque(true);
	
	m_SearchBySettlement = new JCheckBox (Translatrix.getTranslationString("InvoiceSearchDialog.PaymentSwitch"));
    m_SearchBySettlement.setBackground(GECAMedColors.c_GECAMedBackground);
    m_SearchBySettlement.setSelected(false);
    m_SearchBySettlement.addItemListener (this);
	
	m_PaymentLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.PaymentLabel"));
 	m_PaymentLabel.setForeground(GECAMedColors.c_LabelColor);
    
    m_Payments = new PaymentListModel ();
	
	m_PaymentList = new JList (m_Payments);
	m_PaymentList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_PaymentList.setLayoutOrientation(JList.VERTICAL);
	m_PaymentList.setVisibleRowCount(-1);
	m_PaymentList.addListSelectionListener(this);
	
	m_PaymentScroller = new JScrollPane (m_PaymentList);
//	m_PaymentScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
	m_PaymentScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
	m_PaymentScroller.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
	m_PaymentScroller.getViewport().setBackground(Color.WHITE);
	
	m_AccountLabel = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.AccountLabel"));
 	m_AccountLabel.setForeground(GECAMedColors.c_LabelColor);

 	m_Accounts = new AccountListModel ();
	
	m_AccountRenderer = new AccountComboBoxRenderer(c_AccountTemplate);
 	
 	m_AccountList = new JList (m_Accounts);
	m_AccountList.setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	m_AccountList.setCellRenderer(m_AccountRenderer);
	m_AccountList.setLayoutOrientation(JList.VERTICAL);
	m_AccountList.setVisibleRowCount(-1);
	m_AccountList.addListSelectionListener(this);
	
	m_AccountScroller = new JScrollPane (m_AccountList);
//	m_AccountScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
	m_AccountScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
	m_AccountScroller.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
	m_AccountScroller.getViewport().setBackground(Color.WHITE);
	
	m_SettlementPanel.add (m_PaymentScroller, l_Constraints.xywh(2, 2, 1, 1));
	m_SettlementPanel.add (m_AccountScroller, l_Constraints.xywh(4, 2, 1, 1));
	
	m_SettlementBorder = new ComponentTitledPanel (m_SearchBySettlement,m_SettlementPanel);
    m_SettlementBorder.setOpaque(false);	
	
	this.populateSettlementMethods (BillingModule.getInstance().getSettlementMethods());
    
    this.enableSettlementPanel(false);
	}

//---------------------------------------------------------------------------	

private void buildSearchPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_SearchBorder = new TitledBorder (Translatrix.getTranslationString("InvoiceSearchDialog.SearchBorder"));

	m_SearchPanel = new JPanel ();
	m_SearchPanel.setBorder(m_SearchBorder);
	
	l_Layout = new FormLayout(c_SearchPanelColumns, c_SearchPanelRows);
	m_SearchPanel.setLayout (l_Layout);
	m_SearchPanel.setOpaque (false);
	
	m_SearchStep = new JLabel ();
	m_SearchStep.setIcon(BillingModule.getIconResource("step1.png"));
	m_SearchStep.setText(null);
	m_SearchStep.setToolTipText(null);

	m_SearchButton = new JButton (Translatrix.getTranslationString("InvoiceSearchDialog.SearchButton") + ": "  + 
			Translatrix.getTranslationString("InvoiceSearchDialog.Idle"));
	m_SearchButton.setIcon (GECAMedModule.getIcon(GECAMedIconNames.SEARCH));
	m_SearchButton.addActionListener(this);

//	m_SearchStatus = new JLabel (Translatrix.getTranslationString("InvoiceSearchDialog.Idle"));
//	m_SearchStatus.setForeground (GECAMedColors.c_LabelColor);

	m_SearchPanel.add (m_SearchStep,     l_Constraints.xywh(2, 2, 1, 1));
	m_SearchPanel.add (m_SearchButton,   l_Constraints.xywh(4, 2, 3, 1));
//	m_SearchPanel.add (m_SearchStatus,   l_Constraints.xywh(6, 2, 1, 1));
	}

//---------------------------------------------------------------------------	

private void buildLoadPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();
	
	m_LoadBorder = new TitledBorder (Translatrix.getTranslationString("InvoiceSearchDialog.LoadBorder"));

	m_LoadPanel = new JPanel ();
	m_LoadPanel.setBorder(m_LoadBorder);
	
	l_Layout = new FormLayout(c_LoadPanelColumns, c_LoadPanelRows);
	m_LoadPanel.setLayout (l_Layout);
	m_LoadPanel.setOpaque (false);
	
	m_LoadStep = new JLabel ();
	m_LoadStep.setIcon(BillingModule.getIconResource("step2_disabled.png"));
	m_LoadStep.setText(null);
	m_LoadStep.setToolTipText(null);

	m_LoadButton = new JButton (Translatrix.getTranslationString("InvoiceSearchDialog.LoadButton"));
	m_LoadButton.setIcon (BillingModule.getIconResource("load_invoices.png"));
	m_LoadButton.addActionListener(this);
	m_LoadButton.setEnabled(false);
	
	m_LoadPanel.add (m_LoadStep,     	l_Constraints.xywh(2, 2, 1, 1));
	m_LoadPanel.add (m_LoadButton,   	l_Constraints.xywh(4, 2, 1, 1));
	}


//---------------------------------------------------------------------------	

private void setBackground (JComponent p_Component, boolean p_EnableIt)
	{
	if (p_EnableIt)
		 p_Component.setBackground (GECAMedColors.c_GECAMedDarkerBackground);
	else p_Component.setBackground (GECAMedColors.c_GECAMedBackground);
//	p_Component.repaint();
	}

//---------------------------------------------------------------------------	
//===========================================================================
//= Panel Enabling
//===========================================================================
//---------------------------------------------------------------------------	

private void enablePhysicianPanel (boolean p_EnableIt)
	{
	this.setBackground (m_PhysicianPanel,p_EnableIt);
	m_PhysicianList.setEnabled(p_EnableIt);
	m_PhysicianScroller.getVerticalScrollBar().setEnabled(p_EnableIt);	
	m_SearchActs.setEnabled (p_EnableIt);
	this.setBackground(m_SearchActs,p_EnableIt);
	
	if (!p_EnableIt)
		{
		m_PhysicianList.clearSelection();
		m_SearchActs.setSelected(false);
		}
	}

//---------------------------------------------------------------------------	

private void enableMedPresPanel (boolean p_EnableIt)
{
this.setBackground (m_MedPresPanel,p_EnableIt);
m_MedPresList.setEnabled(p_EnableIt);
m_MedPresScroller.getVerticalScrollBar().setEnabled(p_EnableIt);	

if (!p_EnableIt)
	{
	m_PhysicianList.clearSelection();
	}
}

//---------------------------------------------------------------------------	

private void enableInsurancePanel (boolean p_EnableIt)
	{
	this.setBackground (m_InsurancePanel,p_EnableIt);
	m_HealthInsurancesLabel.setEnabled(p_EnableIt);
	m_ThirdPartyPayersLabel.setEnabled(p_EnableIt);	
	m_HealthInsuranceList.setEnabled(p_EnableIt);
	m_HealthInsuranceScroller.getVerticalScrollBar().setEnabled(p_EnableIt);
	m_ThirdPartyPayerList.setEnabled(p_EnableIt);
	m_ThirdPartyPayerScroller.getVerticalScrollBar().setEnabled(p_EnableIt);
	m_NotThirdParty.setEnabled(p_EnableIt);
	this.setBackground(m_NotThirdParty,p_EnableIt);
	
	if (!p_EnableIt)
		{
		m_HealthInsuranceList.clearSelection();
		m_ThirdPartyPayerList.clearSelection();
		m_NotThirdParty.setSelected(false);
		}
	}

//---------------------------------------------------------------------------	

private void enableInvoiceDatePanel (boolean p_EnableIt)
	{
	Date l_Today;
	
	this.setBackground (m_InvoiceDatePanel,p_EnableIt);

	m_InvoiceFromDateLabel.setEnabled(p_EnableIt);
	m_InvoiceUntilDateLabel.setEnabled(p_EnableIt);	
	m_InvoiceFromDate.setEnabled(p_EnableIt);
	m_InvoiceUntilDate.setEnabled(p_EnableIt);
	
	if (p_EnableIt == false)
		{
		m_InvoiceFromDate.setDate(null);
		m_InvoiceUntilDate.setDate(null);
		}
	else
		{
		l_Today = new Date ();
		m_InvoiceFromDate.setDate(l_Today);
		m_InvoiceUntilDate.setDate(null);
		}
	}

//---------------------------------------------------------------------------	

private void enableHospitalisationClassPanel (boolean p_EnableIt)
	{
	this.setBackground (m_HospitalisationClassPanel,p_EnableIt);
	m_HospitalisationClassList.setEnabled(p_EnableIt);
	m_HospitalisationClassScroller.getVerticalScrollBar().setEnabled(p_EnableIt);	
	
	if (!p_EnableIt)
		{
		m_HospitalisationClassList.clearSelection();
		}
	}

//---------------------------------------------------------------------------	

private void enableStatePanel (boolean p_EnableIt)
	{
	this.setBackground (m_StatePanel,p_EnableIt);

	m_States.setEnabled(p_EnableIt);
	m_WithDeduction.setEnabled (p_EnableIt);
	m_PartialSettlement.setEnabled(p_EnableIt);
	
	if (!p_EnableIt) m_States.reset();
	}

//---------------------------------------------------------------------------	

private void enableSettlementDatePanel (boolean p_EnableIt)
	{
	Date l_Today;
	
	this.setBackground (m_SettlementDatePanel,p_EnableIt);

	m_SettlementFromDateLabel.setEnabled(p_EnableIt);
	m_SettlementUntilDateLabel.setEnabled(p_EnableIt);	
	m_SettlementFromDate.setEnabled(p_EnableIt);
	m_SettlementUntilDate.setEnabled(p_EnableIt);
	
	if (p_EnableIt == false)
		{
		m_SettlementFromDate.setDate(null);
		m_SettlementUntilDate.setDate(null);
		}
	else
		{
		l_Today = new Date ();
		m_SettlementFromDate.setDate(l_Today);
		m_SettlementUntilDate.setDate(null);
		}
	}

//---------------------------------------------------------------------------

private void enableReminderDatePanel (boolean p_EnableIt)
{
Date l_Today;

this.setBackground (m_ReminderDatePanel,p_EnableIt);

m_ReminderFromDateLabel.setEnabled(p_EnableIt);
m_ReminderUntilDateLabel.setEnabled(p_EnableIt);	
m_ReminderFromDate.setEnabled(p_EnableIt);
m_ReminderUntilDate.setEnabled(p_EnableIt);

if (p_EnableIt == false)
	{
	m_ReminderFromDate.setDate(null);
	m_ReminderUntilDate.setDate(null);
	}
else
	{
	l_Today = new Date ();
	m_ReminderFromDate.setDate(l_Today);
	m_ReminderUntilDate.setDate(null);
	}
}

//---------------------------------------------------------------------------	

private void enableDueDatePanel (boolean p_EnableIt)
{
Date l_Today;

this.setBackground (m_DueDatePanel,p_EnableIt);

m_DueFromDateLabel.setEnabled(p_EnableIt);
m_DueUntilDateLabel.setEnabled(p_EnableIt);	
m_DueFromDate.setEnabled(p_EnableIt);
m_DueUntilDate.setEnabled(p_EnableIt);

if (p_EnableIt == false)
	{
	m_DueFromDate.setDate(null);
	m_DueUntilDate.setDate(null);
	}
else
	{
	l_Today = new Date ();
	m_DueFromDate.setDate(l_Today);
	m_DueUntilDate.setDate(null);
	}
}

//---------------------------------------------------------------------------	

private void enableEndDatePanel (boolean p_EnableIt)
{
Date l_Today;

this.setBackground (m_EndDatePanel,p_EnableIt);

m_EndFromDateLabel.setEnabled(p_EnableIt);
m_EndUntilDateLabel.setEnabled(p_EnableIt);	
m_EndFromDate.setEnabled(p_EnableIt);
m_EndUntilDate.setEnabled(p_EnableIt);

if (p_EnableIt == false)
	{
	m_EndFromDate.setDate(null);
	m_EndUntilDate.setDate(null);
	}
else
	{
	l_Today = new Date ();
	m_EndFromDate.setDate(l_Today);
	m_EndUntilDate.setDate(null);
	}
}

//---------------------------------------------------------------------------	


private void enableEmissionDatePanel (boolean p_EnableIt)
{
Date l_Today;

this.setBackground (m_EmissionDatePanel,p_EnableIt);

m_EmissionFromDateLabel.setEnabled(p_EnableIt);
m_EmissionUntilDateLabel.setEnabled(p_EnableIt);	
m_EmissionFromDate.setEnabled(p_EnableIt);
m_EmissionUntilDate.setEnabled(p_EnableIt);

if (p_EnableIt == false)
	{
	m_EmissionFromDate.setDate(null);
	m_EmissionUntilDate.setDate(null);
	}
else
	{
	l_Today = new Date ();
	m_EmissionFromDate.setDate(l_Today);
	m_EmissionUntilDate.setDate(null);
	}
}

//---------------------------------------------------------------------------	

private void enableSettlementPanel (boolean p_EnableIt)
	{
	this.setBackground (m_SettlementPanel,p_EnableIt);
	m_PaymentList.setEnabled(p_EnableIt);
	m_PaymentScroller.getVerticalScrollBar().setEnabled(p_EnableIt);	
	m_AccountList.setEnabled(p_EnableIt);
	m_AccountScroller.getVerticalScrollBar().setEnabled(p_EnableIt);	
	m_AccountRenderer.setEnabled(p_EnableIt);
	
	if (!p_EnableIt)
		{
		m_PaymentList.clearSelection();
		m_AccountList.clearSelection();
		}
	}

//---------------------------------------------------------------------------	
//===========================================================================
//= Search Expressions
//===========================================================================
//---------------------------------------------------------------------------	

private Group getPhysicianSearchExpression ()
	{
	int[]				l_SelectedIndices;
	Physician			l_Physician;
	Group				l_SearchExpression 		= null;
	HibernateCondition	l_Condition 			= null;
	
	HibernateSubSelect			l_ActSubSelect			= null;
	WhereClause			l_SubSelectClause		= null;
	Group				l_SubSelectExpression 	= null;
	
	int					l_Index;
	
	if (m_SearchByPhysician.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_OrOperator);
		
		l_SelectedIndices = m_PhysicianList.getSelectedIndices();
		if (l_SelectedIndices != null)
			{
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Physician = m_Physicians.getElementAt(l_SelectedIndices[l_Index]);
				
				l_Condition = new HibernateCondition ("physician.id",
													  HibernateOperator.c_EqualOperator,
													  l_Physician.getId());
					
				l_SearchExpression.addCondition (l_Condition);
				}			
			}
		
		if (m_SearchActs.isSelected ())
			{
			l_SubSelectExpression = new Group (HibernateOperator.c_OrOperator);
			
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Physician = m_Physicians.getElementAt (l_SelectedIndices[l_Index]);
				
				l_Condition = new HibernateCondition ("physicianId",
													  HibernateOperator.c_EqualOperator,
													  l_Physician.getId());
				
				l_Condition.setEntity ("a");
				l_SubSelectExpression.addCondition (l_Condition);
				}			
			
			l_SubSelectClause = new WhereClause ();
			l_SubSelectClause.addGroup(l_SubSelectExpression);
			
			l_ActSubSelect = new HibernateSubSelect ("invoiceId","Act",l_SubSelectClause);
			l_ActSubSelect.setEntity("a");
			
			l_Condition = new HibernateCondition ("id",
												  HibernateOperator.c_InOperator,
												  l_ActSubSelect);
					
			l_SearchExpression.addCondition (l_Condition);
			}
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

@SuppressWarnings("unchecked")
private Group getMedPresSearchExpression ()
{
List<MedPres>		l_SelectedIndices;
Group				l_SearchExpression 		= null;
HibernateCondition	l_Condition 			= null;

if (m_SearchByMedPres.isSelected())
	{
	l_SearchExpression = new Group (HibernateOperator.c_OrOperator);
	
	l_SelectedIndices = m_MedPresList.getSelectedValuesList();
	if (l_SelectedIndices != null)
		{
		Group l_SubSelectExpression = new Group (HibernateOperator.c_OrOperator);
		
		for (MedPres medPres : l_SelectedIndices) {
			l_Condition = new HibernateCondition ("medPrescCode",
												  HibernateOperator.c_EqualOperator,
												  medPres.getUcm());
			l_Condition.setEntity ("a");
			l_SubSelectExpression.addCondition (l_Condition);
		}			
		
		l_SubSelectClause = new WhereClause ();
		l_SubSelectClause.addGroup(l_SubSelectExpression);
		
		HibernateSubSelect l_ActSubSelect = new HibernateSubSelect ("invoiceId","Act",l_SubSelectClause);
		l_ActSubSelect.setEntity("a");
		
		l_Condition = new HibernateCondition ("id",
											  HibernateOperator.c_InOperator,
											  l_ActSubSelect);
				
		l_SearchExpression.addCondition (l_Condition);
	}
	}
return l_SearchExpression;
}

//---------------------------------------------------------------------------

private Group getInsuranceSearchExpression ()
	{
	int[]				l_SelectedIndices;
	Insurance			l_Insurance;
	Group				l_SearchExpression 		= null;
	Group				l_InsuranceExpression   = null;
	Group				l_ThirdPartyExpression  = null;
	HibernateCondition	l_Condition 			= null;
	int					l_Index;
	
	if (m_SearchByInsurance.isSelected())
		{
		l_SearchExpression     = new Group (HibernateOperator.c_AndOperator);
		l_InsuranceExpression  = new Group (HibernateOperator.c_OrOperator);
		l_ThirdPartyExpression = new Group (HibernateOperator.c_OrOperator);
		
		l_SelectedIndices = m_HealthInsuranceList.getSelectedIndices();
		if (l_SelectedIndices != null) 
			{
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Insurance = m_HealthInsurances.getElementAt(l_SelectedIndices[l_Index]);
				
				l_Condition = new HibernateCondition ("healthInsurance.id",
													  HibernateOperator.c_EqualOperator,
													  l_Insurance.getId());
				
				l_InsuranceExpression.addCondition (l_Condition);
				}			
			}
		
		l_SelectedIndices = m_ThirdPartyPayerList.getSelectedIndices();
		if ((l_SelectedIndices != null) && (l_SelectedIndices.length > 0))
			{
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Insurance = m_ThirdPartyPayers.getElementAt(l_SelectedIndices[l_Index]);
				
				l_Condition = new HibernateCondition ("thirdPartyPayer.id",
													  HibernateOperator.c_EqualOperator,
													  l_Insurance.getId());
				
				l_ThirdPartyExpression.addCondition (l_Condition);
				}			
			}
		else if (m_NotThirdParty.isSelected())
			{
			l_Condition = new HibernateCondition ("thirdPartyPayer.id",
												  HibernateOperator.c_IsOperator,
												  null);
						
			l_ThirdPartyExpression.addCondition (l_Condition);

			l_Condition = new HibernateCondition ("thirdPartyPayer.id",
												  HibernateOperator.c_EqualOperator,
												  0);
			l_ThirdPartyExpression.addCondition (l_Condition);
			}
		
		l_SearchExpression.addGroup (l_InsuranceExpression);
		l_SearchExpression.addGroup (l_ThirdPartyExpression);	
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

private Group getInvoiceDateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	
	if (m_SearchByInvoiceDate.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_InvoiceFromDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("invoiceDate",
												  HibernateOperator.c_GreaterOrEqualOperator, 
												  BillingModule.earliestOfDay(this.getInvoiceFromDate()));
			
			
			
			l_Condition.setParameter("invoiceFromDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		
		if (m_InvoiceUntilDate.getDate() != null)
			{
			
			l_Condition = new HibernateCondition ("invoiceDate",
												  HibernateOperator.c_LowerOrEqualOperator,
												  BillingModule.latestOfDay(this.getInvoiceUntilDate()));
			
			l_Condition.setParameter("invoiceUntilDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

private Group getInvoiceStateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	Group				l_StateExpression	= null;
	Group				l_PaymentExpression	= null;
	HibernateCondition	l_Condition 		= null;
	
	Collection <Integer>	l_States; 
	Iterator   <Integer>	l_StateIterator;
	Integer					l_State;
	
	if (m_SearchByState.isSelected())
		{
		l_StateExpression = new Group (HibernateOperator.c_OrOperator);
		
		l_States = m_States.getChosenStates();

		l_StateIterator = l_States.iterator();
		while (l_StateIterator.hasNext())
			{
			l_State = l_StateIterator.next();
			
			l_Condition = new HibernateCondition ("state",
												  HibernateOperator.c_EqualOperator,
												  l_State);
			
			
			l_StateExpression.addCondition (l_Condition);
			}
		
		l_PaymentExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_WithDeduction.isSelected())
			{
			
			l_Condition = new HibernateCondition ("deduction",
												  HibernateOperator.c_GreaterThanOperator,
												  Double.valueOf(0f));
			
			l_PaymentExpression.addCondition (l_Condition);
			}
		
		if (m_PartialSettlement.isSelected())
			{
			
			l_Condition = new HibernateCondition ("payment",
												  HibernateOperator.c_GreaterThanOperator,
												  Double.valueOf(0f));
			
			l_PaymentExpression.addCondition (l_Condition);
			
			l_Condition = new HibernateCondition ("balance",
												  HibernateOperator.c_GreaterThanOperator,
												  Double.valueOf(0f));
			
			l_PaymentExpression.addCondition (l_Condition);
			}

		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		l_SearchExpression.addGroup(l_StateExpression);
		l_SearchExpression.addGroup(l_PaymentExpression);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

private Group getHospitalisationClassSearchExpression ()
	{
	int[]					l_SelectedIndices;
	HospitalisationClass	l_Class;
	Group					l_SearchExpression 	= null;
	HibernateCondition		l_Condition 		= null;
	int						l_Index;
	
	if (m_SearchByHospitalisationClass.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_OrOperator);
		
		l_SelectedIndices = m_HospitalisationClassList.getSelectedIndices();
		if (l_SelectedIndices != null)
			{
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Class = m_HospitalisationClasses.getElementAt(l_SelectedIndices[l_Index]);
				
				l_Condition = new HibernateCondition ("hospitalisationClass.id",
													  HibernateOperator.c_EqualOperator,
													  l_Class.getId());
					
				l_SearchExpression.addCondition (l_Condition);
				}			
			}
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

private Group getSettlementDateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	
	if (m_SearchBySettlementDate.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_SettlementFromDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("settlementDate",
												  HibernateOperator.c_GreaterOrEqualOperator,
												  BillingModule.earliestOfDay(this.getSettlementFromDate()));

			l_Condition.setParameter("settlementFromDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		
		if (m_SettlementUntilDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("settlementDate",
												  HibernateOperator.c_LowerOrEqualOperator,
												  BillingModule.latestOfDay(this.getSettlementUntilDate()));
			
			l_Condition.setParameter("settlementUntilDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

private Group getReminderDateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	
	if (m_SearchByReminderDate.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_ReminderFromDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("reminderDate",
												  HibernateOperator.c_GreaterOrEqualOperator,
												  BillingModule.earliestOfDay(this.getReminderFromDate()));

			l_Condition.setParameter("reminderFromDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		
		if (m_ReminderUntilDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("reminderDate",
												  HibernateOperator.c_LowerOrEqualOperator,
												  BillingModule.latestOfDay(this.getReminderUntilDate()));
			
			l_Condition.setParameter("reminderUntilDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	


private Group getDueDateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	
	if (m_SearchByDueDate.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_DueFromDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("dueDate",
												  HibernateOperator.c_GreaterOrEqualOperator,
												  BillingModule.earliestOfDay(this.getDueFromDate()));

			l_Condition.setParameter("dueFromDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		
		if (m_DueUntilDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("dueDate",
												  HibernateOperator.c_LowerOrEqualOperator,
												  BillingModule.latestOfDay(this.getDueUntilDate()));
			
			l_Condition.setParameter("dueUntilDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	


private Group getEndDateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	
	if (m_SearchByEndDate.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_EndFromDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("closureDate",
												  HibernateOperator.c_GreaterOrEqualOperator,
												  BillingModule.earliestOfDay(this.getEndFromDate()));

			l_Condition.setParameter("closureFromDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		
		if (m_EndUntilDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("closureDate",
												  HibernateOperator.c_LowerOrEqualOperator,
												  BillingModule.latestOfDay(this.getEndUntilDate()));
			
			l_Condition.setParameter("closureUntilDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	


private Group getEmissionDateSearchExpression ()
	{
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	
	if (m_SearchByEmissionDate.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_AndOperator);
		
		if (m_EmissionFromDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("printDate",
												  HibernateOperator.c_GreaterOrEqualOperator,
												  BillingModule.earliestOfDay(this.getEmissionFromDate()));

			l_Condition.setParameter("printFromDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		
		if (m_EmissionUntilDate.getDate() != null)
			{
			l_Condition = new HibernateCondition ("printDate",
												  HibernateOperator.c_LowerOrEqualOperator,
												  BillingModule.latestOfDay(this.getEmissionUntilDate()));
			
			l_Condition.setParameter("printUntilDate");
			}
		
		l_SearchExpression.addCondition (l_Condition);
		}
	
	return l_SearchExpression;
	}

//---------------------------------------------------------------------------	

private Group getSettlementSearchExpression ()
	{
	int[]				l_SelectedIndices;
	Payment				l_Payment;
	Account				l_Account;
	Integer				l_SettlementId;
	Group				l_SearchExpression 	= null;
	HibernateCondition	l_Condition 		= null;
	int					l_Index;
	
	if (m_SearchBySettlement.isSelected())
		{
		l_SearchExpression = new Group (HibernateOperator.c_OrOperator);
		
		l_SelectedIndices = m_PaymentList.getSelectedIndices();
		if (l_SelectedIndices != null) 
			{
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Payment = m_Payments.getElementAt(l_SelectedIndices[l_Index]);
				l_SettlementId = m_PaymentLookup.get(l_Payment);
				
				l_Condition = new HibernateCondition ("settlement.id",
													  HibernateOperator.c_EqualOperator,
													  l_SettlementId);
				
				l_SearchExpression.addCondition (l_Condition);
				}			
			}
		
		l_SelectedIndices = m_AccountList.getSelectedIndices();
		if (l_SelectedIndices != null) 
			{
			for (l_Index = 0; l_Index < l_SelectedIndices.length; l_Index++)
				{
				l_Account = m_Accounts.getElementAt(l_SelectedIndices[l_Index]);
				l_SettlementId = m_AccountLookup.get (l_Account);
				
				l_Condition = new HibernateCondition ("settlement.id",
													  HibernateOperator.c_EqualOperator,
													  l_SettlementId);
				
				l_SearchExpression.addCondition (l_Condition);
				}			
			}
		}
	
	return l_SearchExpression;
	}	

//---------------------------------------------------------------------------	

private Group getSplitBillingDiscriminator ()
	{
	Group				l_SearchDiscriminator   = null;
	HibernateCondition	l_Condition 			= null;
	Physician			l_CurrentPhysician  	= null;

	l_CurrentPhysician = BillingModule.getCurrentPhysician();
	if ((l_CurrentPhysician == null) || (!l_CurrentPhysician.isPersistent())) return null;
	
	l_SearchDiscriminator = new Group (HibernateOperator.c_AndOperator);
	
	l_Condition = new HibernateCondition ("physician.id",
										   HibernateOperator.c_EqualOperator,
										   l_CurrentPhysician.getId());
	
	l_SearchDiscriminator.addCondition(l_Condition);
	
	return l_SearchDiscriminator;
	}

//---------------------------------------------------------------------------	

private void assembleWhereClause ()
	{
	Group		l_SearchExpression;

	m_WhereClause = new WhereClause();
	m_WhereClause.setOperator(HibernateOperator.c_AndOperator);
		
	l_SearchExpression = this.getPhysicianSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getInsuranceSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getInvoiceDateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getInvoiceStateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	if ((Boolean)BillingModule.getSetting(BillingAdminSettings.c_HospitalisationSetting))
		{
		l_SearchExpression = this.getHospitalisationClassSearchExpression();
		m_WhereClause.addGroup(l_SearchExpression);
		}
	
	l_SearchExpression = this.getSettlementDateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getEmissionDateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getEndDateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getDueDateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getReminderDateSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getSettlementSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	l_SearchExpression = this.getMedPresSearchExpression();
	m_WhereClause.addGroup(l_SearchExpression);
	
	if (showOnlyInvoicesOfCurrentPhysician())
		{
		l_SearchExpression = this.getSplitBillingDiscriminator();
		m_WhereClause.addGroup(l_SearchExpression);
		}
	
	m_Logger.info(m_WhereClause.toString());
	}

//---------------------------------------------------------------------------
/**
 * The private getInvoiceInterface returns an instance of the InvoiceBean
 * session bean. On the first call, the InvoiceBean will actualy be looked up
 * via JNDI. Once it has been found, the reference to the bean will be stored
 * in a private data member. Doing so avoids JNDI lookups on later calls.
 * @return an instance of the InvoiceBean session bean.
 */
//---------------------------------------------------------------------------

private InvoiceInterface getInvoiceInterface ()
	{
	if (m_InvoiceInterface != null) return m_InvoiceInterface;

	try {
		m_InvoiceInterface = (InvoiceInterface) ManagerFactory.getRemote(InvoiceBean.class);
		} 
	catch (Exception p_Exception) 
		{
		m_Logger.warn(p_Exception.getLocalizedMessage());
		}

	return m_InvoiceInterface;
	}

//---------------------------------------------------------------------------	

private void getInvoiceCount ()
	{
	InvoiceInterface l_Interface;
	
	l_Interface = this.getInvoiceInterface();
	
	if (l_Interface == null) return;
	
	if (m_WhereClause == null) this.assembleWhereClause();
	
	try {
		m_InvoiceCount = l_Interface.getInvoiceCountByWhereClause (m_WhereClause);
		} 
	catch (Exception p_Exception) 
		{
		m_Logger.log(Level.ERROR, "Failed to get count of invoices!", p_Exception);
		}
	
	}

//---------------------------------------------------------------------------	
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public void populateInsurances (Collection <Insurance> p_Insurances)
	{
	Iterator <Insurance> 	l_InsuranceIterator;
	Insurance			 	l_Insurance;
	Collection <Insurance>	l_PrimaryInsurances;
	Collection <Insurance>	l_ThirdPartyInsurances;
	
	if (p_Insurances == null) return;
	
	l_PrimaryInsurances = new ArrayList <Insurance> ();
	l_ThirdPartyInsurances = new ArrayList <Insurance> ();
		
	l_InsuranceIterator = p_Insurances.iterator();
	while (l_InsuranceIterator.hasNext())
		{
		l_Insurance = l_InsuranceIterator.next();
		if (l_Insurance.getId() == 0) continue;
		
		if (l_Insurance.getPrimary()) l_PrimaryInsurances.add(l_Insurance);
		if (l_Insurance.getThirdParty()) l_ThirdPartyInsurances.add (l_Insurance);
		}
	
	m_HealthInsurances.setInsurances(l_PrimaryInsurances);
	m_ThirdPartyPayers.setInsurances(l_ThirdPartyInsurances);
	}

//---------------------------------------------------------------------------	

public void populateSettlementMethods (Collection <Settlement> p_Settlements)
	{
	Iterator <Settlement> 	l_SettlementIterator;
	Settlement				l_SettlementMethod;
	Collection <Payment> 	l_Payments;
	Collection <Account> 	l_Accounts;
		
	if (p_Settlements == null) return;
	
	l_Payments  = new ArrayList <Payment> ();
	l_Accounts  = new ArrayList <Account> ();
	
	m_PaymentLookup = new Hashtable <Payment,Integer> ();
	m_AccountLookup = new Hashtable <Account,Integer> ();
	
	l_SettlementIterator = p_Settlements.iterator();
	while (l_SettlementIterator.hasNext())
		{
		l_SettlementMethod = l_SettlementIterator.next();
		switch (l_SettlementMethod.getSettlementMethod())
			{
			case Settlement.c_Payment:
				
				l_Payments.add(l_SettlementMethod.getPayment());
				m_PaymentLookup.put(l_SettlementMethod.getPayment(), l_SettlementMethod.getId());
				break;
			
			case Settlement.c_Transfer:
				
				l_Accounts.add(l_SettlementMethod.getTransferAccount());
				m_AccountLookup.put(l_SettlementMethod.getTransferAccount(), l_SettlementMethod.getId());
				break;
			}
		}
	
	m_Payments.setPayments(l_Payments);
	m_Accounts.setAccounts(l_Accounts);
	
	// the component stretches itself, when empty - this is to avoid that
	m_PaymentScroller.getViewport().setView(l_Payments.isEmpty() ? null : m_PaymentList);
	m_AccountScroller.getViewport().setView(l_Accounts.isEmpty() ? null : m_AccountList);
	}

//---------------------------------------------------------------------------	

public void setVisible (boolean p_ShowIt)
	{
	if ((p_ShowIt) && (showOnlyInvoicesOfCurrentPhysician()))
		{
		this.enablePhysicianPanel(false);
		m_SearchByPhysician.setSelected(false);
		m_SearchByPhysician.setEnabled(false);
		m_PhysicianList.setSelectedValue(BillingModule.getCurrentPhysician(), true);
		}
	super.setVisible(p_ShowIt);
	}

//---------------------------------------------------------------------------	

public void itemStateChanged(ItemEvent p_ItemEvent) 
	{
	boolean l_EnableIt;
	
	l_EnableIt = (p_ItemEvent.getStateChange() == ItemEvent.SELECTED)?true:false; 
	
	if (p_ItemEvent.getSource().equals (m_SearchByPhysician))
		{
		this.enablePhysicianPanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_SearchByInsurance))
		{
		this.enableInsurancePanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_NotThirdParty))
		{
		if (l_EnableIt) m_ThirdPartyPayerList.clearSelection();	
		}
	else if (p_ItemEvent.getSource().equals (m_SearchByInvoiceDate))
		{
		this.enableInvoiceDatePanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_SearchByState))
		{
		this.enableStatePanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_SearchByHospitalisationClass))
		{
		this.enableHospitalisationClassPanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_SearchBySettlementDate))
		{
		this.enableSettlementDatePanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_SearchBySettlement))
		{
		this.enableSettlementPanel(l_EnableIt);
		}
	else if (p_ItemEvent.getSource().equals (m_SearchByDueDate))
	{
		this.enableDueDatePanel(l_EnableIt);
	}
	else if (p_ItemEvent.getSource().equals (m_SearchByEmissionDate))
	{
		this.enableEmissionDatePanel(l_EnableIt);
	}
	else if (p_ItemEvent.getSource().equals (m_SearchByEndDate))
	{
		this.enableEndDatePanel(l_EnableIt);
	}
	else if (p_ItemEvent.getSource().equals (m_SearchByReminderDate))
	{
		this.enableReminderDatePanel(l_EnableIt);
	}
	else if (p_ItemEvent.getSource().equals (m_SearchByMedPres))
	{
		this.enableMedPresPanel(l_EnableIt);
	}

	}

//---------------------------------------------------------------------------	

public void valueChanged (ListSelectionEvent p_Event) 
	{
	if (p_Event.getSource().equals(m_PaymentList))
		{
		m_AccountList.clearSelection();
		}
	else if (p_Event.getSource().equals(m_AccountList))
		{
		m_PaymentList.clearSelection();
		}
	else if (p_Event.getSource().equals(m_ThirdPartyPayerList))
		{
		if (m_ThirdPartyPayerList.getSelectedIndex() > 0) m_NotThirdParty.setSelected (false);			
		}
	}

//---------------------------------------------------------------------------	

public void propertyChange(PropertyChangeEvent p_Event) 
	{
	Date				l_StartDate;
	Date				l_EndDate;
	
	if (   (p_Event.getSource().equals(m_InvoiceFromDate))
		&& ("date".equals(p_Event.getPropertyName()))) 
		{
		l_StartDate = this.getInvoiceFromDate();
		l_EndDate   = this.getInvoiceUntilDate();
		
		if (l_StartDate == null) return;
		
		if ((l_EndDate == null) && (BillingModule.isFirstOfMonth(l_StartDate)))
			l_EndDate = BillingModule.lastOfMonth(l_StartDate);
		
		m_InvoiceFromDate.removePropertyChangeListener(this);
		m_InvoiceUntilDate.removePropertyChangeListener(this);
		
		m_InvoiceFromDate.setDate (l_StartDate);
		m_InvoiceUntilDate.setDate (l_EndDate);
		
		m_InvoiceFromDate.addPropertyChangeListener(this);
		m_InvoiceUntilDate.addPropertyChangeListener(this);

		this.repaint();
		}
	
	else if (   (p_Event.getSource().equals(m_InvoiceUntilDate))
		&& ("date".equals(p_Event.getPropertyName()))) 
		{
		l_StartDate = this.getInvoiceFromDate();
		l_EndDate   = this.getInvoiceUntilDate();
		
		if (l_EndDate == null) return;
		
		if (l_StartDate == null) l_StartDate = BillingModule.firstOfMonth(l_EndDate);
		
		m_InvoiceFromDate.removePropertyChangeListener(this);
		m_InvoiceUntilDate.removePropertyChangeListener(this);
		
		m_InvoiceFromDate.setDate (l_StartDate);
		m_InvoiceUntilDate.setDate (l_EndDate);
		
		m_InvoiceFromDate.addPropertyChangeListener(this);
		m_InvoiceUntilDate.addPropertyChangeListener(this);

		this.repaint();
		}

	else if (   (p_Event.getSource().equals(m_SettlementFromDate))
		&& ("date".equals(p_Event.getPropertyName()))) 
		{
		l_StartDate = this.getSettlementFromDate();
		l_EndDate   = this.getSettlementUntilDate();
		
		if (l_StartDate == null) return;
		
		if ((l_EndDate == null) && (BillingModule.isFirstOfMonth(l_StartDate)))
			l_EndDate = BillingModule.lastOfMonth(l_StartDate);
		
		m_SettlementFromDate.removePropertyChangeListener(this);
		m_SettlementUntilDate.removePropertyChangeListener(this);
		
		m_SettlementFromDate.setDate (l_StartDate);
		m_SettlementUntilDate.setDate (l_EndDate);
		
		m_SettlementFromDate.addPropertyChangeListener(this);
		m_SettlementUntilDate.addPropertyChangeListener(this);

		this.repaint();
		}

	else if (   (p_Event.getSource().equals(m_SettlementUntilDate))
		&& ("date".equals(p_Event.getPropertyName()))) 
		{
		l_StartDate = this.getSettlementFromDate();
		l_EndDate   = this.getSettlementUntilDate();
		
		if (l_EndDate == null) return;
		
		if (l_StartDate == null) l_StartDate = BillingModule.firstOfMonth(l_EndDate);
		
		m_SettlementFromDate.removePropertyChangeListener(this);
		m_SettlementUntilDate.removePropertyChangeListener(this);
		
		m_SettlementFromDate.setDate (l_StartDate);
		m_SettlementUntilDate.setDate (l_EndDate);
		
		m_SettlementFromDate.addPropertyChangeListener(this);
		m_SettlementUntilDate.addPropertyChangeListener(this);

		this.repaint();
		}
	}

//---------------------------------------------------------------------------	

public void actionPerformed (ActionEvent p_Event) 
	{
	String [] 	l_Filler;
	Integer		l_Ceiling;
	int			l_UserChoice;
	
	if (p_Event.getSource().equals (m_SearchButton))
		{
		this.assembleWhereClause();
		this.getInvoiceCount();
		
		l_Filler = new String [1];
		l_Filler [0] = (m_InvoiceCount != null) ? m_InvoiceCount.toString():"0";
		
		m_SearchButton.setText(
				Translatrix.getTranslationString("InvoiceSearchDialog.SearchButton") + ": "  + 
				Translatrix.getTranslationString("InvoiceSearchDialog.Found",l_Filler));
		
		
		if ((m_InvoiceCount != null) && (m_InvoiceCount.longValue() > 0))
			{
			m_LoadStep.setIcon(BillingModule.getIconResource("step2.png"));
			m_LoadStep.setEnabled(true);
			m_LoadButton.setEnabled(true);
			}
		}
	else if (p_Event.getSource().equals (m_LoadButton))
		{
		l_Ceiling = (Integer)BillingModule.getSetting(BillingAdminSettings.c_MaxInvoicesSetting);
		if (m_InvoiceCount > l_Ceiling)
			{
			l_Filler = new String [2];
			l_Filler [0] = m_InvoiceCount.toString();
			l_Filler [1] = l_Ceiling.toString();

			l_UserChoice = BillingModule.getUserConfirmation ("InvoiceSearchDialog.MaxInvoicesTitle", 
									 	       				  "InvoiceSearchDialog.MaxInvoicesMessage", 
									 	       				  l_Filler);
			
			if (l_UserChoice == JOptionPane.OK_OPTION) 
				{
				m_Validated = true;
				this.setVisible (false);
				}
			}
		else 
			{
			m_Validated = true;
			this.setVisible (false);
			}
		}
	else if (p_Event.getSource().equals (m_CancelButton))
		{
		m_Validated = false;
		this.setVisible(false);
		}
	}
	
//---------------------------------------------------------------------------	

public WhereClause getWhereClause ()
	{
	return m_WhereClause;
	}

//---------------------------------------------------------------------------	

public boolean wasValidated ()
	{
	return m_Validated;
	}

//---------------------------------------------------------------------------	

public void relocalize() 
	{
	if (m_SearchByPhysician != null)	
		m_SearchByPhysician.setText (Translatrix.getTranslationString("InvoiceSearchDialog.PhysiciansSwitch"));
 
	if (m_SearchActs != null)	
		m_SearchActs.setText (Translatrix.getTranslationString("InvoiceSearchDialog.SearchActs"));

	if (m_SearchByInsurance != null)
		m_SearchByInsurance.setText (Translatrix.getTranslationString("InvoiceSearchDialog.InsuranceSwitch"));
	
	if (m_HealthInsurancesLabel != null)	
		m_HealthInsurancesLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.HealthInsurancesLabel"));
	
	if (m_ThirdPartyPayersLabel != null)	
		m_ThirdPartyPayersLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.ThirdPartyPayersLabel"));

	if (m_NotThirdParty != null)
		m_NotThirdParty.setText (Translatrix.getTranslationString("InvoiceSearchDialog.NotThirdParty"));

	
	if (m_SearchByInvoiceDate != null)	
		m_SearchByInvoiceDate.setText (Translatrix.getTranslationString("InvoiceSearchDialog.InvoiceDateSwitch"));
	
	if (m_InvoiceFromDateLabel != null)	
		m_InvoiceFromDateLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.InvoiceFromDateLabel"));
	
//	if (m_InvoiceFromDate != null) 
//		{
//		m_InvoiceFromDate.setLocale (Translatrix.getLocale());
//		m_InvoiceFromDate.setDateFormatString("d MMMM yyyy");   
//		m_InvoiceFromDate.getDateEditor().setLocale (Translatrix.getLocale());
//		}
	
	if (m_InvoiceUntilDateLabel != null)	
		m_InvoiceUntilDateLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.InvoiceUntilDateLabel"));
	
//	if (m_InvoiceUntilDate != null) 
//		{
//		m_InvoiceUntilDate.setLocale (Translatrix.getLocale());
//		m_InvoiceUntilDate.setDateFormatString("d MMMM yyyy");   
//		m_InvoiceUntilDate.getDateEditor().setLocale (Translatrix.getLocale());
//		}

	if (m_SearchByState != null)
		m_SearchByState.setText (Translatrix.getTranslationString("InvoiceSearchDialog.StateSwitch"));

	if (m_WithDeduction != null)
		m_WithDeduction.setText (Translatrix.getTranslationString("InvoiceSearchDialog.WithDeduction")); 
 	
	if (m_PartialSettlement != null)
		m_PartialSettlement.setText (Translatrix.getTranslationString("InvoiceSearchDialog.PartialSettlement")); 

 	if (m_SearchBySettlementDate != null)	
		m_SearchBySettlementDate.setText (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementDateSwitch"));
	
	if (m_SettlementFromDateLabel != null)	
		m_SettlementFromDateLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementFromDateLabel"));
	
//	if (m_SettlementFromDate != null) 
//		{
//		m_SettlementFromDate.setLocale (Translatrix.getLocale());
//		m_SettlementFromDate.setDateFormatString("d MMMM yyyy");   
//		m_SettlementFromDate.getDateEditor().setLocale (Translatrix.getLocale());
//		}

	if (m_SettlementUntilDateLabel != null)	
		m_SettlementUntilDateLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.SettlementUntilDateLabel"));
	
//	if (m_SettlementUntilDate != null) 
//		{
//		m_SettlementUntilDate.setLocale (Translatrix.getLocale());
//		m_SettlementUntilDate.setDateFormatString("d MMMM yyyy");   
//		m_SettlementUntilDate.getDateEditor().setLocale (Translatrix.getLocale());
//		}

	if (m_SearchBySettlement != null)	
		m_SearchBySettlement.setText (Translatrix.getTranslationString("InvoiceSearchDialog.PaymentSwitch"));

	if (m_PaymentLabel != null)	
		m_PaymentLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.PaymentLabel"));

	if (m_AccountLabel != null)	
		m_AccountLabel.setText (Translatrix.getTranslationString("InvoiceSearchDialog.AccountLabel"));	
	
	if (m_SearchBorder != null)
		m_SearchBorder.setTitle (Translatrix.getTranslationString("InvoiceSearchDialog.SearchBorder"));

	if (m_SearchButton != null)
		m_SearchButton.setText (Translatrix.getTranslationString("InvoiceSearchDialog.SearchButton"));
	
	if (m_CancelButton != null)
		m_CancelButton.setText (Translatrix.getTranslationString("core.cancel"));
	}

public void handleGECAMedMessage(GECAMedMessage message) {
	if (MedPres.MEDPRES_CHANGED.equals(message.getMessage())) {
		updateMedTrans();
	}
}

@SuppressWarnings("unchecked")
private void updateMedTrans() {
	Collection<Contact> medPres = BillingModule.getInstance().prefetchMedPres();

	final ArrayList<MedPres> listData = new ArrayList<MedPres>(); 
	for (Contact contact : medPres) {
		MedPres mp = new MedPres(contact);
		listData.add(mp);
	}
	m_MedPresList.setModel(
            new AbstractListModel<MedPres>() {
				private static final long serialVersionUID = 1L;
				public int getSize() { return listData.size(); }
                public MedPres getElementAt(int i) { return listData.get(i); }
            }
	);
}


//---------------------------------------------------------------------------	
//***************************************************************************
//* End of Class				                            				*
//***************************************************************************
//---------------------------------------------------------------------------	
}
