/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.billing.gui.invoice.InvoiceListModel;
import lu.tudor.santec.gecamed.billing.gui.invoice.InvoiceNumberFormatter;
import lu.tudor.santec.gecamed.billing.gui.invoice.StateChooser;
import lu.tudor.santec.gecamed.billing.gui.invoice.StatementNumberFormatter;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader.SearchTableHeader;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.toedter.calendar.JDateChooser;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class InvoiceSearchTableHeader extends SearchTableHeader implements PropertyChangeListener,
																		   ActionListener,
																		   FocusListener,
																		   Relocalizable
	{
	private SimpleDateFormat    	m_DateFormat;
	
	private JButton					m_StateFilter;
	private StateChooser			m_StateChooser;
	
	private JFormattedTextField		m_InvoiceNumber;
	private	JDateChooser			m_DateChooser;
	private JFormattedTextField		m_StatementNumber;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public 	InvoiceSearchTableHeader (JTable p_Table)
	{
	super (p_Table);
	
	m_StateFilter   = new JButton ();
	m_StateFilter.setBorderPainted(false);
	m_StateFilter.addActionListener(this);
	m_StateFilter.addFocusListener (this);
	m_StateChooser  = new StateChooser (true);
	m_StateChooser.addPropertyChangeListener(this);
	
	m_InvoiceNumber = new JFormattedTextField (new InvoiceNumberFormatter(InvoiceNumberFormatter.c_ShortFormat));
	m_InvoiceNumber.addActionListener(this);
	m_InvoiceNumber.addKeyListener(this);
	
	m_DateChooser = GECAMedGuiUtils.getDateChooser(false);
	m_DateChooser.addPropertyChangeListener(this);
	m_DateChooser.setVerifyInputWhenFocusTarget(false);
	m_DateChooser.getDateEditor().addPropertyChangeListener(this);
	m_DateChooser.addKeyListener(this);
	
	m_StatementNumber = new JFormattedTextField (new StatementNumberFormatter());
	m_StatementNumber.addActionListener(this);
	m_StatementNumber.addKeyListener(this);
	
	this.relocalize();
	
//	this.setEnabled (InvoiceListModel.c_StatusColumn, true);
//	this.setMutualExclusive(InvoiceListModel.c_StatusColumn, false);
	
	this.setEnabled (InvoiceListModel.c_InvoiceNumberColumn, true);
	this.setMutualExclusive(InvoiceListModel.c_InvoiceNumberColumn, true);
	
	this.setEnabled (InvoiceListModel.c_InvoiceDateColumn,   true);
	this.setMutualExclusive (InvoiceListModel.c_InvoiceDateColumn,  true);
	
	this.setEnabled (InvoiceListModel.c_StatementColumn,   true);
	this.setMutualExclusive (InvoiceListModel.c_StatementColumn,  true);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

protected JComponent getEditingComponent (int p_Column)
	{	
	switch (p_Column)
		{
		case InvoiceListModel.c_StatusColumn:

			return m_StateFilter;

		case InvoiceListModel.c_InvoiceNumberColumn:
			
			m_InvoiceNumber.setValue (InvoiceNumberFormatter.c_EmptyFieldShort);
			return m_InvoiceNumber;

		case InvoiceListModel.c_InvoiceDateColumn:
			
			m_DateChooser.setDate(new Date());
			return m_DateChooser;
		
		case InvoiceListModel.c_StatementColumn:
			
			m_StatementNumber.setValue(StatementNumberFormatter.c_EmptyField);
			return m_StatementNumber;
		
		default: return super.getEditingComponent(p_Column);	
		}
	}

//---------------------------------------------------------------------------

protected Object getEditingComponentValue (JComponent p_Component, int p_Column)
	{
	Collection <Integer>	l_States;
	String					l_Text;
	Object					l_Value = null;
	Date 					l_Date;
	
	switch (p_Column)
		{
		case InvoiceListModel.c_StatusColumn:

			l_States = m_StateChooser.getChosenStates();
			if ((l_States != null) && (l_States.size() > 0))
				 l_Value = l_States;
			else l_Value = null;	
			break;
			
		case InvoiceListModel.c_InvoiceNumberColumn:
		
			if (p_Component instanceof JFormattedTextField)
				{
				l_Text = (String) m_InvoiceNumber.getValue();
				if (InvoiceNumberFormatter.c_EmptyFieldShort.equals(l_Text))
					 l_Value  = null;
				else try 
					{
					l_Value = Integer.parseInt(l_Text);
					}
				catch (NumberFormatException p_Exception)
					{
					l_Value = Integer.valueOf (0);
					}
				}
			break;
		
		case InvoiceListModel.c_InvoiceDateColumn:
		
			if (p_Component instanceof JDateChooser)
				{
				l_Date = m_DateChooser.getDate();
				l_Value = l_Date;
				}
			break;
			
		case InvoiceListModel.c_StatementColumn:
			
			if (p_Component instanceof JFormattedTextField)
				{
				l_Text = (String) m_StatementNumber.getValue();
				if (StatementNumberFormatter.c_EmptyField.equals(l_Text))
					 l_Value = null;
				else l_Value = l_Text;
				}
			break;

		default: super.getEditingComponentValue(p_Component, p_Column);
		}
	
	return l_Value;
	}

//---------------------------------------------------------------------------

protected String getEditingComponentText (JComponent p_Component, int p_Column)
	{
	Iterator<?> 		l_StateIterator;
	Integer				l_State;
	Object  l_Value;
	String	l_Text = SearchTableHeader.c_EmptyValue;
	
	l_Value = this.getEditingComponentValue(p_Component, p_Column);
	if (l_Value == null) return SearchTableHeader.c_EmptyValue;

	switch (p_Column)
		{
		case InvoiceListModel.c_StatusColumn:
	
			if (l_Value instanceof Collection)
				{
				l_Text = "";
				l_StateIterator = ((Collection<?>)l_Value).iterator();
				while (l_StateIterator.hasNext())
					{
					l_State = (Integer)l_StateIterator.next();
					l_Text += l_State.toString() + "|";
					}
				}
			break;
		
		case InvoiceListModel.c_InvoiceNumberColumn:
			
			if (l_Value instanceof Integer)
				{
				l_Text = l_Value.toString();
				if (InvoiceNumberFormatter.c_EmptyFieldShort.equals(l_Text)) 
					l_Text = SearchTableHeader.c_EmptyValue;	
				}
			break;
			
		case InvoiceListModel.c_InvoiceDateColumn:
			
			if (l_Value instanceof Date)
				{
				l_Text = m_DateFormat.format((Date)l_Value);
				}
			break;
			
		case InvoiceListModel.c_StatementColumn:
			
			if (l_Value instanceof String)
				{
				l_Text = (String) l_Value;
				if (StatementNumberFormatter.c_EmptyField.equals(l_Text)) 
					l_Text = SearchTableHeader.c_EmptyValue;	
				}
			break;
		}
			
	return l_Text;
	}

//---------------------------------------------------------------------------

public void propertyChange(PropertyChangeEvent p_Event) 
	{
	if (	(p_Event.getSource() == m_StateChooser) 
		&& (StateChooser.c_ChosenStatesChanged.equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}
	else if (   (p_Event.getSource() == m_DateChooser) 
			&& ("date".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}
	else if ( (p_Event.getSource() == m_DateChooser.getDateEditor())
			&& ("value".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource() == m_InvoiceNumber)
		{
		this.endEditing();
		}
	else if (p_Event.getSource() == m_StatementNumber)
		{
		this.endEditing();
		}
	else if (p_Event.getSource() == m_StateFilter)
		{
		m_StateChooser.actionPerformed(p_Event);
		}
	}

//---------------------------------------------------------------------------

public void focusGained (FocusEvent p_Event) 
	{
	super.focusGained (p_Event);
	
	if (p_Event.getSource() == m_StateFilter) 
		{
		if (m_StateFilter.isShowing()) 
			{
			m_StateFilter.doClick();
			}
		}
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	Locale l_Locale;
	
	l_Locale = Translatrix.getLocale ();
  	
	if (l_Locale != null) 
		 m_DateFormat = new SimpleDateFormat ("d MMMM yyyy",l_Locale);
	else m_DateFormat = new SimpleDateFormat ("d MMMM yyyy");   
	
	m_DateChooser.setDateFormatString("d MMMM yyyy");   
	m_DateChooser.getDateEditor().setLocale (Translatrix.getLocale());	
	}


//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
