/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.billing.gui.invoice.InvoiceNumberFormatter;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader.SearchTableHeader;
import lu.tudor.santec.gecamed.core.utils.SSNChecker;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.toedter.calendar.JDateChooser;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class InvoiceStubSearchTableHeader extends SearchTableHeader implements PropertyChangeListener,
																		   	   ActionListener,
																		   	   Relocalizable
	{
	private SimpleDateFormat    	m_DateFormat;
	
	private JTextField				m_PatientName;
	private JFormattedTextField		m_PatientSSN;
	private JFormattedTextField		m_InvoiceNumber;
	private	JDateChooser			m_CreationDateChooser;
	private	JDateChooser			m_DueDateChooser;
	private	JDateChooser			m_ReminderDateChooser;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public 	InvoiceStubSearchTableHeader (JTable p_Table)
	{
	super (p_Table);
	
	m_PatientName   = new JTextField ();
	m_PatientName.addActionListener(this);
	m_PatientName.addKeyListener(this);
	
	m_PatientSSN = new JFormattedTextField ();
	m_PatientSSN.addActionListener(this);
	m_PatientSSN.addKeyListener(this);
	
	m_InvoiceNumber = new JFormattedTextField (new InvoiceNumberFormatter(InvoiceNumberFormatter.c_ShortFormat));
	m_InvoiceNumber.addActionListener(this);
	m_InvoiceNumber.addKeyListener(this);
	
	m_CreationDateChooser = GECAMedGuiUtils.getDateChooser(false);
	m_CreationDateChooser.addPropertyChangeListener(this);
	m_CreationDateChooser.setVerifyInputWhenFocusTarget(false);
	m_CreationDateChooser.getDateEditor().addPropertyChangeListener(this);
	m_CreationDateChooser.addKeyListener(this);

	m_DueDateChooser = GECAMedGuiUtils.getDateChooser(false);
	m_DueDateChooser.addPropertyChangeListener(this);
	m_DueDateChooser.setVerifyInputWhenFocusTarget(false);
	m_DueDateChooser.getDateEditor().addPropertyChangeListener(this);
	m_DueDateChooser.addKeyListener(this);
	
	m_ReminderDateChooser = GECAMedGuiUtils.getDateChooser(false);
	m_ReminderDateChooser.addPropertyChangeListener(this);
	m_ReminderDateChooser.setVerifyInputWhenFocusTarget(false);
	m_ReminderDateChooser.getDateEditor().addPropertyChangeListener(this);
	m_ReminderDateChooser.addKeyListener(this);
	this.relocalize();
	
	this.setEnabled (InvoiceStubListModel.c_PatientNameColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_PatientNameColumn, false);
	
	this.setEnabled (InvoiceStubListModel.c_PatientSSNColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_PatientSSNColumn, false);
	
	this.setEnabled (InvoiceStubListModel.c_InvoiceStatusColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_InvoiceStatusColumn, false);
	
	this.setEnabled (InvoiceStubListModel.c_InvoiceNumberColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_InvoiceNumberColumn, false);
	
	this.setEnabled (InvoiceStubListModel.c_InvoiceDateColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_InvoiceDateColumn, false);
	
	this.setEnabled (InvoiceStubListModel.c_DueDateColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_DueDateColumn, false);	
	
	this.setEnabled (InvoiceStubListModel.c_ReminderDateColumn, false);
	this.setMutualExclusive(InvoiceStubListModel.c_ReminderDateColumn, false);	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

protected JComponent getEditingComponent (int p_Column)
	{	
	switch (p_Column)
		{
		case InvoiceStubListModel.c_PatientNameColumn:

			return m_PatientName;

		case InvoiceStubListModel.c_PatientSSNColumn:
			
			m_PatientSSN.setValue (SSNChecker.EMPTY_SSN_COMPACT);
			return m_PatientSSN;

		case InvoiceStubListModel.c_InvoiceNumberColumn:
			
			m_InvoiceNumber.setValue (InvoiceNumberFormatter.c_EmptyFieldShort);
			return m_InvoiceNumber;
		
		case InvoiceStubListModel.c_InvoiceDateColumn:
			
			return m_CreationDateChooser;
		
		case InvoiceStubListModel.c_DueDateColumn:
			
			return m_DueDateChooser;
		
		case InvoiceStubListModel.c_ReminderDateColumn:
			
			return m_ReminderDateChooser;

		default: return super.getEditingComponent(p_Column);	
		}
	}

//---------------------------------------------------------------------------

protected Object getEditingComponentValue (JComponent p_Component, int p_Column)
	{
	String					l_Text;
	Object					l_Value = null;
	Date 					l_Date;
	
	switch (p_Column)
		{
		case InvoiceStubListModel.c_PatientNameColumn:

			l_Value = m_PatientName.getText();
			break;
			
		case InvoiceStubListModel.c_PatientSSNColumn:
		
			if (p_Component instanceof JFormattedTextField)
				{
				l_Text = (String) m_PatientSSN.getValue();
				if (SSNChecker.PATTERN_EMPTY_SSN.matcher(l_Text).matches())
					 l_Value = null;
				else l_Value = l_Text;
				}
			break;
		
		case InvoiceStubListModel.c_InvoiceNumberColumn:
			
			if (p_Component instanceof JFormattedTextField)
				{
				l_Text = (String) m_InvoiceNumber.getValue();
				if (InvoiceNumberFormatter.c_EmptyFieldShort.equals(l_Text))
					 l_Value  = null;
				else try 
					{
					l_Value = Integer.parseInt(l_Text);
					}
				catch (NumberFormatException p_Exception)
					{
					l_Value = Integer.valueOf (0);
					}
				}
			break;

		case InvoiceStubListModel.c_InvoiceDateColumn:
		
			if (p_Component instanceof JDateChooser)
				{
				l_Date = m_CreationDateChooser.getDate();
				l_Value = l_Date;
				}
			break;
			
		case InvoiceStubListModel.c_DueDateColumn:
			
			if (p_Component instanceof JDateChooser)
				{
				l_Date = m_DueDateChooser.getDate();
				l_Value = l_Date;
				}
			break;
			
		case InvoiceStubListModel.c_ReminderDateColumn:
			
			if (p_Component instanceof JDateChooser)
				{
				l_Date = m_ReminderDateChooser.getDate();
				l_Value = l_Date;
				}
			break;

		default: super.getEditingComponentValue(p_Component, p_Column);
		}
	
	return l_Value;
	}

//---------------------------------------------------------------------------

protected String getEditingComponentText (JComponent p_Component, int p_Column)
	{
	Object  l_Value;
	String	l_Text = SearchTableHeader.c_EmptyValue;
	
	l_Value = this.getEditingComponentValue(p_Component, p_Column);
	if (l_Value == null) return SearchTableHeader.c_EmptyValue;

	switch (p_Column)
		{
		case InvoiceStubListModel.c_PatientNameColumn:

			if (l_Value instanceof String) l_Text = l_Value.toString();
			break;
		
		case InvoiceStubListModel.c_PatientSSNColumn:

			if (l_Value instanceof String)
				{
				l_Text = l_Value.toString();
				if (SSNChecker.PATTERN_EMPTY_SSN.matcher(l_Text).matches())
					l_Text = SearchTableHeader.c_EmptyValue;
				l_Text = SSNChecker.getFormattedSSN(l_Text, false);
				}
			break;
		
		case InvoiceStubListModel.c_InvoiceNumberColumn:
			
			if (l_Value instanceof Integer)
				{
				l_Text = l_Value.toString();
				if (InvoiceNumberFormatter.c_EmptyFieldShort.equals(l_Text)) 
					l_Text = SearchTableHeader.c_EmptyValue;	
				}
			break;
			
		case InvoiceStubListModel.c_InvoiceDateColumn:
			
			if (l_Value instanceof Date)
				{
				l_Text = m_DateFormat.format((Date)l_Value);
				}
			break;
			
		case InvoiceStubListModel.c_DueDateColumn:
			
			if (l_Value instanceof Date)
				{
				l_Text = m_DateFormat.format((Date)l_Value);
				}
			break;
			
		case InvoiceStubListModel.c_ReminderDateColumn:
			
			if (l_Value instanceof Date)
				{
				l_Text = m_DateFormat.format((Date)l_Value);
				}
			break;
		}
			
	return l_Text;
	}

//---------------------------------------------------------------------------

public void propertyChange(PropertyChangeEvent p_Event) 
	{
	if (   (p_Event.getSource() == m_CreationDateChooser) 
			&& ("date".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}
	else if (  (m_CreationDateChooser != null)
			&& (p_Event.getSource() == m_CreationDateChooser.getDateEditor())
			&& ("value".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	
	else if (  (p_Event.getSource() == m_DueDateChooser) 
			&& ("date".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	
	else if (  (m_DueDateChooser != null)
			&& (p_Event.getSource() == m_DueDateChooser.getDateEditor())
			&& ("value".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	
	else if (  (p_Event.getSource() == m_ReminderDateChooser) 
			&& ("date".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	
	else if (  (m_ReminderDateChooser != null)
			&& (p_Event.getSource() == m_ReminderDateChooser.getDateEditor())
			&& ("value".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource() == m_PatientName)
		{
		this.endEditing();
		}
	if (p_Event.getSource() == m_PatientSSN)
	{
	this.endEditing();
	}
	else if (p_Event.getSource() == m_InvoiceNumber)
		{
		this.endEditing();
		}
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	Locale l_Locale;
	
	l_Locale = Translatrix.getLocale ();
  	
	if (l_Locale != null) 
		 m_DateFormat = new SimpleDateFormat ("d MMMM yyyy",l_Locale);
	else m_DateFormat = new SimpleDateFormat ("d MMMM yyyy");   
	
	m_CreationDateChooser.setDateFormatString("d MMMM yyyy");   
	m_CreationDateChooser.getDateEditor().setLocale (Translatrix.getLocale());	
	
	m_DueDateChooser.setDateFormatString("d MMMM yyyy");   
	m_DueDateChooser.getDateEditor().setLocale (Translatrix.getLocale());	
	
	m_ReminderDateChooser.setDateFormatString("d MMMM yyyy");   
	m_ReminderDateChooser.getDateEditor().setLocale (Translatrix.getLocale());	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}

