/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.settlement;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractListModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class AccountListModel extends AbstractListModel 
	{
	private static final long serialVersionUID = 1L;
	
	private Vector <Account> m_Accounts;
	private Hashtable <String, Integer> m_AccountLookup;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
	
public 	AccountListModel ()
	{
	m_Accounts = new Vector <Account> ();
	m_AccountLookup = new Hashtable <String, Integer> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	
public Account getElementAt (int p_Index) 
	{
	if ((p_Index >= 0) && (p_Index < m_Accounts.size()))
		{
		return m_Accounts.elementAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getSize() 
	{
	return m_Accounts.size();
	}

//---------------------------------------------------------------------------

public boolean contains (Account p_Candidate)
	{
	if (p_Candidate != null)
		 return m_AccountLookup.containsKey(p_Candidate.getIban());
	else return false;
	}

//---------------------------------------------------------------------------

public int getElementPosition (Account p_Candidate)
	{
	if (this.contains (p_Candidate))
		{
		return m_AccountLookup.get(p_Candidate.getIban());
		}
	else return -1;
	}

//---------------------------------------------------------------------------

public void setAccounts (Collection <Account> p_Accounts)	
	{
	Iterator <Account> 	l_AccountIterator;
	Account			 	l_Account;
	int					l_Position = 0;
	
	m_Accounts.removeAllElements();
	m_AccountLookup.clear();
	
	if (p_Accounts != null)
		{
		l_AccountIterator = p_Accounts.iterator();
		while (l_AccountIterator.hasNext())
			{
			l_Account = l_AccountIterator.next();
			m_Accounts.add(l_Account);
			m_AccountLookup.put(l_Account.getIban(), l_Position++);
			}
		}
	}

//---------------------------------------------------------------------------

public void setAccounts (Account [] p_Accounts)	
	{
	Account		l_Account;
	int			l_Position = 0;
	
	m_Accounts.removeAllElements();
	m_AccountLookup.clear();
	
	if (p_Accounts != null)
		{
		for (l_Position = 0; l_Position < p_Accounts.length; l_Position++)
			{
			l_Account = p_Accounts [l_Position];
			m_Accounts.add(l_Account);
			m_AccountLookup.put(l_Account.getIban(), l_Position);
			}
		}
	}

//---------------------------------------------------------------------------

public Collection <Account> getAccounts ()
	{
	return m_Accounts;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
