/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.settlement;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Payment;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class RevokeDialog extends JDialog implements ActionListener,
													 Relocalizable
{
	private JLabel					m_RevokeMessage;
	
	private JLabel					m_InvoiceLabel;
	private JLabel					m_AmountLabel;
	private JLabel					m_SettlementDateLabel;
	private JLabel					m_SettlementMethodLabel;
	private JLabel					m_PaymentLabel;
	private JLabel					m_BalanceLabel;

	private TitledBorder			m_SettlementBorder;
	private TitledBorder			m_PrintBorder;
	
	private JLabel					m_InvoiceNumber;
	private JLabel					m_Amount;
	private JLabel					m_SettlementDate;
	private JLabel					m_SettlementMethod;
	private JLabel					m_Payment;
	private JLabel					m_Balance;
	
	private JCheckBox				m_PrintRevokedInvoice;

	private	Invoice					m_Invoice;
	private NumberFormat			m_CurrencyFormat;
	private DateFormat				m_DateFormat;

	private JButton					m_OkayButton;
	private JButton					m_CancelButton;

	private boolean					m_InvoiceRevoked;
	private Settlement				m_RevokedSettlement;
	private double					m_RevokedAmount;

	private static Logger m_Logger = Logger.getLogger ("gecamed.billing.gui.settlement.RevokeDialog");

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private final static String c_Columns				= 	"3dlu,fill:max(100dlu;pref):grow," +
															"3dlu,fill:max(50dlu;pref)," +
															"3dlu,fill:max(50dlu;pref),3dlu";

	private final static String c_Rows					=   "3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref,3dlu";

	private final static String c_SettlementPanelColumns = 	"3dlu,fill:max(70dlu;pref)," +
															"3dlu,fill:max(110dlu;pref),3dlu";

	private final static String c_SettlementPanelRows 	 = 	"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref,3dlu";

	private final static String c_PrintPanelColumns 	= 	"3dlu,fill:max(70dlu;pref)," +
															"3dlu,fill:max(110dlu;pref),3dlu";

	private final static String c_PrintPanelRows 		= 	"3dlu,fill:pref,3dlu";
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor                                                             *
//***************************************************************************
//---------------------------------------------------------------------------

public RevokeDialog ()	
	{	
	super (MainFrame.getInstance(),Translatrix.getTranslationString("RevokeDialog.Title"),true);
	
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	JPanel			l_SettlementPanel;
	JPanel			l_PrintPanel;
	ImageIcon		l_ImportantIcon;
	
	m_InvoiceRevoked 	= false;
	m_RevokedSettlement = null;
	m_RevokedAmount	 	= 0;
	
	m_RevokeMessage	= new JLabel ();
	l_ImportantIcon = BillingModule.getIconResource("important.png");
	m_RevokeMessage.setIcon(l_ImportantIcon);
	
	m_SettlementBorder = new TitledBorder ("");
	m_PrintBorder      = new TitledBorder ("");
	
	m_InvoiceLabel 		= new JLabel ();
	m_InvoiceLabel.setForeground(GECAMedColors.c_LabelColor);

	m_AmountLabel 	= new JLabel ();
	m_AmountLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_SettlementDateLabel = new JLabel ();
	m_SettlementDateLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_SettlementMethodLabel = new JLabel ();
	m_SettlementMethodLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_PaymentLabel = new JLabel ();
	m_PaymentLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_BalanceLabel = new JLabel ();
	m_BalanceLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_PaymentLabel 	= new JLabel ();
	m_PaymentLabel.setForeground(GECAMedColors.c_LabelColor);
	
	m_PrintRevokedInvoice = new JCheckBox ();
	m_PrintRevokedInvoice.setOpaque(false);
	
	m_CancelButton = new JButton ();
	m_CancelButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
	m_CancelButton.addActionListener(this);
	
	m_OkayButton = new JButton ();
	m_OkayButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.OK));
	m_OkayButton.addActionListener(this);
	
	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
	this.relocalize();
	
	//------------------------------------------------------------------------
	// Build Settlement Panel
	//------------------------------------------------------------------------
	
	l_Constraints  = new CellConstraints();
    
	l_SettlementPanel       = new JPanel ();
	l_SettlementPanel.setBorder (m_SettlementBorder);
	    
	l_Layout = new FormLayout(c_SettlementPanelColumns, c_SettlementPanelRows);
	l_SettlementPanel.setLayout (l_Layout);
	l_SettlementPanel.setOpaque(false);
	
	m_InvoiceNumber 	= new JLabel ();
	m_Amount			= new JLabel ();
	m_Payment 			= new JLabel ();
	m_SettlementDate 	= new JLabel ();
	m_SettlementMethod 	= new JLabel ();
	m_Balance 			= new JLabel ();
	
	l_SettlementPanel.add (m_InvoiceLabel, 			l_Constraints.xywh(2, 2, 3, 1));
	l_SettlementPanel.add (m_AmountLabel,   		l_Constraints.xywh(2, 4, 1, 1));
	l_SettlementPanel.add (m_PaymentLabel, 			l_Constraints.xywh(2, 6, 1, 1));
	l_SettlementPanel.add (m_SettlementDateLabel,   l_Constraints.xywh(2, 8, 1, 1));
	l_SettlementPanel.add (m_SettlementMethodLabel, l_Constraints.xywh(2, 10, 1, 1));
	l_SettlementPanel.add (m_BalanceLabel, 			l_Constraints.xywh(2, 12, 1, 1));
	
	l_SettlementPanel.add (m_InvoiceNumber,   		l_Constraints.xywh(4, 2, 1, 1));
	l_SettlementPanel.add (m_Amount,   				l_Constraints.xywh(4, 4, 1, 1));
	l_SettlementPanel.add (m_Payment, 				l_Constraints.xywh(4, 6, 1, 1));
	l_SettlementPanel.add (m_SettlementDate,   		l_Constraints.xywh(4, 8, 1, 1));
	l_SettlementPanel.add (m_SettlementMethod, 		l_Constraints.xywh(4, 10, 1, 1));
	l_SettlementPanel.add (m_Balance, 				l_Constraints.xywh(4, 12, 1, 1));
	
	//------------------------------------------------------------------------
	// Build Print Panel
	//------------------------------------------------------------------------
	
	l_Constraints  = new CellConstraints();
    
	l_PrintPanel       = new JPanel ();
	l_PrintPanel.setBorder (m_PrintBorder);
	    
	l_Layout = new FormLayout(c_PrintPanelColumns, c_PrintPanelRows);
	l_PrintPanel.setLayout (l_Layout);
	l_PrintPanel.setOpaque(false);
	
	l_PrintPanel.add (m_PrintRevokedInvoice, l_Constraints.xywh(4, 2, 1, 1));

	//------------------------------------------------------------------------
	// Cancel Button
	//------------------------------------------------------------------------
     
	l_Layout = new FormLayout(c_Columns, c_Rows);
    this.setLayout (l_Layout);

    this.add(m_RevokeMessage, 	l_Constraints.xywh(2, 2, 5, 1));
    this.add(l_SettlementPanel, l_Constraints.xywh(2, 4, 5, 1));
    this.add(l_PrintPanel,  	l_Constraints.xywh(2, 6, 5, 1));
    this.add(m_OkayButton,  	l_Constraints.xywh(4, 8, 1, 1));
    this.add(m_CancelButton,  	l_Constraints.xywh(6, 8, 1, 1));
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_ActionEvent) 
	{	
	if (p_ActionEvent.getSource() instanceof JButton)
		{
		if (p_ActionEvent.getSource() == m_CancelButton)
			{
			this.setVisible (false);
			m_InvoiceRevoked = false;
			}
		else if (p_ActionEvent.getSource() == m_OkayButton)
			{
			this.revokeInvoice ();
			this.setVisible (false);
			}
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	
private String formatSettlementMethod (Invoice p_Invoice)
	{
	Settlement 	l_Settlement;
	Payment		l_Payment;
	Account		l_Account;
	
	String		l_SettlementMethod = "n/a";
	String[]	l_Filler;
	
	l_Settlement = m_Invoice.getSettlement();
	if (l_Settlement != null)
		{
		l_Filler = new String [1];
		
		switch (l_Settlement.getSettlementMethod())
			{
			case Settlement.c_Payment 	:
			
				l_Payment = l_Settlement.getPayment();
				l_Filler [0] = l_Payment.getMethod();
				l_SettlementMethod = Translatrix.getTranslationString("RevokeDialog.ByPayment",l_Filler);
				break;
			
			case Settlement.c_Transfer 	:
				l_Account = l_Settlement.getTransferAccount();
				l_Filler [0] = l_Account.getBankname();
				l_SettlementMethod = Translatrix.getTranslationString("RevokeDialog.ByTransfer",l_Filler);
				break;
			}
		}
	return l_SettlementMethod;
	}

//---------------------------------------------------------------------------

private void revokeInvoice ()
	{
	double	l_AmountToRevoke;
	
	m_InvoiceRevoked 	= false;
	m_RevokedAmount	 	= 0;
	m_RevokedSettlement = null;
	
	if (m_Invoice==null) return;
	
	
	l_AmountToRevoke = m_Invoice.getPayment();
	if (l_AmountToRevoke == 0f) l_AmountToRevoke = m_Invoice.getDeduction();
		
	if (l_AmountToRevoke == 0f) return;
	
	m_RevokedAmount = m_Invoice.getPayment();
	m_RevokedSettlement = m_Invoice.getSettlement();

	// TODO LEDGER -> moved to Beanmethod
//	m_Invoice.setPayment(new Double(0));
//	m_Invoice.setDeduction(new Double(0));
//	m_Invoice.setSettlementDate(null);
//	m_Invoice.setSettlement(null);
	
	m_InvoiceRevoked = true;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Interface Primitives                                                    *
//***************************************************************************
//---------------------------------------------------------------------------

public void relocalize() 
	{
    Locale  l_Locale;
  	
    l_Locale = Translatrix.getLocale ();
    	  	
//    if (l_Locale != null) 
//         m_DateFormat = new SimpleDateFormat ("d MMMM yyyy",l_Locale);
//    else m_DateFormat = new SimpleDateFormat ("d MMMM yyyy");   
    m_DateFormat = GECAMedGuiUtils.getDateFormat(false);
    
 //   m_CurrencyFormat = NumberFormat.getCurrencyInstance (Translatrix.getLocale());
    m_CurrencyFormat = NumberFormat.getCurrencyInstance (Locale.FRANCE);
    m_CurrencyFormat.setCurrency(Currency.getInstance ("EUR"));
	
	this.setTitle(Translatrix.getTranslationString("RevokeDialog.Title"));
	
	if (m_RevokeMessage != null)
		m_RevokeMessage.setText(Translatrix.getTranslationString("RevokeDialog.RevokeMessage"));

	if (m_SettlementBorder != null)
		m_SettlementBorder.setTitle(Translatrix.getTranslationString("RevokeDialog.SettlementBorder"));
	
	if (m_InvoiceLabel != null)
		m_InvoiceLabel.setText(Translatrix.getTranslationString("RevokeDialog.InvoiceLabel"));
	
	if (m_AmountLabel != null)
		m_AmountLabel.setText(Translatrix.getTranslationString("RevokeDialog.AmountLabel"));
	
	if (m_SettlementDateLabel != null)
		m_SettlementDateLabel.setText(Translatrix.getTranslationString("RevokeDialog.SettlementDateLabel"));
	
	if (m_SettlementMethodLabel != null)
		m_SettlementMethodLabel.setText(Translatrix.getTranslationString("RevokeDialog.SettlementMethodLabel"));
	
	if (m_PaymentLabel != null)
		m_PaymentLabel.setText(Translatrix.getTranslationString("RevokeDialog.PaymentLabel"));

	if (m_BalanceLabel != null)
		m_BalanceLabel.setText(Translatrix.getTranslationString("RevokeDialog.BalanceLabel"));
	
	if (m_PrintBorder != null)
		m_PrintBorder.setTitle(Translatrix.getTranslationString("RevokeDialog.PrintBorder"));
	
	if (m_PrintRevokedInvoice != null)
		m_PrintRevokedInvoice.setText(Translatrix.getTranslationString("RevokeDialog.PrintRevokedInvoice"));

	if (m_CancelButton != null)
		m_CancelButton.setText(Translatrix.getTranslationString("core.cancel"));

	if (m_OkayButton != null)
		m_OkayButton.setText(Translatrix.getTranslationString("core.ok"));
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public void setInvoice (Invoice p_Invoice)
	{
	if (p_Invoice == null) return;
	
	m_Invoice = p_Invoice;
	
	m_InvoiceNumber.setText		(m_Invoice.formatInvoiceNumber(false, true));
	m_Amount.setText			(m_CurrencyFormat.format(m_Invoice.getAmount()));
	m_SettlementDate.setText	(m_DateFormat.format(m_Invoice.getSettlementDate()));
	m_SettlementMethod.setText  (this.formatSettlementMethod(m_Invoice));
	m_Payment.setText			(m_CurrencyFormat.format(m_Invoice.getPayment()));
	m_Balance.setText			(m_CurrencyFormat.format(m_Invoice.getBalance()));
	
	m_InvoiceRevoked = false;
	m_RevokedAmount	 = 0;
	}

//---------------------------------------------------------------------------

public Invoice getInvoice ()
	{
	return m_Invoice;
	}

//---------------------------------------------------------------------------

public void setPrintRevokedInvoice (Boolean p_PrintIt)
	{
	m_PrintRevokedInvoice.setSelected(p_PrintIt);
	}

//---------------------------------------------------------------------------

public boolean getPrintRevokedInvoice ()
	{
	return m_PrintRevokedInvoice.isSelected();
	}

//---------------------------------------------------------------------------

public double getRevokedAmount ()
	{
	return m_RevokedAmount;
	}

//---------------------------------------------------------------------------

public Settlement getRevokedSettlement ()
	{
	return m_RevokedSettlement;
	}

//---------------------------------------------------------------------------

public boolean invoiceRevoked ()
	{
	return m_InvoiceRevoked;
	}

//---------------------------------------------------------------------------	
//***************************************************************************
//* End of Class				                            				*
//***************************************************************************
//---------------------------------------------------------------------------	
}
