/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.statement;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractListModel;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class InsuranceListModel extends AbstractListModel 
	{
	private static final long serialVersionUID = 1L;
	
	private Vector <Insurance> m_Insurances;
	private Hashtable <String, Integer> m_InsuranceLookup;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
	
public 	InsuranceListModel ()
	{
	m_Insurances = new Vector <Insurance> ();
	m_InsuranceLookup = new Hashtable <String, Integer> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	
public Insurance getElementAt (int p_Index) 
	{
	if ((p_Index >= 0) && (p_Index < m_Insurances.size()))
		{
		return m_Insurances.elementAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getSize() 
	{
	return m_Insurances.size();
	}

//---------------------------------------------------------------------------

public boolean contains (Insurance p_Candidate)
	{
	if (p_Candidate != null)
		 return m_InsuranceLookup.containsKey(p_Candidate.getAcronym());
	else return false;
	}

//---------------------------------------------------------------------------

public int getElementPosition (Insurance p_Candidate)
	{
	if (this.contains (p_Candidate))
		{
		return m_InsuranceLookup.get(p_Candidate.getAcronym());
		}
	else return -1;
	}

//---------------------------------------------------------------------------

public void setInsurances (Collection <Insurance> p_Insurances)	
	{
	Iterator <Insurance> l_InsuranceIterator;
	Insurance			 l_Insurance;
	int					 l_Position = 0;
	
	m_Insurances.removeAllElements();
	m_InsuranceLookup.clear();
	
	if (p_Insurances != null)
		{
		l_InsuranceIterator = p_Insurances.iterator();
		while (l_InsuranceIterator.hasNext())
			{
			l_Insurance = l_InsuranceIterator.next();
			m_Insurances.add(l_Insurance);
			m_InsuranceLookup.put(l_Insurance.getAcronym(), l_Position++);
			}
		}
	}

//---------------------------------------------------------------------------

public Collection <Insurance> getInsurances ()
	{
	return m_Insurances;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
