/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.statement;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class PatientNameFilter implements TableFilter 
{
	private String	m_Filter;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public PatientNameFilter ()
	{
	m_Filter = null;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                		*
//***************************************************************************
//---------------------------------------------------------------------------
	
public boolean accept(Object p_Value) 
	{
	String	l_Value;
	
	if (m_Filter == null) return true;
	
	if (m_Filter.length() == 0) return true;
	
	if (p_Value instanceof String)
		{
		l_Value = (String)p_Value;
		return l_Value.toLowerCase().startsWith(m_Filter);
		}
	
	return false;
	}

//---------------------------------------------------------------------------

public void compile() 
	{
	}

//---------------------------------------------------------------------------

public boolean isFiltering() 
	{
	if ((m_Filter != null) && (m_Filter.length() > 0)) 
		 return true;
	else return false;
	}

//---------------------------------------------------------------------------

public void setFilter (Object p_FilterValue) 
	{
	if (p_FilterValue instanceof String) 
		m_Filter = ((String) p_FilterValue).toLowerCase();	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
//---------------------------------------------------------------------------

}
