/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.statement;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractListModel;

import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class PhysicianListModel extends AbstractListModel 
	{
	private static final long serialVersionUID = 1L;
	
	private Vector <Physician> m_Physicians;
	private Hashtable <String, Integer> m_PhysicianLookup;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
	
public 	PhysicianListModel ()
	{
	m_Physicians = new Vector <Physician> ();
	m_PhysicianLookup = new Hashtable <String, Integer> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	
public Physician getElementAt (int p_Index) 
	{
	if ((p_Index >= 0) && (p_Index < m_Physicians.size()))
		{
		return m_Physicians.elementAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getSize() 
	{
	return m_Physicians.size();
	}

//---------------------------------------------------------------------------

public boolean contains (Physician p_Candidate)
	{
	if (p_Candidate != null)
		 return m_PhysicianLookup.containsKey(p_Candidate.getUcmCode());
	else return false;
	}

//---------------------------------------------------------------------------

public int getElementPosition (Physician p_Candidate)
	{
	if (this.contains (p_Candidate))
		{
		return m_PhysicianLookup.get(p_Candidate.getUcmCode());
		}
	else return -1;
	}

//---------------------------------------------------------------------------

public void setPhysicians (Collection <Physician> p_Physicians)	
	{
	Iterator <Physician> l_PhysicianIterator;
	Physician			 l_Physician;
	int					 l_Position = 0;
	
	m_Physicians.removeAllElements();
	m_PhysicianLookup.clear();
	
	if (p_Physicians != null)
		{
		l_PhysicianIterator = p_Physicians.iterator();
		while (l_PhysicianIterator.hasNext())
			{
			l_Physician = l_PhysicianIterator.next();
			m_Physicians.add(l_Physician);
			m_PhysicianLookup.put(l_Physician.getUcmCode(), l_Position++);
			}
		}
	}

//---------------------------------------------------------------------------

public void setPhysicians (Physician [] p_Physicians)	
	{
	Physician			 l_Physician;
	int					 l_Position;
	
	m_Physicians.removeAllElements();
	m_PhysicianLookup.clear();
	
	if (p_Physicians != null)
		{
		for (l_Position = 0; l_Position < p_Physicians.length; l_Position++)
			{
			l_Physician = p_Physicians [l_Position];
			m_Physicians.add(l_Physician);
			m_PhysicianLookup.put(l_Physician.getUcmCode(), l_Position);
			}
		}
	}

//---------------------------------------------------------------------------

public Collection <Physician> getPhysicians ()
	{
	return m_Physicians;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
