/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/

package lu.tudor.santec.gecamed.billing.gui.statistics;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.ComponentTitledPanel;
import lu.tudor.santec.gecamed.core.gui.widgets.FromUntilDatePanel;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class TransactionListDialog extends JDialog implements ItemListener,
															  ActionListener,
															  Relocalizable
	{
	private TitledBorder			m_PeriodBorder;
	private FromUntilDatePanel		m_PeriodPanel;

	private ComponentTitledPanel	m_CashierBorder;
	private JPanel					m_CashierPanel;
	private JCheckBox				m_SingleCashier;
    private JComboBox				m_CashierChooser;
	private JTextField				m_CashierField;
    private JLabel					m_CashierLabel;

	private TitledBorder			m_OptionsBorder;
	private JPanel					m_OptionsPanel;
	private JCheckBox				m_EffectiveTransactions;
	private JCheckBox				m_IncludeTransfers;
	private JCheckBox				m_OnlyTotals;

	private JButton					m_OkayButton;	
	private JButton					m_CancelButton;
	
	private boolean					m_Validated;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;

	private final static Dimension c_PreferredSize = new Dimension (350,430);

	private static final String	c_Title					= "TransactionListDialog.Title";
	private static final String	c_PeriodBorder			= "TransactionListDialog.PeriodBorder";
	private static final String	c_CashierSwitch			= "TransactionListDialog.CashierSwitch";
	private static final String	c_CashierLabel			= "TransactionListDialog.CashierLabel";
	private static final String	c_AllCashiers			= "TransactionListDialog.AllCashiers";
	private static final String	c_OptionsBorder			= "TransactionListDialog.OptionsBorder";
	private static final String	c_EffectiveTransactions = "TransactionListDialog.EffectiveTransactions";
	private static final String	c_IncludeTransfers      = "TransactionListDialog.IncludeTransfers";
	private static final String	c_OnlyTotals            = "TransactionListDialog.OnlyTotals";
	
	private final static String c_Columns	= 	"3dlu,fill:max(70dlu;pref)," + 
												"3dlu,fill:max(70dlu;pref),3dlu";

	private final static String c_Rows		=   "3dlu,fill:pref," +
												"3dlu,fill:pref," +
												"3dlu,fill:pref," +
												"3dlu,fill:pref,3dlu";

	private final static String c_CashierPanelColumns	=	"3dlu,fill:max(100dlu;pref),3dlu";
	
	private final static String c_CashierPanelRows		=	"3dlu,fill:pref," + 
															"3dlu,fill:max(20dlu;pref),3dlu";

	private final static String c_OptionsPanelColumns	=	"3dlu,fill:pref,3dlu";
	
	private final static String c_OptionsPanelRows		=	"3dlu,fill:pref," +
															"3dlu,fill:pref," +
															"3dlu,fill:pref,3dlu";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public TransactionListDialog ()
	{
	super (MainFrame.getInstance(),Translatrix.getTranslationString(c_Title),true);
	
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	l_Constraints  = new CellConstraints();

	m_Validated = false;
	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);

	buildPeriodPanel ();
	buildCashierPanel ();
	buildOptionsPanel ();
	
	l_Constraints  = new CellConstraints();
	l_Layout = new FormLayout(c_Columns, c_Rows);
	this.setLayout(l_Layout);
	
	this.add(m_PeriodPanel,     	l_Constraints.xywh(2, 2, 3, 1));
	this.add(m_CashierBorder,     	l_Constraints.xywh(2, 4, 3, 1));
	this.add(m_OptionsPanel,	l_Constraints.xywh(2, 6, 3, 1));

	m_OkayButton = new JButton (Translatrix.getTranslationString("core.ok"));
	m_OkayButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.OK));
	m_OkayButton.addActionListener(this);

	m_CancelButton = new JButton (Translatrix.getTranslationString("core.cancel"));
	m_CancelButton.setIcon(GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
	m_CancelButton.addActionListener(this);

	this.add (m_OkayButton,  	l_Constraints.xywh(2, 8, 1, 1));
	this.add (m_CancelButton,   l_Constraints.xywh(4, 8, 1, 1));
	
	this.setSize(c_PreferredSize);
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private void swapComponents (JComponent p_Out, JComponent p_In, CellConstraints p_Constraints)
	{
	Container l_Parent;
	
	l_Parent = p_Out.getParent();
	
	if (l_Parent != null)
		{
		l_Parent.remove (p_Out);
		l_Parent.add( p_In,p_Constraints);
		l_Parent.validate();
		}
	}

//---------------------------------------------------------------------------

private void buildPeriodPanel ()
	{
	m_PeriodBorder = new TitledBorder (Translatrix.getTranslationString (c_PeriodBorder));
	
	m_PeriodPanel = new FromUntilDatePanel (FromUntilDatePanel.c_UntilDateToLastOfMonth);
	m_PeriodPanel.setBorder(m_PeriodBorder);
	}

//---------------------------------------------------------------------------

private void buildCashierPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	Color			l_DefaultColor;
	
	l_Constraints  = new CellConstraints();
	
	m_CashierPanel = new JPanel ();

	l_Layout = new FormLayout(c_CashierPanelColumns, c_CashierPanelRows);
	m_CashierPanel.setLayout (l_Layout);
	m_CashierPanel.setOpaque(false);
	
	m_SingleCashier = new JCheckBox (Translatrix.getTranslationString(c_CashierSwitch));
	m_SingleCashier.setBackground(GECAMedColors.c_GECAMedBackground);
	m_SingleCashier.setSelected(false);
	m_SingleCashier.addItemListener (this);
	
	m_CashierLabel = new JLabel (Translatrix.getTranslationString(c_CashierLabel));
	m_CashierLabel.setForeground(GECAMedColors.c_LabelColor);
   	
	m_CashierChooser = new JComboBox ();
	this.populateCashiers(BillingModule.getInstance().getUsers());
	
    l_DefaultColor = (Color) UIManager.getDefaults().get("TextField.inactiveBackground");   
    UIManager.getDefaults().put("TextField.inactiveBackground", Color.WHITE );

    m_CashierField = new JTextField ();
    m_CashierField.setEditable(false);
    m_CashierField.setEnabled (false);
    m_CashierField.setText(Translatrix.getTranslationString(c_AllCashiers));
    
    UIManager.getDefaults().put("TextField.inactiveBackground", l_DefaultColor );

	m_CashierPanel.add (m_CashierLabel, 	l_Constraints.xywh(2, 2, 1, 1));
	m_CashierPanel.add (m_CashierChooser, 	l_Constraints.xywh(2, 4, 1, 1));

	m_CashierBorder = new ComponentTitledPanel (m_SingleCashier,m_CashierPanel);
	m_CashierBorder.setOpaque(false);	
	
    this.enableCashierPanel(false);
	}

//---------------------------------------------------------------------------

private void buildOptionsPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	
	l_Constraints  = new CellConstraints();

	l_Layout = new FormLayout(c_OptionsPanelColumns, c_OptionsPanelRows);
	m_OptionsBorder = new TitledBorder (Translatrix.getTranslationString (c_OptionsBorder));
	
	m_OptionsPanel = new JPanel ();
	m_OptionsPanel.setOpaque(false);
	m_OptionsPanel.setLayout(l_Layout);
	m_OptionsPanel.setBorder(m_OptionsBorder);
	
	m_EffectiveTransactions = new JCheckBox ();
	m_EffectiveTransactions.setText (Translatrix.getTranslationString (c_EffectiveTransactions));
	m_EffectiveTransactions.setBackground(GECAMedColors.c_GECAMedBackground);
	
	m_IncludeTransfers = new JCheckBox ();
	m_IncludeTransfers.setText (Translatrix.getTranslationString (c_IncludeTransfers));
	m_IncludeTransfers.setBackground(GECAMedColors.c_GECAMedBackground);
	
	m_OnlyTotals = new JCheckBox ();
	m_OnlyTotals.setText (Translatrix.getTranslationString (c_OnlyTotals));
	m_OnlyTotals.setBackground(GECAMedColors.c_GECAMedBackground);
	
	m_OptionsPanel.add (m_EffectiveTransactions, l_Constraints.xywh(2, 2, 1, 1));
	m_OptionsPanel.add (m_IncludeTransfers,      l_Constraints.xywh(2, 4, 1, 1));
	m_OptionsPanel.add (m_OnlyTotals,            l_Constraints.xywh(2, 6, 1, 1));
	}

//---------------------------------------------------------------------------

public void populateCashiers (Collection <GecamedUser> p_Cashiers)
	{
	Iterator <GecamedUser>	l_CashierIterator;
	
	if (p_Cashiers == null) return;
	
	l_CashierIterator = p_Cashiers.iterator();
	while (l_CashierIterator.hasNext())
		{
		m_CashierChooser.addItem (l_CashierIterator.next());
		}
	}

//---------------------------------------------------------------------------

private void enableCashierPanel (boolean p_EnableIt)
	{
	CellConstraints		l_Constraints;
	
    l_Constraints  = new CellConstraints();

    if (p_EnableIt)
		{
		this.swapComponents(m_CashierField,	m_CashierChooser,	l_Constraints.xywh(2, 4, 1, 1));
		}
	else
		{
		this.swapComponents(m_CashierChooser, m_CashierField,	l_Constraints.xywh(2, 4, 1, 1));
		}
	
    this.repaint();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Date getFromDate ()
	{
	if (m_PeriodPanel != null)
		 return m_PeriodPanel.getFromDate();
	else return null;
	}

//---------------------------------------------------------------------------

public void setFromDate (Date p_FromDate)
	{
	if (m_PeriodPanel != null) m_PeriodPanel.setFromDate(p_FromDate);
	}

//---------------------------------------------------------------------------

public Date getUntilDate ()
	{
	if (m_PeriodPanel != null)
		 return m_PeriodPanel.getUntilDate();
	else return null;
	}

//---------------------------------------------------------------------------

public void setUntilDate (Date p_UntilDate)
	{
	if (m_PeriodPanel != null) m_PeriodPanel.setUntilDate(p_UntilDate);
	}

//---------------------------------------------------------------------------

public boolean isSingleCashier ()
	{
	return m_SingleCashier.isSelected();
	}

//---------------------------------------------------------------------------

public void setSingleCashier (boolean p_SingleCashier)
	{
	m_SingleCashier.setSelected(p_SingleCashier);
	}

//---------------------------------------------------------------------------

public GecamedUser getCashier ()
	{
	return (GecamedUser) m_CashierChooser.getSelectedItem();
	}

//---------------------------------------------------------------------------

public void setCashier (GecamedUser p_Cashier)
	{
	m_CashierChooser.setSelectedItem(p_Cashier);
	}

//---------------------------------------------------------------------------

public boolean onlyEffectiveTransactions ()
	{
	return m_EffectiveTransactions.isSelected();
	}

//---------------------------------------------------------------------------

public void setEffectiveTransactions (boolean p_OnlyEffectiveTransactions)
	{
	m_EffectiveTransactions.setSelected(p_OnlyEffectiveTransactions);
	}

//---------------------------------------------------------------------------

public boolean includeTransfers ()
	{
	return m_IncludeTransfers.isSelected();
	}

//---------------------------------------------------------------------------

public void setIncludeTransfers (boolean p_IncludeTransfers)
	{
	m_IncludeTransfers.setSelected(p_IncludeTransfers);
	}

//---------------------------------------------------------------------------

public boolean onlyTotals ()
	{
	return m_OnlyTotals.isSelected();
	}

//---------------------------------------------------------------------------

public void setOnlyTotals (boolean p_OnlyTotals)
	{
	m_OnlyTotals.setSelected(p_OnlyTotals);
	}

//---------------------------------------------------------------------------

public boolean wasValidated ()
	{
	return m_Validated;
	}

//---------------------------------------------------------------------------

public void setVisible (boolean p_ShowIt)
	{
	if (p_ShowIt) m_Validated = false;
	super.setVisible(p_ShowIt);
	}

//---------------------------------------------------------------------------

public void actionPerformed (ActionEvent p_Event) 
	{
	if (p_Event.getSource().equals(m_OkayButton))
	{
	m_Validated = true;
	this.setVisible(false);
	}	
else if (p_Event.getSource().equals(m_CancelButton))
	{
	m_Validated = false;
	this.setVisible(false);
	}	
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	this.setTitle(Translatrix.getTranslationString(c_Title));
	
	if (m_PeriodBorder != null)
		m_PeriodBorder.setTitle(Translatrix.getTranslationString (c_PeriodBorder));
	
	if (m_SingleCashier != null)
		m_SingleCashier.setText (Translatrix.getTranslationString (c_CashierSwitch));
	
	if (m_CashierLabel != null)
		m_CashierLabel.setText (Translatrix.getTranslationString (c_CashierLabel));
	
	if (m_CashierField != null)
		m_CashierField.setText (Translatrix.getTranslationString (c_AllCashiers));
	
	if (m_OptionsBorder != null)
		m_OptionsBorder.setTitle(Translatrix.getTranslationString (c_OptionsBorder));
	
	if (m_EffectiveTransactions != null)
		m_EffectiveTransactions.setText (Translatrix.getTranslationString (c_EffectiveTransactions));
	
	if (m_IncludeTransfers != null)
		m_IncludeTransfers.setText (Translatrix.getTranslationString (c_IncludeTransfers));
	
	if (m_OnlyTotals != null)
		m_OnlyTotals.setText (Translatrix.getTranslationString (c_OnlyTotals));
	}

//---------------------------------------------------------------------------

public void itemStateChanged(ItemEvent p_Event) 
	{
	if (p_Event.getSource().equals(m_SingleCashier))
		this.enableCashierPanel(m_SingleCashier.isSelected());
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}
