/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;

import lu.tudor.santec.gecamed.billing.gui.TextWrappingCellRenderer;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class DescriptionRenderer extends TextWrappingCellRenderer
	{
	private int						m_HighlightedRows;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public DescriptionRenderer ()
      {
      super();
      }

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void setNumberOfHighlightedRows (int p_HighlightedRows)
	{
	m_HighlightedRows = p_HighlightedRows;
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent(JTable p_Table, Object
          									   value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) 	

	{
	Component 	l_Component;
	Color		l_Background;
	
	l_Component = super.getTableCellRendererComponent(p_Table, value, p_IsSelected, hasFocus, p_Row, p_Column);
	
	if (p_Row >= m_HighlightedRows)
		{
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
			 							   GECAMedColors.c_EvenLineBackground;
		}
	else
		{
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_YellowOddLineBackground: 
			 							   GECAMedColors.c_YellowEvenLineBackground;
		}
	
	
	if ((p_Table != null) && (p_IsSelected)) 
		{
		l_Component.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		l_Component.setBackground(l_Background);
		}

	return l_Component;	
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
