/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class TemplateTransferable implements Transferable 
	{
    InvoiceTemplate	m_Template;

    public static final DataFlavor c_TemplateFlavor = new DataFlavor (InvoiceTemplate.class,"InvoiceTemplate");
    
 //***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public TemplateTransferable (InvoiceTemplate p_Template) 
	{
    m_Template = p_Template;
    }

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                    *
//***************************************************************************
//---------------------------------------------------------------------------

public Object getTransferData(DataFlavor p_Flavor) throws UnsupportedFlavorException 
	{
    if (!isDataFlavorSupported(p_Flavor)) 
    	{
        throw new UnsupportedFlavorException(p_Flavor);
        }
   return m_Template;
   }

//---------------------------------------------------------------------------

public DataFlavor[] getTransferDataFlavors() 
	{
    return new DataFlavor[] { c_TemplateFlavor };
    }

//---------------------------------------------------------------------------

public boolean isDataFlavorSupported(DataFlavor p_Flavor) 
	{
    if (c_TemplateFlavor.equals(p_Flavor)) 
    	{
        return true;
        }
    return false;
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
