package lu.tudor.santec.gecamed.billing.test.utils;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ResultBean.java,v $
 */

public class ResultBean
{
	private Invoice	invoice;
	private Act		act;
	private boolean	firstResult;
	
	
	
	public ResultBean (Invoice invoice, Act act, boolean firstResult) 
	{
		this.setInvoice(invoice);
		this.setAct(act);
		this.firstResult	= firstResult;
	}
	
	
	
	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */
	
	public Invoice getInvoice ()
	{
		return invoice;
	}
	
	
	public void setInvoice (Invoice invoice)
	{
		this.invoice = invoice;
	}
	
	
	public Act getAct ()
	{
		return act;
	}
	
	
	public void setAct (Act act)
	{
		this.act = act;
	}
	
	
	public String getCode ()
	{
		return act.getCode();
	}
	
	
	public String getSuffixes ()
	{
		return act.getSuffixes();
	}
	
	
	public String getQuantity ()
	{
		return String.valueOf(act.getQuantity());
	}
	
	
	public String getAmount ()
	{
		return String.valueOf(act.getAmount());
	}
	
	
	public String getTTP ()
	{
		if (firstResult 
				&& invoice != null 
				&& invoice.getThirdPartyPayer() != null
				&& invoice.getThirdPartyPayer().getAcronym() != null)
			return invoice.getThirdPartyPayer().getAcronym();
		
		return "";
	}
}
