package lu.tudor.santec.gecamed.billing.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;


public class ActReportField implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static ActComparator actPrintComparator = new ActComparator();
	
	private Act beanAct;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	static
	{
		actPrintComparator.addSortCriterion(ActComparator.c_PerformedDate,	ActComparator.c_Ascending);
		actPrintComparator.addSortCriterion(ActComparator.c_Code,			ActComparator.c_Ascending);
		actPrintComparator.addSortCriterion(ActComparator.c_Suffixes,		ActComparator.c_Ascending);
		actPrintComparator.addSortCriterion(ActComparator.c_Value,			ActComparator.c_Ascending);
		actPrintComparator.addSortCriterion(ActComparator.c_Id,				ActComparator.c_Ascending);
	}
	
	public ActReportField (Act act)
	{
		this.beanAct = act;
	}
	
	
	public static Collection<ActReportField> createFields (Invoice invoice)
	{
		TreeSet<Act>				acts	= new TreeSet<Act>(actPrintComparator);
		Collection<ActReportField>	fields;
		
		
		acts.addAll(invoice.getActs());
		fields = new ArrayList<ActReportField>(acts.size());
		
		for (Act act : acts)
		{
			fields.add(new ActReportField(act));
		}
		
		return fields;
	}
	
	
	
	/* ======================================== */
	// 		NEW BEAN FIELD
	/* ======================================== */
	
	public Act getBeanAct()
	{
		return beanAct;
	}
	
	
	
	/* ======================================== */
	// 		OLD FIELDS
	/* ======================================== */
	
	public Date getPerformedDate ()
	{
		return beanAct.getPerformedDate();
	}
	
	
	public String getCode ()
	{
		return beanAct.getCode();
	}
	
	
	public String getLabel ()
	{
		return beanAct.getLabel();
	}
	
	
	public Integer getQuantity ()
	{
		return beanAct.getQuantity();
	}
	
	
	public Boolean getShowTime ()
	{
		return beanAct.getShowTime();
	}
	
	
	public Double getValue ()
	{
		return beanAct.getValue();
	}
	
	
	public String getSuffixes ()
	{
		return beanAct.getSuffixes();
	}
}
