/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.utils;

import lu.tudor.santec.gecamed.core.utils.SettingPluginNames;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class BillingAdminSettings 
{
//***************************************************************************
//* Constants                                                          		*
//***************************************************************************
	
	public static final String c_ModuleName						= SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME;
	
	public static final String c_SplitBillingSetting 			= "BillingPerPhysician";
	public static final String c_ShortInvoiceNumbersSetting 	= "ShortInvoiceNumbers";
	public static final String c_UseLeadingZerosSetting 		= "UseLeadingZeros";
	public static final String c_HospitalisationSetting 		= "Hospitalisation";
	public static final String c_ThirdPartyStatementsSetting 	= "ThirdPartyStatements";
	public static final String c_AddressStyleSetting 			= "AddressStyle";
	public static final String c_DuePeriodSetting 				= "DuePeriod";
	public static final String c_MaxInvoicesSetting 			= "MaxInvoices";
	public static final String c_OnlyExpiredInvoicesSetting 	= "OnlyExpiredInvoices";
	public static final String c_ReminderCopiesSetting 			= "ReminderCopies";
	public static final String c_ReminderInvoicesSetting 		= "ReminderInvoices";
	public static final String c_JoinRemindersOfPatient			= "JoinRemindersOfPatient";
	public static final String c_PaymentOrderCopiesSetting 		= "PaymentOrderCopies";
	public static final String c_PaymentOrderInvoicesSetting 	= "PaymentOrderInvoices";
	public static final String c_JoinPaymentOrdersOfPatient		= "JoinPaymentOrderOfPatient";
	public static final String c_DefaultAccountIdSetting 		= "DefaultAccountId";
	public static final String c_PrintZeroActsSetting 			= "PrintZeroActs";
	public static final String c_PrintCNSCodeSetting 			= "PrintPhysicianCNSNo";
	@Deprecated
	public static final String c_CumulateAllIfHospitalized		= "CumulateAllIfHospitalized";
	public static final String c_HospitalizedCumulationMode		= "HospitalizedCumulationMode";
	public static final String c_UseSessionMode					= "UseSessionModeForRules";
	public static final String c_TiersPayantMinValue			= "TiersPayantMinValue";
//	public static final String c_DefaultAccountSetting 			= "DefaultAccount";
	
	public static final String c_ShowInfoColumnSetting			= "ShowInfoColumn";
	public static final String c_ShowMedPrescColumnSetting		= "ShowMedPrescColumn";
	public static final String c_ShowUsernameColumnSetting		= "ShowUsernameColumn";
	public static final String c_ShowAdjustColumnSetting		= "ShowAdjustColumn";
	
	public static final String c_ShowMedTransPanelSetting		= "ShowMedTransPanel";
	
	
/* **************************************** */
// DEFAULTS
/* **************************************** */

	public static final boolean	c_CumulateAllIfHospitalizedDefault		= true;
	public static final boolean	c_UseSessionModeDefault					= false;
	public static final int		c_RuleOptionPatientAge					= 30;
	public static final int		c_TiersPayantMinValueDefault			= 100;
	public static final boolean	c_PrintPhysicianCNSNoStationary			= false;
	public static final boolean	c_PrintZeroActsStationary				= true;

	public static final int		c_OriginalStyle						= 0;
	public static final int		c_UpperCaseStyle					= 1;
	public static final int		c_CapitalizeWordStyle				= 2;
	
	public static final int		c_HospitalizedCumulationModeNormal			= 0;
	public static final int		c_HospitalizedCumulationModeFullWithFCode	= 1;
	public static final int		c_HospitalizedCumulationModeFull			= 2;
	public static final int		c_HospitalizedCumulationModeDefault			= 2;

	public static final String c_CheckActFuture 			= "CheckActFuture";
	public static final String c_CheckActBeforeBirthDate 	= "CheckActBeforeBirthDate";
	public static final String c_CheckBirthDate 			= "CheckBirthDate";
	public static final String c_CheckBirthDateMax 			= "CheckBirthDateMax";

	public static final boolean c_CheckActFutureStationary 			= false;
	public static final boolean c_CheckActBeforeBirthDateStationary = false;
	public static final boolean c_CheckBirthDateStationary 			= false;
	public static final int 	c_CheckBirthDateMaxStationary 		= 100;





	
//***************************************************************************
//* End Of Class				                                            *
//***************************************************************************
}
