/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.utils;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class CurrencyFormat extends NumberFormat 
	{
	private static final long serialVersionUID = 1L;
	
	private NumberFormat	m_NumberFormat;
	private String			m_Symbol;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor                                                             *
//***************************************************************************
//---------------------------------------------------------------------------

public CurrencyFormat (Currency p_Currency)
	{
	m_NumberFormat = NumberFormat.getCurrencyInstance (Locale.FRANCE);
	
	if (p_Currency != null)
		{
		m_NumberFormat.setCurrency(p_Currency);
		m_Symbol = p_Currency.getSymbol(Locale.FRANCE);
		}
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

public StringBuffer format (double p_Number, StringBuffer p_AppendTo, FieldPosition p_Position) 
	{
	return m_NumberFormat.format(p_Number, p_AppendTo, p_Position);
	}

//---------------------------------------------------------------------------

public StringBuffer format (long p_Number, StringBuffer p_AppendTo, FieldPosition p_Position) 
	{
	return m_NumberFormat.format(p_Number, p_AppendTo, p_Position);
	}

//---------------------------------------------------------------------------

public Number parse(String p_Source, ParsePosition p_Position) 
	{
	p_Source	= p_Source
			.replace('.', ',')				// replace all dots with commas
			.replaceAll(",(?=.*,.*)", "")	// keep only the latest comma, if there are several commas
			.replaceAll("[^\\d|,|-]", "")	// replace all symbols that are not digits and not commas
			.replaceAll(",(?=$)", "")		// if the comma is at the, remove it
			+ " " + m_Symbol;				// append " €" (respectively the currency symbol) to the string
	
	return m_NumberFormat.parse(p_Source, p_Position);
	}

//---------------------------------------------------------------------------	
//***************************************************************************
//* End of Class				                            				*
//***************************************************************************
//---------------------------------------------------------------------------	
}
